/*

 gzilla

 Copyright 1997 Raph Levien <raph@acm.org>

 This code is free for commercial and non-commercial use,
 modification, and redistribution, as long as the source code release,
 startup screen, or product packaging includes this copyright notice.

 */


/* This module provides an API for asynchrnously retrieving URLs from
   the network and feeding them to bytesinks. */

#include <gtk/gtk.h>

#include "gzillaurl.h"
#include "gzillabytesink.h"
#include "gzillahttp.h"
#include "gzillafile.h"
#include "gzillaproto.h"

/* Create a new network connection for URL url, and asynchronously
   feed the bytes that come back to bytesink. */
void
gzilla_get_url (const char *url,
		GzillaByteSink *bytesink,
		void (*status_callback) (const char *status, void *data),
		void *data)
{
  gint proto_num;

  proto_num = gzilla_proto_find (url);
  if (proto_num >= 0) {
    gzilla_proto_get_url (url, proto_num, bytesink, status_callback, data);
  } else if (gzilla_url_match_method (url, "file")) {
    gzilla_file_get (url, bytesink, status_callback, data);
  } else if (gzilla_url_match_method (url, "http")) {
    gzilla_http_get (url, bytesink, status_callback, data);
  }
  /* todo: error message for unknown method. */
}
