#!/bin/sh
#
# Quick-and-dirty script to install NoSQL.
# Author: C.Strozzi <carlos@linux.it>

mkdir bin_tmp 2>/dev/null

echo "Enter path to your Bourne shell [/bin/sh]" >&2
read sh_path
[ -z "${sh_path}" ] && sh_path=/bin/sh

echo "Enter path to your Perl executable [/usr/local/bin/perl]" >&2
read perl_path
[ -z "${perl_path}" ] && perl_path=/usr/local/bin/perl

echo "Processing ..." >&2

# Escape slashes in sed replacement strings
sh_path_e=$(echo ${sh_path} |sed 's/\//\\\//g')
perl_path_e=$(echo ${perl_path} |sed 's/\//\\\//g')

for i in $(ls bin)
do
	if [ -f bin/$i ]
	then
		which_pgm=$(head -1 bin/$i)

		if [ "$(echo ${which_pgm} | grep 'sh$')" ]
		then
			sed '1s/.*/#!'${sh_path_e}'/' bin/$i > bin_tmp/$i

		elif [ "$(echo ${which_pgm} | grep 'perl$')" ]
		then
			sed '1s/.*/#!'${perl_path_e}'/' bin/$i > bin_tmp/$i
		fi
	fi
done

chmod 755 bin_tmp/* 2>/dev/null
			
