.\"
.\" Man page for ftformat
.\"
.\" Copyright (c) 1997 Claus-Justus Heine
.\"
.TH man 1 "October 24, 1997"
.LO 1
.SH NAME
ftformat \- format floppy tape cartridges using the floppy tape kernel
driver ftape
.SH SYNOPSIS
ftformat [\-dh?vV] [\-f FILE] [\-L LABEL] [\-M SIZE]
         [\-m MODE] [\-\-mode=MODE]
         [\-p PARMS] [\-\-format-parameters=PARMS] 
         [\-\-debug] [\-\-help] [\-\-usage] [\-\-verbose]
         [\-\-version] [\-\-file=FILE]
         [\-\-label=LABEL] [\-\-dma-memory=SIZE]
         [\-\-omit-erase] [\-\-discard-header]
         [\-\-no-reference-bursts] [\-\-verify-only]
.SH DESCRIPTION
.B ftformat
formats floppy tape cartridges. It interfaces with the
.B Linux
kernel driver
.B ftape.
This means that you need install a recent version of the
.B ftape
driver as well to be able to format floppy tape cartridges with
.B ftformat.
.SH OPTIONS
.TP
.B "\-\^d, \-\-\^debug"
Turn on debugging mode. Unused yet.
.TP
.B "\-\^h, \-\^?, \-\-\^help, \-\-\^usage"
Print basic help and usage information. TODO: internationalize it.
.TP
.B "\-\^v, \-\-\^verbose"
Increase the verbosity of the program. Multiple instances of
.B \-\^v 
will increase the verbosity level further.
.TP
.B "\-\^V, \-\-\^Version"
Print the version of
.B ftformat
.TP
.B "\-\^f FILE, \-\-\^file=FILE"
Use
.I FILE
as the tape device.
.I FILE
has to one of the raw
.B ftape
character devices, i.e. one of
.I /dev/rawft0,
.I /dev/rawft1,
.I /dev/rawft2
or
.I /dev/rawft3.
The default is to use
.I /dev/rawft0.
You probably will not need this option at all.
.TP
.B "\-\^L LABEL, \-\-\^label=LABEL"
.I LABEL
specifies the label to store in the header segment of the floppy tape
cartridge.
.I LABEL
must not be longer than 44 characters.
.TP
.B "\-\^M SIZE, \-\-\^dma-memory=SIZE"
.I SIZE
spcifies the amount of DMA memory of the kernel driver
.B ftape
which
.B ftformat
will map into its address space while formatting the floppy tape
cartridge.
.I SIZE
gives the size of this memory block in
.I kilobytes
and must be a multiple of
.I 32.
You probably never will need this option.
.TP
.B "\-\-\^omit-erase"
Don't try to erase the old format of the cartridge using the
.-I "physical forward"
and
.I "physical reverse"
commands of the
.I QIC-117
command set. This option affects already formatted cartridges only.
The use of this option is depreciated, but some tape drives don't
implement these commands properly. If you have one of those tape
drives than you might want to  use this option.
.TP
.B "\-\-\^discard-header"
Don't try to read the old header segment. Using this option will
discard statistics and time stamps contained in the header segment.
This option affects already formatted cartridges only.
The use of this option is depreciated when reformatting already
formatted cartridges but should be specified if you know that the
header segments are damaged anyway and can't be read anymore.
.TP
.B "\-\-\^no-reference-bursts"
Don't write the reference bursts, only format and verify. Only useful
with already formatted cartridges. Use of this option is
.B "strongly depreciated."
.TP
.B "\-\-\^verify-only"
Only update the bad sector map, don't reformat.
Only possible with already formatted cartridges.
The use of this option is
.B "strongly depreciated."
.TP
.B "\-\^m MODE, \-\-\^mode=MODE"
.I MODE
has to be one out of 
.I "{auto, force, probe}."
.I auto
is the default.
.I force
will bypass almost all consistency checks, assuming
.B "THAT YOU REALLY KNOW WHAT YOU ARE DOING,"
.I probe
performs the auto-detection only and prints a line
that is suitable to be used as command line argument with the
.I force
mode.
.TP
.B "\-\^p PARMS, \-\-\^format-parameters=PARMS"
This option allows to overwrite the auto-detected values, or help when
the format of the inserted cartridge cannot be auto-detected
(e.g. 205ft QIC-80 cartridges versus 425ft QIC-80 cartridges). With
.I "\-\-\^mode=force"
.B ALL
of the parameters below must be
specified.
.B WITHOUT
 .I "\-\-\^mode=force"
the parameters given in
.I PARMS
are used as supplements to the auto-detected values. In this case some
of the values can be omitted.
.I PARMS
is a comma separated list of one or more of the following parameters:
.sp
.I qic-standard=QIC_STD,
.I format-code=FORMAT_CODE,
.I floppy-head-max=MAX_FLOPPY_HEAD,
.I floppy-track-max=MAX_FLOPPY_TRACK,
.I segments-per-track=SEGMENTS_PER_TRACK,
.I tracks-per-tape=TRACKS_PER_TAPE,
.I gap3=GAP3.
.sp
Please refer to the next section 
.B FORMART PARAMETERS
for further explanations.

.SH "FORMAT PARAMETERS"
You need to set all of these parameters when using the
.I \-\-\^mode=force
switch. Otherwise you probably want to specify
.I \-\-\^qic-standard=QIC_STD
only. There are some short-cuts for various
fixed length formats. Note that each shortcut is a place holder for a
full set of "low level" options, i.e. use them like
.sp
.ce
--format-parameters qic80-307ft
.sp
.TS
center tab(/);
l l l l
l l l l.
abbreviation/length/format/capacity
=
qic40-205ft/205ft/QIC-40/40MB
qic40-307ft/307ft/QIC-40/60MB
qic40-1100ft/1100ft/QIC-40/210MB
qic80-205ft/205ft/QIC-80/80MB
qic80-307ft/307ft/QIC-80/120MB
qic80-425ft/425ft/QIC-80/170MB
qic80-1100ft/1100ft/QIC-80/400MB
.TE
.sp
Please refer to the development standards
.sp
.ce
QIC-40, QIC-80, QIC-3010 and QIC-3020
.sp
to be found at
.sp
.ce
.B http://www.qic.org
.sp

for the correct settings of
.sp
.I QIC_STD,
.I FORMAT_CODE,
.I MAX_FLOPPY_HEAD,
.I MAX_FLOPPY_TRACK,
.I SEGMENTS_PER_TRACK,
.I TRACKS_PER_TAPE
and
.I GAP3.
.sp
Normally, you only want to use one of the short cuts, or give the
desired tape format, i.e. the
.I QIC_STD,
or override the number of segments per track (use the latter with
extreme prejudice).
.TP
.B qic-standard=QIC_STD
.I QIC_STD
has to be one out of
.sp
.I QIC-40,
.I QIC-80
.I QIC-80/WIDE,
.I TR-1,
.I QIC-3010,
.I QIC-3010/WIDE,
.I QIC-3020,
.I QIC-3020/WIDE,
.I TR-3.
.sp
You may as well give a number in hexadecimal or decimal
representation specifying what would be the result of a
.I REPORT_TAPE_STATUS
QIC-117 tape drive command.
.sp
.I TR-3
cartridges conform to the
.I QIC-3020/WIDE
standard.
.I TR-3/Extra
cartridges are extra length
.I TR-3
cartridges and thus also conform to
.I QIC-3020/WIDE.
.I TR-1
cartridges conform to
.I QIC-80/WIDE.
.TP
.B format-code=FORMAT_CODE
A decimal number to be stored in the appropriate field in the header
segments.
.TP
.B floppy-head-max=MAX_FLOPPY_HEAD
A decimal number to be stored in the appropriate field in the header
segments.
.TP
.B floppy-track-max=MAX_FLOPPY_TRACK
A decimal number to be stored in the appropriate field in the header
segments.
.TP
.B segments-per-track=SEGMENTS_PER_TRACK
The number of tape segments per tape track.
.TP
.B tracks-per-tape=TRACKS_PER_TAPE
The number of tape tracks per cartridge.
.TP
.B gap3=GAP3
.I GAP3
is the size of the erased gap between the sector of a floppy tape
segment. This has to be
.I 233
for
.I QIC-40
and
.I QIC-80
cartridges
and
.I 248
for
.I QIC-3010
or
.I QIC-3020
cartridges.

.SH EXAMPLES
Auto-detect the format parameters of a Travan-3 cartridge:
.sp
.ce
ftformat --mode=probe --format-parameters qic-standard=TR-3
.sp
Format a 425ft QIC-80 cartridge (ONLY possible with certain tape
drives):
.sp
.ce
ftformat --mode=auto --format-parameters qic80-425ft
.sp
Format an unformatted Travan-3 cartridge:
.sp
.ce
ftformat --mode=auto --format-parameters qic-standard=TR-3
.sp
Reformat a Travan-3 cartridge with damaged format:
.sp
.ce 
ftformat --mode=auto --format-parameters qic-standard=TR-3 \\
--omit-erase --discard-header

.SH ENVIRONMENT
Unused.

.SH "SEE ALSO"
insmod(1), rmmod(1), depmod(1), lsmod(1), modprobe(1).

.SH BUGS
There are most probably bugs in this program. If you find one, notify
the maintainer of
.B
ftape.
