.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkInitia.man,v 2.1 1994/04/21 00:46:44 kuma Exp $ NEC;
.TH "RKINITIALIZE" "3"
.SH "NAME"
\f4RkInitialize\f1 \- initialize the kana-kanji conversion functions
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkInitialize(dhdpath)
char *dhdpath;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkInitialize\f1 initiates the kana-kanji conversion functions.  \f2dhdpath\f1 names the dictionary home directory.
.P
Because this library permits multiple kana-kanji conversions to proceed concurrently, it uses the conversion context method of control to manage the kana-kanji conversions.  Each context contains internal data needed to perform a kana-kanji conversion.
.P
Users identify the conversion contexts from one another by their context number.  A context number is an integer of 0 or greater and is used as the first parameter of the kana-kanji conversion function.
.P
Right after the kana-kanji conversion functions are initialized by \f2RkInitialize\f1, only the standard context with context number 0 exists.  Applications using only one context can use the standard context.
.SH "RETURN VALUE"
This function returns \f40\f1 if successful; otherwise, it returns \f4-1\f1.  
.SH "SEE ALSO"
.na
\f4RkFinalize\f1(3)
.ad
