;; $Id: dblink.dsl 1.0 1997/12/30 17:30:52 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= LINKS AND ANCHORS ==========================

(element LINK
  (let* ((endterm (attribute-string "ENDTERM"))
	 (linkend (attribute-string "LINKEND"))
	 (target  (if endterm
		      (element-with-id endterm)
		      (element-with-id linkend))))
    (if (node-list-empty? target)
	(if endterm
	    (literal "LINK ENDTERM POINTS TO NON-EXISTANT ID: " endterm)
	    (process-children))
	(if endterm
	    (make link 
	      destination: (node-list-address (element-with-id endterm))
	      (with-mode xref-endterm-mode (process-element-with-id endterm)))
	    (make link 
	      destination: (node-list-address (element-with-id linkend))
	      (process-children))))))

(element OLINK ($charseq$))
(element ULINK ($charseq$))

(element FOOTNOTEREF 
  (process-element-with-id (attribute-string "LINKEND")))

(element ANCHOR (empty-sosofo))
(element BEGINPAGE (empty-sosofo))

;; ======================================================================

(element XREF
  (let* ((endterm (attribute-string "ENDTERM"))
	 (linkend (attribute-string "LINKEND"))
	 (target  (element-with-id linkend)))
    (if (node-list-empty? target)
	(literal "[xref to non-existent element '" linkend "']")
	(if endterm
	    (if (node-list-empty? (element-with-id endterm))
		(literal "[xref endterm to non-existent element '" endterm "']")
		(make link 
		  destination: (node-list-address (element-with-id endterm))
		  (with-mode xref-endterm-mode 
		    (process-element-with-id endterm))))
	    (make link 
	      destination: (node-list-address target)
	      (if (attribute-string "XREFLABEL" target)
		  (xreflabel-sosofo (attribute-string "XREFLABEL" target))
		  (auto-xref target)))))))

(mode xref-endterm-mode
  (default
    (make sequence
      font-posture: 'italic
      (process-children-trim))))

(define (xreflabel-sosofo xreflabel)
  (make sequence
    font-posture: 'italic
    (literal xreflabel)))

;; ======================================================================

;; Returns the title of the element as a sosofo, italicized for xref.
;;
(define (element-title-xref-sosofo nd)
  (make sequence
    font-posture: 'italic
    (element-title-sosofo nd)))

(mode xref-title-mode
  (default
    (process-children-trim)))

;; ======================================================================

(define (element-page-number-sosofo target)
  (with-mode pageno-mode
	(process-node-list target)))

(mode pageno-mode
  (default
    (current-node-page-number-sosofo)))

;; ======================================================================

