// query_templates.C

#ifndef QUERY_TEMPLATES_C
#define QUERY_TEMPLATES_C

#include "query_templates.h"
#include <String.h>

template <class Type>
Query<Type>::~Query() {
	delete setterGetter;
}

// convert whatever Type value is contained within into a char string
// the cast on this->tmpbuf allows writing into this const buffer, which is used
// for no other purpose than to store the string which is returned

template <class Type>
const char *
Query<Type>::get() const {
	return toString( ((Query<Type> *) this)->tmpbuf, setterGetter->get() );
}

// convert string to value of type Type, convert to double and confine it
// to the bounds Range, convert back to Type, and set the value

template <class Type>
boolean
Query<Type>::checkAndSet(const char* s) {
	Type t = Type(bounds.confine(double(fromString(s, (Type) 0))));
	return setterGetter->set(t);
}

template <class Type>
QueryItem::QueryType
Query<Type>::type() {
	return displayBounds ? RangedValue : Value;
}

#endif

