/*================================================================
 * Miscellaneous configuration for drvmidi
 *================================================================*/

#ifndef CONFIG_H_DEF

#include "util.h"
#include "midievent.h"

/* resource files; uncomment these definitions if you don't want to
 * use user and system resource files
 */
#define RCFILE	".drvmidirc"
#define SYSTEM_RCFILE "/etc/drvmidirc"

/* chorus mode: 0 - 7 */
#define DEF_CHORUS_MODE		2

/* chorus depth: 0 - 127 */
#define DEF_CHORUS_DEPTH	0

/* reverb mode: 0 - 7 */
#define DEF_REVERB_MODE		4

/* reverb depth: 0 - 127 */
#define DEF_REVERB_DEPTH	0

/* volume: 0 - 200 */
#define DEF_VOLUME		100

/* bass: 0 - 11 */
#define DEF_BASS		5

/* treble: 0 - 11 */
#define DEF_TREBLE		9

/* accept all off events */
#define DEF_ALLOFF	TRUE

/* do realtime pan change: boolean */
#define DEF_REALTIME_PAN	TRUE

/* check note-off events in same centi second: boolean */
#define DEF_CHECKCS		TRUE

/* accept GS drum change sysex: boolean */
#define DEF_GSMACRO		TRUE

/* accept XG bank controls: boolean */
#define DEF_XGMACRO		TRUE

/* load XG map file automatically: boolean */
#define DEF_XGMAP		FALSE

/* use channel priority control */
#define DEF_CHN_PRIOR		FALSE

/* default drum channels: 32 bit flags */
#define DEF_DRUMFLAG	(DRUMBIT(9) | DRUMBIT(25))

/* default multi part mode: boolean */
#define DEF_MULTIPART	FALSE

/* default number of tracks for the first MIDI part: -1 or 0-31 */
#define DEF_TRACKS	16

/* default volume scale parameter: from 0 - 500 (in percent) */
#define DEF_VOLSCALE	100

/* auto skip blank mode: boolean */
#define DEF_SKIPBLANK	FALSE

/* parse the title text in midi files */
#define DEF_PARSETITLE	TRUE

/* sequencer buffering modes */
#define DEF_SEQ_BUFFERED	TRUE
#define DEF_USE_ECHOBACK	TRUE

/* enable effect controls (experimental) */
#define DEF_USEFX	FALSE

/*----------------------------------------------------------------
 * effect sensitivity
 *----------------------------------------------------------------*/

#define DEF_FX_CUTOFF		170
#define DEF_FX_RESONANCE	6
#define DEF_FX_ATTACK		50
#define DEF_FX_RELEASE		50
#define DEF_FX_VIBRATE		30
#define DEF_FX_VIBDEPTH		4
#define DEF_FX_VIBDELAY		1500

#endif
