#! /bin/sh
#
# $Id: mkstamp.sh,v 3.1.2.1 1997/04/30 06:32:19 hzoli Exp $
#
# Written by Andrew Main
#
srcdir=${srcdir-`echo $0|sed 's%/[^/][^/]*$%%'`}
test "x$srcdir" = "x$0" && srcdir=.
test "x$srcdir" = "x"   && srcdir=.
CFSED=${CFSED-"-f $srcdir/conf.sed"}
MODBINS=${MODBINS-modules-bltin}
MODCF=${MODCF-$srcdir/mods.conf}
MODULE_DIRS=${MODULE_DIRS-'Modules Zle'}
MAKE=${MAKE-make}
STMP=$1

act="rm -f `pwd`/$STMP"
trap "rm -f $STMP.tmp; exit 1" 1 2 15
echo > $STMP.tmp
for mod in `cat $MODBINS`; do
    sed='/^ *'$mod' *:[^:>!]*$/{
             s/.*://
             p
         }'
    objs=`sed -n $CFSED -e "$sed" $MODCF`
    if test -z "$objs"; then
	for dir in $MODULE_DIRS; do
	    if test -f $srcdir/$dir/$mod.c; then
		objs=$dir/$mod.o
		break
	    fi
	done
	if test -z "$objs"; then
	    echo >&2
	      "ERROR: don't know how to build module $mod"
	    rm -f $STMP.tmp
	    exit 1
	fi
    fi
    bdir=`echo $objs | sed 's, .*$,,;s,^,./,;s,/[^/]*$,,'`
    bobjs=`echo '' $objs | sed 's, [^ ]*/, ,g'`
    (cd $bdir && eval "$MAKE $MAKEDEFS EXTRA_BUILDACT=\"\$act\" \$bobjs") ||
	{ rm -f $STMP.tmp; exit 1; }
    echo $objs >> $STMP.tmp
done
if cmp -s $STMP.tmp $STMP; then
    rm -f $STMP.tmp
    echo "\`$STMP' is up to date."
else
    mv -f $STMP.tmp $STMP
    echo "Updated \`$STMP'."
fi
