/*  VER 007   TAB P   $Id: mfilter.c,v 1.1 1997/08/14 13:40:42 src Exp $
 *
 *  filter based on message ID
 *
 *  copyright 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"

#include <fcntl.h>

/*
 *  return a status as to whether the message should be removed
 *  based on the message ID
 */
int  
do_mfilter(char *msgid)
{
    int inf,outf;
    int st;
    char buf[2048];

    if (!mfilter) return 0;

    progtitle("mfilter");
    inf = open("/dev/null",O_RDWR);
    outf = dup(inf);	  
    /* BUG: silly... */
    sprintf(buf, "%1024.1024s \"%512.512s\"",mfilter,msgid);
    st = script(buf,inf,outf);
    close(inf);
    close(outf);

    switch (st) {
    case -1:
	log_msg(L_ERR,"can't run mfilter: %s",mfilter);
	mfilter = 0; /* give up filter */
	break;
    case 0:
	log_msg(L_DEBUG4,"no filter for %s",msgid);
	return 0;
    default:
	log_msg(L_DEBUG,"filtering %s",msgid);
	return 1;
    }
}

