/*  VER 205   TAB P   $Id: main.c,v 1.2 1997/08/14 13:39:44 src Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  Husebybakken 14A, N-0379 Oslo, Norway	  
 *
 *  this program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  this program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  see the
 *  GNU General Public License for more details.
 *
 *  you should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "patchlevel.h"

#include "getopt.h"

static void 
pickargs(int argc,char *argv[],char *envp[]);
static void 
numarg(char *arg,int *where, char option);
static void 
stringarg(char *arg,char **where, char option);
static void 
timearg(char *arg,long *where, char dflt, char option);

char *newline = "\r\n";

/*
 *  main 
 */
int 
main(int argc, char *argv[], char *envp[])
{
    char *p,*q;
    int ok;

    /* initialize and set the name of the program */
    for (q=argv[0]; (p=strchr(q,'/')); ) q = p+1;
    stringarg(q,&pname,0);
    begintitle(argc,argv,envp);

    /* plus some command line defaults */
    nopull_opt = 0;
    inn_opt = INN_MODE;
    minspool = MINSPOOL;

    /* parse the args */
    pickargs(argc,argv,envp);

    /* defaults */
    if (!spoolname) spoolname = getenv("NNTPSERVER");
    if (!spooldir) stringarg(SPOOL,&spooldir,0);

    /* do what we were told */
    ok = doit();

    /* remove locks */
    history_done();
    unlock();

    return ok;
}

/*
 *  pick arguments from command line
 *  NOTE: the actual command line will be cleared after this
 *	  so all strings will be lost and must be thus be copied as reqd.
 */
static void 
pickargs(int argc,char *argv[],char *envp[])
{
    int c;
    char *p;
    char name[PATH_MAX+PATH_MAX];
	
    int digit_optind = 0;

    for (;;) {
	int option_index = 0;
	static struct option long_options[] = {
	   /* char *name, int has_arg, int *flag, int val */
	    {"auth",	    1, 0, 'a'},
	    {"size",	    1, 0, 'b'},
	    {"cnews",	    0, 0, 'c'},
	    {"end",	    1, 0, 'e'}, 
	    {"posted",	    1, 0, 'f'}, 
	    {"nofetch",     0, 0, 'g'},
	    {"history",     1, 0, 'h'},
	    {"inn",	    0, 0, 'i'},
	    {"keeppath",    0, 0, 'k'},
	    {"log",	    1, 0, 'l'}, 
	    {"nomsgid",     0, 0, 'm'},
	    {"noaction",    0, 0, 'n'},
	    {"keepold",     0, 0, 'o'},
	    {"nopost",	    0, 0, 'p'},
	    {"reader",	    0, 0, 'r'},
	    {"spool",	    1, 0, 's'},
	    {"timeout",     1, 0, 't'},
	    {"noforce",     0, 0, 'u'},
	    {"version",     0, 0, 'v'},
	    {"chat",	    1, 0, 'w'},
	    {"exec",	    1, 0, 'x'},
	    {"connect",     1, 0, 'y'},
	    {"sync",	    0, 0, 'z'},
	    {"active",	    1, 0, 'A'},
	    {"batch",	    1, 0, 'B'},
	    {"ctlinnd",     1, 0, 'C'},
	    {"debug",	    1, 0, 'D'},
	    {"continue",    0, 0, 'E'},
	    {"fail",	    1, 0, 'F'}, 
	    {"newlist",     1, 0, 'G'},
	    {"home",	    1, 0, 'H'},
	    {"incoming",    1, 0, 'I'},
	    {"ihave",	    0, 0, 'J'},
	    {"inhosts",     1, 0, 'K'},
	    {"list",	    1, 0, 'L'},
	    {"mfilter",     1, 0, 'M'},
	    {"newsfeeds",   1, 0, 'N'}, /* BUG: */
	    {"bounce",	    1, 0, 'O'}, 
	    {"locks",	    1, 0, 'P'}, 
	    {"stat",	    1, 0, 'Q'}, 
	    {"reset",	    0, 0, 'R'},
	    {"sys",	    1, 0, 'S'}, /* BUG: */
	    {"togo",	    1, 0, 'T'},
	    {"rnews",	    0, 0, 'U'},
	    {"window",	    1, 0, 'W'},
	    {"newline",     0, 0, 'X'},
	    {"noreader",    0, 0, 'Y'},
	    {"syncnew",     0, 0, 'Z'},
	    {"attach",	    1, 0, '1'}, 
	    {"desc",	    1, 0, '2'}, 
	    {"alldesc",     1, 0, '3'}, 
	    {0, 0, 0, 0}
	};

	c = getopt_long(argc,argv,
		    "a:b:cde:f:gh:ikl:mnoprs:t:uvw:x:y:zA:B:H:I:LN:RT:W:Z",
		    long_options, &option_index);
	if (c == EOF) break;

	switch (c) {
	case 'a':			/* do an authinfo */
	    if (ai_username) goto usage;
	    get_authinfo(optarg);
	    break;
	case 'b':			/* min spool size in bytes */
	    numarg(optarg,&minspool,c);
	    break;
	case 'c':			/* C News mode */
	    inn_opt=0;
	    break;
	case 'd':			/* debugging on */
	    debug_opt++;
	    break;
	case 'e':			/* end at tag */
	    for (p=optarg; isspace(*p); ++p) ; /* remove any leading blanks */
	    stringarg(p,&end_tag,c);
	    break;
	case 'f':			/* folder */
	    stringarg(optarg,&folder,c);
	    break;
	case 'h':			/* history file */
	    stringarg(optarg,&history,c);
	    break;
	case 'g':			/* don't get news */
	    ++nopull_opt;
	    break;
	case 'i':			/* INN mode */
	    inn_opt=1;
	    break;
	case 'k':			/* keep "Path" */
	    keep_path_opt = 1;
	    break;
	case 'l':			/* logfile */
	    stringarg(optarg,&logfile,c);
	    break;
	case 'n':			/* do nothing */
	    noaction_opt++;
	    break;
	case 'm':			/* skip message ID */
	    if (ihave_opt) goto usage;	/* impossible */
	    nomsgid_opt++;
	    break;
	case 'o':			/* keep .old */
	    keep_old_opt++;
	    break;
	case 'p':			/* no posting */
	    nopost_opt++;
	    break;
	case 'r':			/* do a 'MODE READER' */
	    mode_reader_opt = 1;
	    break;
	case 'Y':			/* don't do a 'MODE READER' */
	    mode_reader_opt = -1;
	    break;
	case 's':			/* spool */
	    stringarg(optarg,&spooldir,c);
	    break;
	case 't':			/* timeout in seconds */
	    timearg(optarg,&timeout,'s',c);
	    break;
	case 'u':			/* no unlock by force */
	    noforce_opt++;
	    break;
	case 'w':			/* -w chat */
	    stringarg(optarg,&chat_file,c);
	    break;
	case 'v':			/* version */
	    printf("%s version %s%s\n", pname, VERSION, PATCHLEVEL);
	    unlock_exit(0); /* that's ok */
	    break;
	case 'x':			/* -x connect script */
	    stringarg(optarg,&connect_exec,c);
	    break;
	case 'y':			/* -y connect via */
	    stringarg(optarg,&via_exec,c);
	    break;
	case 'z':			/* zero incoming */
	    if (reset_opt || zapnew_opt) goto usage;
	    zap_opt++;
	    break;
	case 'A':			/* active file */
	    stringarg(optarg,&active,c);
	    break;
	case 'B':			/* batch directory */
	    stringarg(optarg,&batch,c);
	    break;
	case 'C':			/* ctlinnd program */
	    stringarg(optarg,&ctlpgm,c);
	    break;
	case 'D':			/* debug */
	    numarg(optarg,&debug_opt,c);
	    break;
	case 'E':			/* continue, ignoring some errors */
	    ++conterr;
	    break;
	case 'F':			/* fail after specified time */
	    if (strcmp(optarg,"never")==0) {
		failtime=0;
	    } else {
		timearg(optarg,&failtime,'h',c);
		if (failtime==0) failtime=1;
	    }
	    break;
	case 'G':			/* get list of new groups */
	    stringarg(optarg,&group_newlist,c);
	    break;
	case 'H':			/* news home directory */
	    stringarg(optarg,&newshome,c);
	    break;
	case 'I':			/* incoming directory */
	    stringarg(optarg,&incoming,c);
	    break;
	case 'J':			/* ihave */
	    if (nomsgid_opt) goto usage;
	    ihave_opt++;
	    break;
	case 'L':			/* get list of groups */
	    stringarg(optarg,&group_list,c);
	    break;
	case 'K':			/* in.hosts directory */
	    stringarg(optarg,&inhosts,c);
	    break;
	case 'M':			/* mfilter */
	    stringarg(optarg,&mfilter,c);
	    break;
	case 'N':			/* newsfeeds file */
	case 'S':			/* sys file */
	    stringarg(optarg,&newsfeeds,c);
	    break;
	case 'O':			/* bounce */
	    stringarg(optarg,&bounce,c);
	    break;
	case 'P':			/* locks */
	    stringarg(optarg,&locks,c);
	    break;
	case 'Q':			/* stat */
	    stringarg(optarg,&statfile,c);
	    break;
	case 'R':			/* reset incoming */
	    if (zap_opt || zapnew_opt) goto usage;
	    reset_opt++;
	    break;
	case 'T':			/* togo file */
	    stringarg(optarg,&togo,c);
	    break;
	case 'U':			/* rnews */
	    rnews_opt++;
	    break;
	case 'W':			/* window size */
	    numarg(optarg,&window,c);
	    break;
	case 'X':			/* newline */
	    newline = "\n";
	    break;
	case 'Z':			/* zero new groups */
	    if (reset_opt || zap_opt) goto usage;
	    zapnew_opt++;
	    break;
	case '1':			/* attach */
	    if (strcmp(optarg,"mime")==0 || strcmp(optarg,"m")==0) {
		attach = 0; /* default */
	    } else if (strcmp(optarg,"yes")==0 || strcmp(optarg,"y")==0) {
		attach = 'y';
	    } else if (strcmp(optarg,"no")==0 || strcmp(optarg,"n")==0) {
		attach = 'n';
	    } else {
		fprintf(stderr,"%s: unknown --attach mode: %s\n",
				pname,			   optarg);
	    }
	    break;
	case '2':			/* get description of groups */
	    stringarg(optarg,&group_desc,c);
	    break;
	case '3':			/* get description of all groups */
	    stringarg(optarg,&group_alldesc,c);
	    break;
	default:
	  usage:
	    /* BUG: have a more complete list! */
	    fprintf(stderr,"usage: %s spool [[server] port]\n", pname);
	    unlock_exit(2);
	}
    }
    
    /* get spool name */
    if (optind < argc) {
	if (argv[optind][0]) {
	    stringarg(argv[optind],&spoolname,0);
	}
	++optind;
    } 
    if (!spoolname || !spoolname[0]) {
	fprintf(stderr, "spool name missing\n");
	goto usage;
    }

    /* get server name */
    if (optind < argc) {
	if (argv[optind][0]) {
	    stringarg(argv[optind],&hostname,0);
	}
	++optind;
    }
    if (!hostname || !hostname[0]) hostname = spoolname;
    
    /* get port name */
    if (optind < argc) {
	if (argv[optind][0]) {
	    stringarg(argv[optind],&hostport,0);
	}
	++optind;
    } 
    if (!hostport || !hostport[0]) hostport = NNTP_PORT;

    if (optind < argc) {
	fprintf(stderr, "excess arguments\n");
	goto usage;
    }

    /* set the program title for "ps" */
    sprintf(name,"%s(%s)",pname,spoolname);
    settitle(name);
}

/*
 *  handle numeric argument
 */
static void 
numarg(char *arg,int *where, char option)
{
    int a;
    char *p;

    a = strtol(arg,&p,10);
    if (p == arg || *p) {
	fprintf(stderr,"%s: bad numeric spec for option -%c: %s\n",
			pname,			     option,  arg);
	return;
    }

    if (*where && *where != a) {
	if (option) {
	    fprintf(stderr,"%s: option -%c was \"%d\", respecified as \"%d\"\n",
			    pname,	option, *where, 	     a);
	} else {
	    fprintf(stderr,"%s: argument was \"%d\", respecified as \"%d\"\n",
			    pname,	      *where,		   a);
	}
    }
    *where = a;
}

/*
 *  handle string argument
 *  move to heap
 */
static void 
stringarg(char *arg,char **where, char option)
{
    char *p;

    if (*where) {
	if (option) {
	    fprintf(stderr,"%s: option -%c was \"%s\", respecified as \"%s\"\n",
			    pname,	option, *where, 	     arg);
	} else {
	    fprintf(stderr,"%s: argument was \"%s\", respecified as \"%s\"\n",
			    pname,	      *where,		   arg);
	}
    }
    if (!(p = malloc(strlen(arg)+1))) {
	fprintf(stderr,"%s: out of memory\n",pname);
	unlock_exit(2);
    }
    *where = strcpy(p,arg);
}

/*
 *  time multiplier
 */
static int  
timemul(char c, long *where)
{
    switch (c) {
    case 'w': /* weeks */
	*where *= 7;
    case 'd': /* days */
	*where *= 24;
    case 'h': /* hours */
	*where *= 60;
    case 'm': /* minutes */
	*where *= 60;
    case 's': /* seconds */
	return 1;
    default:
	return 0;
    }
}
/*
 *  handle expire time argument
 */
static void 
timearg(char *arg,long *where, char dflt, char option)
{
    int a = 0;
    long n;
    char *p;

    if (*where) {
	fprintf(stderr,"%s: option -%c was respecified as \"%s\"\n",
			pname,	    option,		   arg);
    }
    *where = 0;
    do {
	++a;
	n = strtol(arg,&p,10);
	if (p == arg) {
	    fprintf(stderr,"%s: bad time spec for option -%c: %s\n",
			    pname,		     option,  arg);
	    break;
	}
	if (timemul(*p,&n)) ++p;
	else if (!*p) timemul(dflt,&n);
	*where += n;
    } while (*(arg = p));
}


