/*  VER 067  TAB P   $Id: despool.c,v 1.2 1997/08/14 13:39:43 src Exp $
 *
 *  do the posting 
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"
#include "stat.h"

/* 
 *  globals for despool_line
 */
char basicname[PATH_MAX];
char retryname[PATH_MAX];
char togoname[PATH_MAX];
char old_name[PATH_MAX];
FILE *togofp = NULL;
FILE *retryfp = NULL;
char buf[BUFSIZ];
int articles = 0;

/*
 *  despool, find next article_name
 *  also handles cleaning up afterwards
 *  return static pointer, NULL if no more
 */
char *
despool_line(void)
{
    char *p;
    int sts;
    FILE *f,*f2;
    struct stat st;

    if (!togofp) {
	char batchdir[PATH_MAX];

	progtitle("locking spool");

	/* file not open yet: prepare names */
	build_alt_filename(batchdir,SPOOL,BATCH,batch);
	build_alt_filename(basicname,batchdir,spoolname,NULL);

	if (inn_opt) {
	    /* 
	     * INN style:
	     * 1. apply lock for other newsxes	  
	     * 2. open outgoing spool
	     * 3. if a spool.togo exists: rename/append it to spool.retry
	     * 4. rename the spool file to spool.togo
	     * 5. do a ctlinnd flush spoolname
	     * 6. if a spool.retry exists: append it to spool.togo and erase
	     * 
	     * when posting:
	     * 7. any articles with problems go to spool.retry
	     *
	     * when finished:
	     * 8. get rid of spool.togo
	     * 9. rename spool.retry to spool.togo if it exists
	     *
	     * suggested by Arne Georg Gleditsch <arnegl@ifi.uio.no>
	     * and J. Richard Sladkey <jrs@foliage.com>
	     */

	    /* lock other newsxes out first */
	    char lockname[PATH_MAX];
	    /* BUG: just spoolname??? */
	    /* build_filename(lockname,I_LOCK,"newsx",".",spoolname); */
	    build_filename(lockname,I_LOCK,spoolname,NULL,NULL);
	    lock("",lockname);

	    /* prepare the names we will be using */
	    /* BUG: spoolname.togo */
	    build_filename(togoname,basicname,_TOGO,NULL,NULL);
	    build_filename(retryname,basicname,_RETRY,NULL,NULL);
	    build_filename(old_name,basicname,_OLD,NULL,NULL);

	    /* open spool file proper */
	    progtitle("open spool");
	    if ((togofp = fopen(basicname,"r+")) == NULL) {
		log_msg(L_ERRno,"can't open INN spool \"%s\"", basicname);
		if (conterr) return NULL; /* continue fetching... */
		unlock_exit(5); 
	    }

	    /* verify that it is a regular file */
	    if (!is_regular(togofp,basicname)) {
		/* NOTE: will usually mean we use INN flag under C News */
		if (S_ISDIR(st.st_mode)) {
		    /* see if probable C News spool */
		    build_filename(togoname,basicname,"/",C_TOGO,NULL);
		    if (stat(togoname,&st) >= 0 && S_ISREG(st.st_mode)) {
			log_msg(L_ERR,"you specified '-i' for a C News spool");
		    }
		}
		fclose(togofp);
		unlock_exit(5);
	    }

	    /* check that previous articles must be handled */
	    if (f=fopen(togoname,"r")) {
		/* yes, is there a previous .retry file also? */
		if (f2=fopen(retryname,"r+")) {
		    if (!append_file(f2,retryname,f)) unlock_exit(5);
		    fclose(f);
		    fclose(f2);
		    unlink(togoname);
		} else {
		    fclose(f);
		    if (!rename_file(togoname,retryname)) unlock_exit(5);
		}
	    }

	    progtitle("rename spool");
	    if (!rename_file(basicname,togoname)) unlock_exit(5);
		 
	    /* make innd flush this spool */
	    progtitle("ctlinnd flush");
	    if ((sts=ctlinnd(INN_CTL_FLUSH,spoolname)) != 0) {
		/* ctlinnd failed... */
		log_msg(L_ERR,"ctlinnd %s failed, returned status %d",
			       INN_CTL_FLUSH,sts);
		if (conterr) return NULL; /* continue fetching... */
		unlock_exit(5); 
	    }
    
	    /* append the contents from any previous retries... */
	    if (f=fopen(retryname,"r")) {
		if (!append_file(togofp,togoname,f)) unlock_exit(5);
		fclose(f); 
		unlink(retryname);
	    }

	} else {
	    /* 
	     * C News style:
	     * 1. lock togo-file
	     * 2. open togo-file
	     */

	    /* lock file first */
	    lock(basicname,C_LOCK);

	    /* then prepare name of file */
	    build_alt_filename(togoname,basicname,C_TOGO,togo);

	    progtitle("open spool");
	    log_msg(L_DEBUG4,"opening outgoing \"%s\"",togoname);
    
	    build_filename(retryname,togoname,_RETRY,NULL,NULL);
	    build_filename(old_name,togoname,_OLD,NULL,NULL);
    
	    /* open spool file proper */
	    if ((togofp = fopen(togoname,"r")) == NULL) {
		log_msg(L_ERRno,"can't open C spool \"%s\"", togoname);
		if (conterr) return NULL; /* continue fetching... */
		unlock_exit(5);
	    }
	    /* verify that it is a regular file */
	    if (!is_regular(togofp,togoname)) {
		fclose(togofp);
		unlock_exit(5);
	    }
    
	    log_msg(L_DEBUG4,"opened spool file \"%s\"",togoname);
	}
    }

    /* read the next line */
    progtitle("read togo");

    while (fgets(buf,sizeof(buf),togofp)) {
	++articles;
	/* assume that filename is first, regardless */
	/* extract filename proper */
	for (p=buf; *p; ++p) {
	    if (*p == ' ') {
		*p = '\0';
		break;
	    }
	    if (*p == '\n') {
		*p = '\0';
		break;
	    }
	}
	/* if not empty, then it's kosher */
	if (buf[0]) return buf;
    } 

    /* spool file empty, clean up */
    if (fclose(togofp) == EOF) {
	log_msg(L_ERRno,"error reading \"%s\"", togoname);
	unlock_exit(5);
    }
    
    if (!noaction_opt && articles > 0) {
	/* something happened */
	progtitle("closing spool");

	if (retryfp && fclose(retryfp) == EOF) {
	    log_msg(L_ERRno,"error closing \"%s\"", retryname);
	    unlock_exit(5);
	}

	/* creating spool backup, overwriting the previous */
	if (!rename_file(togoname,old_name)) unlock_exit(5);

	if (retryfp) {
	    /* there are failed postings -- keep them untill next time */
	    if (!rename_file(retryname,togoname)) unlock_exit(5);
	} else {
	    if (!inn_opt) {
		/* C news: must make new empty spool queue */
		if ((togofp = fopen(togoname, "w")) == NULL
		    || fclose(togofp) == EOF) {
		    log_msg(L_ERRno,"can't create spool \"%s\"", togoname);
		    unlock_exit(5);
		}
	    }
	}

	if (!keep_old_opt) {
	    /* and finally remove the old togo-file */
	    if (unlink(old_name) == EOF) {
		log_msg(L_ERRno,"can't unlink batch file \"%s\"", old_name);
		unlock_exit(5);
	    }
	}
    }
    return (char *)0;
}

/*
 *  initial article_name is given
 */
void 
despool(char *article_name)
{
    do {
	/* post the article in question */
	if (!submit_article(article_name)) {
	    /* no success: write to temp file */

	    if (!noaction_opt) {
		if (!retryfp) {
		    /* open "retry" file */
		    if ((retryfp = fopen(retryname, "a")) == NULL) {
			log_msg(L_ERRno,"can't create \"%s\"",
							    retryname);
			unlock_exit(5);
		    }
		}
    
		/* NOTE: looses rest of line -
		 * OK since probably only we'll ever see it again */
		strcat(buf,"\n");
		if (fputs(buf, retryfp) == EOF) {
		    log_msg(L_ERRno,"can't write \"%s\"", retryname);
		    unlock_exit(5);
		}
	    }
	}
    } while ((article_name = despool_line()));
}
