/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: get_info.c,v 2.3 1997/02/05 22:35:38 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

void get_info()
{
	char *s, **t;
	if( version ){
		for( t = copyright; (s = *t); ++t ){
			fprintf( stderr, "%s\n", s );
		}
		fflush(stderr);
	}
	if( name && (s = strrchr(name, '/' )) ){
		name = s+1;
	}
	if( !strcasecmp( name, OFHP ) ){
		log(2,"filter '%s'", name );
		of_filter = 1;
	} else if( format && *format == 'o' ){
		log(2,"format '%s'", format );
		of_filter = 1;
	}

	if( (s = getenv("RETRIES")) ){
		retries = atoi(s);
	}
	if( (s = getenv("SLEEPTIME")) ){
		wait_time = atoi(s);
	}
    if( (s = getenv("MODEL")) || (s = model_name) ){
        if ( ! strcasecmp(s, "IV") )   model = IV ;
        if ( ! strcasecmp(s, "III") )   model = III ;
        if ( ! strcasecmp(s, "IIID") )  model = IIID ;
        if ( ! strcasecmp(s, "IIISi") ) model = IIISi ;
        if ( ! strcasecmp(s, "C5M") ) model = C5M ;
    }
    if( (s = getenv("CARTRIDGE")) ){
		cartridge = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("RESOURCESAVE")) ){
		resourcesave = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("TRACE")) ){
		trace = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("WRAP")) ){
		wrap = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("AUTODETECT")) ){
		autodetect = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	/* set flags according to model */
	switch( model ){
	default: break;
	case C5M:
		infostatus = 0;	/* do not send PJL INFOSTATUS request */
		break;
	}
}
