#!/usr/local/bin/perl
#  log.pl - logging functions
#
#  Written by Christopher Browne.  Started November 1, 1994.
#  Modified by Curtis Olson.
#
#  Copyright (C) 1994  Christopher B. Browne cbrowne@io.org
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: log.pl,v 2.5 1997/01/18 03:28:44 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;   # don't take no guff


# Create a log entry
sub log_txn {
    my($command_line) = @_;
    my($home) = &file_dirname($CBB::current_file);

    print DEBUG "File is $CBB::current_file\n" if $CBB::debug;
    print DEBUG "logging to $home/alltxns.log\n" if $CBB::debug;

    open(LOG, ">>$home/alltxns.log");
    print LOG &log_fmt_date() . " " . $command_line . "\n";
    close(LOG);

}


# return the current date/time in log format
sub log_fmt_date {
    my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) 
	= localtime(time);
    return sprintf("19%02d/%02d/%02d %02d:%02d:%02d", $year, $mon+1, $mday, 
	$hour, $min, $sec);
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: log.pl,v $
# Revision 2.5  1997/01/18 03:28:44  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.4  1996/12/17 14:53:59  curt
# Updated copyright date.
#
# Revision 2.3  1996/09/26 19:45:10  curt
# Fixed a small bug that would cause debugging to be turned off if it was on.
#
# Revision 2.2  1996/07/13 02:57:48  curt
# Version 0.65
# Packing Changes
# Documenation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:47  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:00  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
