\name{change.origin}
\title{Change Origin for a Polynomial}
\usage{
change.origin(p, o)
}
\arguments{
\item{p}{An object of class polynomial}
\item{o}{A numeric scalar representing the new origin on the original
scale}
}
\description{
Calculate the coefficients of a polynomial relative to a new origin on
the x-axis.

Let P(x) = sum_i p_i x^i be a given polynomial and consider writing
P(x) = sum_j q_j (x - o)^j.  This function calculates the coefficients
q_j and returns the result as a polynomial.
}
\value{
A polynomial relative to the re-located x-axis
}
\examples{
pr <- poly.from.zeros(1:5)
pr
## -120 + 274*x - 225*x^2 + 85*x^3 - 15*x^4 + x^5 
change.origin(pr, 3)
## 4*x - 5*x^3 - 10*x^4 + x^5 
}
