\name{surf.gls}
\title{
Fits a Trend Surface by Generalized Least-squares
}
\usage{
surf.gls(np, covmod, x, y, z, nx=1000, \dots)
}
\description{
Fits a trend surface by generalized least-squares.
}
\arguments{
\item{np}{
degree of polynomial surface
}
\item{covmod}{
function to evaluate covariance or correlation function
}
\item{x}{
x coordinates or a data frame with columns \code{x}, \code{y}, \code{z}
}
\item{y}{
y coordinates
}
\item{z}{
z coordinates. Will supersede \code{x$z}
}
\item{nx}{
Number of bins for table of the covariance. Increasing adds accuracy,
and increases size of the object. 
}
\item{...}{
parameters for \code{covmod}
}}
\value{
list with components 

\item{beta}{
the coefficients
}
\item{x}{
}
\item{y}{
}
\item{z}{


and others for internal use only.
}}
\seealso{
\code{\link{trmat}}, \code{\link{prmat}}, \code{\link{semat}}, \code{\link{expcov}}, \code{\link{gaucov}}, \code{\link{sphercov}}
}
\examples{
data(topo)
topo.kr <- surf.gls(2, expcov, topo, d=0.7)
trsurf <- trmat(topo.kr, 0, 6.5, 0, 6.5, 50)
contour(trsurf$x, trsurf$y, trsurf$z)
prsurf <- prmat(topo.kr, 0, 6.5, 0, 6.5, 50)
contour(prsurf$x, prsurf$y, prsurf$z, levels=seq(700, 925, 25))
sesurf <- semat(topo.kr, 0, 6.5, 0, 6.5, 30)
contour(sesurf$x, sesurf$y, sesurf$z, levels=c(22,25))
}
\keyword{spatial}
% Converted by Sd2Rd version 0.2-a3.
