predict.cluster <- function(clobj, x){

  xrows<-dim(x)[1]
  xcols<-dim(x)[2]
  ncenters <- clobj$ncenters
  cluster <- integer(xrows)
  clustersize <- integer(ncenters)
  

  if(dim(clobj$centers)[2] != xcols){
    stop("Number of variables in cluster object and x are not the same!")
  }

  
  retval <- .C("assign",
               xrows = as.integer(xrows),
               xcols = as.integer(xcols),
               x = as.double(x),
               ncenters = as.integer(ncenters),
               centers = as.double(clobj$centers),
               cluster = as.integer(cluster),
               clustersize = as.integer(clustersize),
               method = as.integer(clobj$method))

  cluster <- retval$cluster + 1
  
  if (retval$method == 0)
    error <- mean(sqrt((apply(((x-clobj$centers[cluster,])^2),1,sum))))
  else
    error <- mean(apply((abs(x-clobj$centers[cluster,])),1,sum))
   

  clobj$initcenters <- NULL
  clobj$iter <- NULL
  clobj$changes <- NULL
  clobj$error <- error
  clobj$cluster <- cluster
  clobj$size <- retval$clustersize

  return(clobj)
}


