/*								-*- C++ -*-
 * $Id: GDI_bitmap.h,v 1.2 1996-11-29 09:40:58+01 mho Exp $
 *
 * Purpose: bitmap classes to implement pixmaps, icons, and cursors
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Bitmap_h
#define Bitmap_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmapRep;
class wxItem;

class wxBitmap : public wxObject { // bitmap representation
DECLARE_DYNAMIC_CLASS(wxBitmap)
public:
    wxBitmap(void);
    wxBitmap(wxBitmap& new_bmp);
    wxBitmap(char bits[], int width, int height, int depth = 1);
    wxBitmap(int width, int height, int depth = -1);
#if USE_XPM
    wxBitmap(char **data, wxItem *anItem = NULL);
#endif
    wxBitmap(char *name, long flags = wxBITMAP_DEFAULT);
    ~wxBitmap(void);
    // create and destroy
    Bool Create(int width, int height, int depth = -1);
    void Destroy(void);
    // get information about bitmap
    int  GetDepth(void);
    int  GetHeight(void);
    void GetHotSpot(int *x, int *y);
    int  GetWidth(void);
    // set and get colourmap
    wxColourMap* GetColourMap(void);
    void         SetColourMap(wxColourMap *new_cmap);
    // load and save bitmap
    Bool LoadFile(char *name, long flags = wxBITMAP_DEFAULT);
    Bool SaveFile(char *name, int type, wxColourMap *cmap = NULL);
    // X representation
    Bool  Ok(void);
#ifdef Have_X_Types
    Pixmap GetPixmap(void);
    Pixmap GetMask(void);
#endif
    // assignment
    wxBitmap& operator = (wxBitmap& new_bmp);
    void      operator = (wxBitmap* p_new_bmp);
protected:
    wxBitmapRep *bmp;
};

class wxCursor : public wxBitmap { // cursor representation
DECLARE_DYNAMIC_CLASS(wxCursor)
public:
    wxCursor(void);
    wxCursor(wxCursor& new_cursor);
    wxCursor(char bits[], int width, int height, int x=0, int y=0);
    wxCursor(char *name, long flags = wxBITMAP_DEFAULT);
    wxCursor(int cursor_type);
    ~wxCursor(void);
    // change foreground and background colour
    void ChangeColour(wxColour* fg, wxColour *bg);
#ifdef Have_X_Types
    // X representation
    Cursor GetCursor(void);
#endif
};

class wxIcon : public wxBitmap { // icon representation
DECLARE_DYNAMIC_CLASS(wxIcon)
public:
    wxIcon(void);
    wxIcon(wxIcon& new_icon);
    wxIcon(char bits[], int width, int height, int depth = 1);
    wxIcon(int width, int height, int depth = -1);
#if USE_XPM
    wxIcon(char **data);
#endif
    wxIcon(char *name, long flags = wxBITMAP_DEFAULT);
    // assignment
    wxIcon& operator = (wxIcon& new_icon);
    void    operator = (wxIcon* p_new_icon);
};

class wxGDIList : public wxList { // GDI list representation (list of bitmaps)
DECLARE_DYNAMIC_CLASS(wxGDIList)
public:
    wxGDIList(void);
    ~wxGDIList(void);
};

#endif // Bitmap_h
