""" Demonstration of Pmw colors.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import string
import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	self.width = 350
	self.height = 250
	self.canvas = Tkinter.Canvas(parent,
		width = self.width, height = self.height)
	self.canvas.pack(padx=10, pady=10, fill='both', expand='yes')

	self.numColors = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Number of colours:',
		command = Pmw.busycallback(self.execute))
	self.numColors.pack(fill='x', expand=1, padx=10, pady=5)

	self.correction = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Correction:',
		command = Pmw.busycallback(self.execute))
	self.correction.pack(fill='x', expand=1, padx=10, pady=5)

	self.saturation = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Saturation:',
		command = Pmw.busycallback(self.execute))
	self.saturation.pack(fill='x', expand=1, padx=10, pady=5)

	self.intensity = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Intensity:',
		command = Pmw.busycallback(self.execute))
	self.intensity.pack(fill='x', expand=1, padx=10, pady=5)

	self.extraOrange = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Emphasize orange:',
		command = Pmw.busycallback(self.execute))
	self.extraOrange.pack(fill='x', expand=1, padx=10, pady=5)

	Pmw.alignlabels((self.numColors, self.correction,
		self.saturation, self.intensity, self.extraOrange))

	self.numColors.insert('end', '64')
	self.correction.insert('end', '1.5')
	self.saturation.insert('end', '1.0')
	self.intensity.insert('end', '1.0')
	self.extraOrange.insert('end', '1')
	self.execute()

    def execute(self):
	try:
	    numColors = string.atoi(self.numColors.get())
	    correction = string.atof(self.correction.get())
	    saturation = string.atof(self.saturation.get())
	    intensity = string.atof(self.intensity.get())
	    extraOrange = string.atof(self.extraOrange.get())
	except ValueError:
	    sys.exc_traceback = None   # Clean up object references
	    self.numColors.bell()
	    return

	if numColors <= 0:
	    self.numColors.bell()
	    return

	colorList = Pmw.Color.spectrum(
		numColors, correction, saturation, intensity, extraOrange)
	extent = 360.0 / numColors

	if numColors == 1:
	    # Special case circle, since create_arc does not work when
	    # extent is 360.
	    background = colorList[0]
	    self.canvas.create_oval(10, 10, self.width - 10, self.height - 10,
		fill = background, outline = background)

	for index in range(numColors):
	    start = index * extent - extent / 2
	    background = colorList[index]
	    self.canvas.create_arc(10, 10, self.width - 10, self.height - 10,
		start = start, extent = extent,
		fill = background, outline = background)

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Color spectrum demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
