// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  XDROp.C

  Stephane Rehel
  August 4 1996
*/

#include "xdrinc.h"

#include <stdio.h>

#include "tools/OString.h"

#include "XDROp.h"


/////////////////////////////////////////////////////////////////////////////

XDROp::XDROp()
{
  xdr= 0;
  error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

XDROp::~XDROp()
{}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putByte( char b )
{
  if( xdr == 0 )
    return;

  if( ! xdr_opaque( (XDR*)xdr, &b, 1 ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putChar( char ch )
{
  if( xdr == 0 )
    return;

  if( ! xdr_char( (XDR*)xdr, &ch ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putUChar( unsigned char ch )
{
  if( xdr == 0 )
    return;

  if( ! xdr_u_char( (XDR*)xdr, &ch ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putInteger( int i )
{
  if( xdr == 0 )
    return;

  if( ! xdr_int( (XDR*)xdr, &i ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putUInteger( unsigned int i )
{
  if( xdr == 0 )
    return;

  if( ! xdr_u_int( (XDR*)xdr, &i ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putShort( short i )
{
  if( xdr == 0 )
    return;

  if( ! xdr_short( (XDR*)xdr, &i ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putUShort( unsigned short i )
{
  if( xdr == 0 )
    return;

  if( ! xdr_u_short( (XDR*)xdr, &i ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putLong( long l )
{
  if( xdr == 0 )
    return;

  if( ! xdr_long( (XDR*)xdr, &l ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putULong( unsigned long l )
{
  if( xdr == 0 )
    return;

  if( ! xdr_u_long( (XDR*)xdr, &l ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putFloat( float f )
{
  if( xdr == 0 )
    return;

  if( ! xdr_float( (XDR*)xdr, &f ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putDouble( double d )
{
  if( xdr == 0 )
    return;

  if( ! xdr_double( (XDR*)xdr, &d ) )
    error= ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::putString( const OString& s )
{
  if( xdr == 0 )
    return;

  putInteger(s.length());
  for( register int i= 0; i < s.length(); ++i )
    putChar( s[i] );
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getByte( char* b )
{
  if( xdr == 0 || b == 0 )
    return;

  if( ! xdr_opaque( (XDR*)xdr, b, 1 ) )
    *b= char(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getChar( char* ch )
{
  if( xdr == 0 || ch == 0 )
    return;

  if( ! xdr_char( (XDR*)xdr, ch ) )
    *ch= char(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getUChar( unsigned char* ch )
{
  if( xdr == 0 || ch == 0 )
    return;

  if( ! xdr_u_char( (XDR*)xdr, ch ) )
    *ch= (unsigned char)(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getInteger( int* i )
{
  if( xdr == 0 || i == 0 )
    return;

  if( ! xdr_int( (XDR*)xdr, i ) )
    *i= int(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getUInteger( unsigned int* i )
{
  if( xdr == 0 || i == 0 )
    return;

  if( ! xdr_u_int( (XDR*)xdr, i ) )
    *i= (unsigned int)(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getShort( short* i )
{
  if( xdr == 0 || i == 0 )
    return;

  if( ! xdr_short( (XDR*)xdr, i ) )
    *i= short(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getUShort( unsigned short* i )
{
  if( xdr == 0 || i == 0 )
    return;

  if( ! xdr_u_short( (XDR*)xdr, i ) )
    *i= (unsigned short)(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getLong( long* l )
{
  if( xdr == 0 || l == 0 )
    return;

  if( ! xdr_long( (XDR*)xdr, l ) )
    *l= long(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getULong( unsigned long* l )
{
  if( xdr == 0 || l == 0 )
    return;

  if( ! xdr_u_long( (XDR*)xdr, l ) )
    *l= (unsigned long)(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getFloat( float* f )
{
  if( xdr == 0 || f == 0 )
    return;

  if( ! xdr_float( (XDR*)xdr, f ) )
    *f= float(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getDouble( double* d )
{
  if( d == 0 )
    return;

  if( ! xdr_double( (XDR*)xdr, d ) )
    *d= double(0);
}

/////////////////////////////////////////////////////////////////////////////

void XDROp::getString( OString* s )
{
  if( xdr == 0 || s == 0 )
    return;

  int length;
  getInteger(&length);
  if( getError() || length <= 0 )
    {
    *s= OString("");
    return;
    }

  s->fill(length,' ');

  for( register int i= 0; i < s->length(); ++i )
    {
    char ch;
    getChar(&ch);
    s->put( i, ch );
    }
}

/////////////////////////////////////////////////////////////////////////////

