// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   OStringHashTable.C

   OString Hash Table

   Stephane Rehel [SCFR::Kepler] Stephane.Rehel@imag.fr
   August 1995
*/

#include "OStringHashTable.h"


/////////////////////////////////////////////////////////////////////////////

HashCode OStringHashTable::getHashCode( const char* strg ) const
{
  assert( size != 0 );
  assert( strg != 0 );

  HashCode hc= 0;
  while( *strg != 0 )
    hc+= int( (unsigned char) *(strg++) );

  return (hc*hc) % size;
}

/////////////////////////////////////////////////////////////////////////////

OString* OStringHashTable::find( const char* string, HashCode hc )
{
  assert( string != 0 );
  assert( table != 0 );
  assert( hc < size );

  IListIterator<OString> li( table[hc] );
  while( ! li.eol() )
    {
    OString* ostring= li.next();
    if( *ostring == string )
      return ostring;
    }

  return 0;
}

/////////////////////////////////////////////////////////////////////////////

OString* OStringHashTable::addNew( const char* string, HashCode hc )
{
  assert( string != 0 );

  OString* ostring= new OString(string);

  HashTable<OString>::addNew( ostring, hc );

  return ostring;
}

/////////////////////////////////////////////////////////////////////////////

OString* OStringHashTable::addUnique( const char* string )
{
  HashCode hc= getHashCode(string);

  OString* ostring= find( string, hc );
  if( ostring != 0 )
    return ostring;

  addNew( string, hc );

  return 0;
}

/////////////////////////////////////////////////////////////////////////////

void OStringHashTable::removeString( const char* string )
{
  HashCode hc= getHashCode(string);

  assert( table != 0 );
  assert( hc < size );

  IListIterator<OString> li( table[hc] );
  while( ! li.eol() )
    {
    IListElement<OString>* element= li.nextElement();
    if( *element->element == string )
      {
      delete element->element;
      element->element= 0;
      table[hc].remove(element);
      break;
      }
    }

  --nElements;
}


/////////////////////////////////////////////////////////////////////////////
