// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Cosmic10Font.C

  Stephane Rehel
  March 25 1997
*/

#include "Cosmic10Font.h"

/////////////////////////////////////////////////////////////////////////////

Cosmic10Font::Cosmic10Font():
  MLLogoFont( font_height, font_descent, font_data, font_char_addr )
{}

/////////////////////////////////////////////////////////////////////////////

// static
const int Cosmic10Font::font_height= 12;
const int Cosmic10Font::font_descent= 2;

/////////////////////////////////////////////////////////////////////////////

const unsigned char Cosmic10Font::font_data[6961] = {
 3, 0, /*   */
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
 2, 0, /* ! */
  0x00,0x00,
  0x80,0xbf,
  0x80,0xbf,
  0x80,0xbf,
  0x80,0xbf,
  0x80,0xbf,
  0x80,0xbf,
  0x20,0x30,
  0x70,0xaf,
  0x10,0x20,
  0x00,0x00,
  0x00,0x00,
 5, 0, /* " */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x70,0x10,0x70,0x10,
  0x00,0xff,0x40,0xff,0x40,
  0x00,0xff,0x40,0xff,0x40,
  0x00,0xaf,0x20,0xaf,0x30,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 10, 0, /* # */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x20,0xbf,0x00,0x00,0xaf,0x30,0x00,
  0x00,0x00,0x00,0x80,0xcf,0x00,0x40,0xff,0x10,0x00,
  0x00,0x9f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x30,
  0x00,0x00,0x10,0xff,0x30,0x00,0xbf,0x80,0x00,0x00,
  0x00,0x00,0x60,0xef,0x00,0x00,0xff,0x40,0x00,0x00,
  0x30,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xaf,0x00,
  0x00,0x00,0xef,0x60,0x00,0x80,0xcf,0x00,0x00,0x00,
  0x00,0x40,0xef,0x10,0x00,0xbf,0x8f,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x30,0x10,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* $ */
  0x00,0x00,0x00,0xaf,0x30,0x00,0x00,
  0x00,0x00,0x10,0xff,0x9f,0x50,0x00,
  0x00,0x60,0xef,0xff,0xaf,0xbf,0x30,
  0x00,0xef,0x60,0xff,0x40,0x00,0x00,
  0x00,0xcf,0xbf,0xff,0x70,0x00,0x00,
  0x00,0x10,0x70,0xff,0xef,0xcf,0x10,
  0x00,0x00,0x00,0xff,0x50,0xdf,0x70,
  0x20,0x70,0x00,0xff,0x50,0xdf,0x70,
  0x20,0xef,0xdf,0xff,0xff,0xbf,0x10,
  0x00,0x00,0x40,0xff,0x60,0x00,0x00,
  0x00,0x00,0x00,0xff,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* % */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x80,0xcf,0xbf,0x00,0x50,0x80,0x00,0x00,
  0xff,0x00,0xbf,0x40,0xdf,0x60,0x00,0x00,
  0x8f,0xcf,0xbf,0x50,0xdf,0x00,0x00,0x00,
  0x00,0x00,0x00,0xbf,0x60,0x00,0x00,0x00,
  0x00,0x00,0x40,0xdf,0x00,0x00,0x00,0x00,
  0x00,0x00,0xbf,0x80,0x80,0xcf,0xdf,0x20,
  0x00,0x40,0xef,0x10,0xff,0x10,0x80,0x80,
  0x00,0x9f,0x80,0x00,0xcf,0x8f,0xdf,0x30,
  0x00,0x30,0x10,0x00,0x00,0x40,0x20,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* & */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x40,0x80,0x10,0x00,
  0x00,0x00,0x20,0xff,0xdf,0x70,0x00,
  0x00,0x00,0x40,0xff,0xef,0x60,0x00,
  0x00,0x00,0x50,0xff,0xaf,0x00,0x00,
  0x00,0x70,0xef,0x9f,0xbf,0x70,0x70,
  0x20,0xff,0x30,0x00,0xdf,0xef,0x70,
  0x40,0xff,0x10,0x00,0x80,0xff,0x20,
  0x00,0xbf,0xef,0xcf,0xef,0xbf,0x80,
  0x00,0x00,0x30,0x40,0x00,0x20,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 3, 0, /* ' */
  0x00,0x00,0x00,
  0x00,0x70,0xaf,
  0x00,0x80,0xbf,
  0x00,0x40,0x50,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
 4, 0, /* ( */
  0x00,0x00,0x00,0x00,
  0x00,0x10,0xcf,0x60,
  0x00,0x9f,0xbf,0x00,
  0x10,0xff,0x30,0x00,
  0x50,0xef,0x00,0x00,
  0x80,0xbf,0x00,0x00,
  0x80,0xbf,0x00,0x00,
  0x70,0xcf,0x00,0x00,
  0x30,0xff,0x10,0x00,
  0x00,0xbf,0x9f,0x00,
  0x00,0x30,0xdf,0x70,
  0x00,0x00,0x00,0x00,
 4, 0, /* ) */
  0x00,0x00,0x00,0x00,
  0x60,0xcf,0x10,0x00,
  0x00,0xbf,0x9f,0x00,
  0x00,0x30,0xff,0x10,
  0x00,0x00,0xef,0x50,
  0x00,0x00,0xbf,0x80,
  0x00,0x00,0xbf,0x80,
  0x00,0x00,0xcf,0x70,
  0x00,0x10,0xff,0x30,
  0x00,0x9f,0xbf,0x00,
  0x70,0xdf,0x30,0x00,
  0x00,0x00,0x00,0x00,
 6, 0, /* * */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x50,0x80,0x00,0x00,
  0x20,0xaf,0xbf,0xdf,0x80,0x40,
  0x00,0x40,0xff,0xff,0xaf,0x20,
  0x00,0x9f,0x9f,0x80,0xcf,0x00,
  0x00,0x00,0x00,0x00,0x30,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 5, 0, /* + */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x10,0x20,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,
  0xaf,0xdf,0xef,0xbf,0x20,
  0x30,0x9f,0xcf,0x40,0x10,
  0x00,0x60,0x8f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 4, 0, /* , */
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x9f,0x30,
  0x00,0x40,0xdf,0x00,
  0x00,0x30,0x40,0x00,
  0x00,0x00,0x00,0x00,
 5, 0, /* - */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x10,0x40,0x40,0x40,0x10,
  0x30,0xbf,0xbf,0xbf,0x20,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 2, 0, /* . */
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0xaf,0xaf,
  0x20,0x20,
  0x00,0x00,
  0x00,0x00,
 5, 0, /* / */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x20,0xbf,
  0x00,0x00,0x00,0x80,0xcf,
  0x00,0x00,0x00,0xdf,0x60,
  0x00,0x00,0x60,0xef,0x10,
  0x00,0x00,0xdf,0x80,0x00,
  0x00,0x60,0xdf,0x10,0x00,
  0x00,0xdf,0x60,0x00,0x00,
  0x50,0xef,0x10,0x00,0x00,
  0x30,0x50,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 7, 0, /* 0 */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x60,0x80,0x60,0x00,0x00,
  0x00,0x9f,0xdf,0x80,0xdf,0x8f,0x00,
  0x30,0xff,0x30,0x00,0x40,0xff,0x10,
  0x80,0xcf,0x00,0x00,0x00,0xff,0x40,
  0x80,0xbf,0x00,0x00,0x00,0xff,0x40,
  0x70,0xdf,0x00,0x00,0x20,0xff,0x20,
  0x20,0xff,0x40,0x00,0x80,0xdf,0x00,
  0x00,0x8f,0xef,0xcf,0xef,0x50,0x00,
  0x00,0x00,0x30,0x40,0x10,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 4, 0, /* 1 */
  0x00,0x00,0x00,0x00,
  0x00,0x50,0x40,0x00,
  0x60,0xff,0x80,0x00,
  0x60,0xcf,0x80,0x00,
  0x00,0xbf,0x80,0x00,
  0x00,0xbf,0x80,0x00,
  0x00,0xbf,0x80,0x00,
  0x00,0xbf,0x80,0x00,
  0x9f,0xff,0xff,0x60,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
 6, 0, /* 2 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x10,0x70,0x80,0x20,0x00,
  0x30,0xef,0xaf,0xaf,0xef,0x20,
  0x40,0x50,0x00,0x00,0xff,0x40,
  0x00,0x00,0x00,0x9f,0xdf,0x00,
  0x00,0x20,0xcf,0xbf,0x20,0x00,
  0x20,0xef,0x70,0x00,0x00,0x00,
  0x70,0xcf,0x30,0x40,0x30,0x00,
  0x70,0xff,0xcf,0xbf,0xef,0x30,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* 3 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0x80,0x70,0x10,0x00,
  0x20,0xef,0x8f,0xcf,0xbf,0x00,
  0x00,0x00,0x00,0x40,0xff,0x00,
  0x00,0x30,0x8f,0xdf,0xbf,0x00,
  0x00,0x30,0x80,0xdf,0x8f,0x00,
  0x00,0x00,0x00,0x20,0xff,0x30,
  0x50,0x80,0x00,0x20,0xff,0x30,
  0x30,0xef,0xcf,0xef,0x9f,0x00,
  0x00,0x10,0x40,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* 4 */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x70,0x40,0x00,
  0x00,0x00,0x00,0x8f,0xff,0x80,0x00,
  0x00,0x00,0x50,0xef,0xdf,0x80,0x00,
  0x00,0x20,0xef,0x70,0xbf,0x80,0x00,
  0x10,0xcf,0xcf,0x40,0xcf,0x9f,0x10,
  0x20,0x80,0xaf,0xbf,0xef,0xdf,0x50,
  0x00,0x00,0x00,0x00,0xbf,0x80,0x00,
  0x00,0x00,0x00,0x00,0xbf,0x80,0x00,
  0x00,0x00,0x00,0x00,0x20,0x20,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* 5 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0x80,0x80,0x80,0x80,0x20,
  0x40,0xff,0x80,0x80,0x80,0x10,
  0x40,0xef,0x70,0x80,0x40,0x00,
  0x80,0xff,0xaf,0x8f,0xff,0x20,
  0x50,0x8f,0x00,0x00,0xcf,0x80,
  0x00,0x00,0x00,0x00,0xbf,0x80,
  0x30,0x50,0x00,0x30,0xff,0x40,
  0x30,0xef,0xbf,0xff,0x9f,0x00,
  0x00,0x10,0x40,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* 6 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x30,0x50,0x00,0x00,
  0x00,0x30,0xef,0x60,0x00,0x00,
  0x10,0xdf,0x60,0x00,0x00,0x00,
  0x70,0xef,0xbf,0xaf,0x50,0x00,
  0xaf,0xcf,0x50,0x8f,0xef,0x10,
  0xbf,0x80,0x00,0x00,0xff,0x40,
  0x9f,0xbf,0x00,0x40,0xff,0x20,
  0x30,0xef,0xcf,0xef,0x8f,0x00,
  0x00,0x10,0x40,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* 7 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x60,0x80,0x80,0x80,0x80,0x80,
  0x50,0x80,0x80,0x80,0xff,0x9f,
  0x00,0x00,0x00,0x80,0xcf,0x10,
  0x00,0x00,0x10,0xef,0x40,0x00,
  0x00,0x00,0x80,0xdf,0x00,0x00,
  0x00,0x00,0xdf,0x60,0x00,0x00,
  0x00,0x50,0xef,0x10,0x00,0x00,
  0x00,0xaf,0x9f,0x00,0x00,0x00,
  0x00,0x20,0x10,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* 8 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x40,0x80,0x80,0x20,0x00,
  0x50,0xef,0x8f,0xaf,0xef,0x10,
  0xbf,0x80,0x00,0x00,0xff,0x40,
  0x80,0xef,0x8f,0xcf,0xbf,0x10,
  0x50,0xff,0xbf,0xdf,0xdf,0x10,
  0xbf,0x9f,0x00,0x00,0xdf,0x70,
  0xbf,0x8f,0x00,0x00,0xcf,0x80,
  0x50,0xef,0xcf,0xdf,0xcf,0x10,
  0x00,0x10,0x40,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* 9 */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x20,0x80,0x70,0x10,0x00,
  0x50,0xff,0x8f,0xcf,0xef,0x10,
  0xaf,0x8f,0x00,0x10,0xdf,0x70,
  0xbf,0x8f,0x00,0x00,0xcf,0x80,
  0x50,0xff,0x8f,0xbf,0xff,0x60,
  0x00,0x40,0x80,0x9f,0xff,0x10,
  0x00,0x00,0x10,0xcf,0x8f,0x00,
  0x10,0x8f,0xef,0x8f,0x00,0x00,
  0x10,0x80,0x20,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 2, 0, /* : */
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
  0x10,0x70,
  0x20,0xaf,
  0x00,0x00,
  0x00,0x00,
  0x20,0xaf,
  0x20,0xaf,
  0x00,0x00,
  0x00,0x00,
  0x00,0x00,
 4, 0, /* ; */
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x10,0x70,0x00,
  0x00,0x20,0xaf,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x10,0xef,0x20,
  0x00,0x80,0x9f,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
 4, 0, /* < */
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x30,0x00,
  0x00,0x60,0xef,0x20,
  0x80,0xef,0x30,0x00,
  0x80,0xef,0x30,0x00,
  0x00,0x60,0xdf,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
 4, 0, /* = */
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0xef,0xff,0xff,0xff,
  0x00,0x00,0x00,0x00,
  0x30,0x40,0x40,0x30,
  0xbf,0xbf,0xbf,0xbf,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
 4, 0, /* > */
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x50,0x30,0x00,0x00,
  0x60,0xef,0x30,0x00,
  0x00,0x60,0xef,0x50,
  0x10,0xaf,0xcf,0x10,
  0xcf,0x8f,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
 6, 0, /* ? */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x40,0x30,0x00,0x00,
  0x20,0xdf,0xcf,0xef,0x9f,0x00,
  0x00,0x30,0x00,0x10,0xef,0x60,
  0x00,0x00,0x00,0x00,0xdf,0x80,
  0x00,0x00,0x10,0xbf,0xef,0x20,
  0x00,0x20,0xef,0xaf,0x10,0x00,
  0x00,0x10,0x40,0x00,0x00,0x00,
  0x00,0x70,0xbf,0x00,0x00,0x00,
  0x00,0x10,0x20,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 9, 0, /* @ */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0xaf,0xff,0xff,0xcf,0x60,0x00,0x00,
  0x20,0xef,0x80,0x10,0x00,0x60,0xef,0x8f,0x00,
  0x9f,0xaf,0x40,0xdf,0xdf,0x00,0x40,0xff,0x20,
  0xef,0x60,0xef,0x60,0x80,0x50,0x00,0xff,0x40,
  0xff,0x70,0xff,0x80,0xff,0x9f,0x70,0xff,0x20,
  0xdf,0x70,0x80,0xbf,0x70,0xbf,0xbf,0x50,0x00,
  0x60,0xef,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x80,0xef,0x9f,0x80,0xcf,0xdf,0x00,0x00,
  0x00,0x00,0x20,0x70,0x80,0x60,0x20,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* A */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x80,0x00,0x00,
  0x00,0x00,0x00,0x8f,0xff,0x40,0x00,
  0x00,0x00,0x40,0xff,0xef,0x60,0x00,
  0x00,0x00,0xbf,0xbf,0xaf,0x8f,0x00,
  0x00,0x60,0xff,0xaf,0xdf,0xbf,0x00,
  0x00,0xff,0xdf,0x8f,0x80,0xff,0x00,
  0x60,0xff,0x20,0x00,0x20,0xff,0x30,
  0xaf,0x8f,0x00,0x00,0x00,0xbf,0x70,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* B */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x60,0x80,0x70,0x10,0x00,
  0x00,0xff,0x9f,0xbf,0xef,0x20,
  0x00,0xff,0x40,0x00,0xcf,0x80,
  0x10,0xff,0x40,0x10,0xef,0x60,
  0x40,0xff,0xcf,0xef,0xcf,0x00,
  0x40,0xff,0x40,0x60,0xdf,0xbf,
  0x40,0xff,0x00,0x10,0x9f,0xef,
  0x40,0xff,0xbf,0xff,0xbf,0x30,
  0x00,0x40,0x40,0x10,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* C */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x40,0x80,0x9f,0x50,
  0x00,0x00,0x60,0xff,0x8f,0xef,0x80,
  0x00,0x30,0xff,0x50,0x00,0x20,0x10,
  0x00,0xbf,0x9f,0x00,0x00,0x00,0x00,
  0x20,0xff,0x30,0x00,0x00,0x00,0x00,
  0x40,0xff,0x00,0x00,0x00,0x00,0x00,
  0x20,0xff,0x40,0x00,0x30,0xaf,0x20,
  0x00,0x70,0xef,0xbf,0xff,0x8f,0x00,
  0x00,0x00,0x20,0x40,0x10,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* D */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x50,0x60,0x00,0x00,0x00,0x00,0x00,
  0xbf,0xdf,0xdf,0x80,0x10,0x00,0x00,
  0xbf,0x80,0x20,0x9f,0xcf,0x20,0x00,
  0xbf,0x80,0x00,0x00,0x80,0xcf,0x00,
  0xbf,0x80,0x00,0x00,0x10,0xff,0x30,
  0xbf,0x80,0x00,0x00,0x10,0xff,0x40,
  0xbf,0x80,0x00,0x00,0x9f,0xdf,0x00,
  0x9f,0xff,0xbf,0xdf,0xdf,0x30,0x00,
  0x00,0x20,0x40,0x40,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* E */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x50,0x70,0x80,0x80,0x80,0x20,
  0xbf,0xdf,0x80,0x80,0x9f,0x80,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x9f,0x40,0x80,0x80,0x30,
  0xbf,0xdf,0xbf,0x8f,0x80,0x30,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0x80,0xef,0xbf,0xbf,0xbf,0x60,
  0x00,0x30,0x40,0x40,0x40,0x10,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* F */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0x80,0x80,0x80,0x60,0x20,
  0x80,0xef,0x8f,0x80,0x9f,0x80,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xdf,0xbf,0xbf,0xbf,0x20,
  0x80,0xdf,0x50,0x40,0x40,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x10,0x20,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* G */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x20,0x80,0x70,0x10,0x00,
  0x00,0x30,0xef,0xaf,0xaf,0xdf,0x00,
  0x00,0xcf,0x9f,0x00,0x00,0x00,0x00,
  0x50,0xef,0x10,0x00,0x00,0x00,0x00,
  0x9f,0x9f,0x9f,0xcf,0xff,0xff,0x9f,
  0xbf,0x80,0x70,0x50,0x10,0xdf,0x60,
  0xaf,0x9f,0x00,0x00,0x9f,0xdf,0x00,
  0x30,0xef,0xcf,0xdf,0xdf,0x30,0x00,
  0x00,0x10,0x40,0x30,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* H */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0x50,0x00,0x00,0x00,0x00,0x70,
  0x80,0xbf,0x00,0x00,0x00,0x40,0xff,
  0x80,0xbf,0x00,0x00,0x00,0x40,0xff,
  0x80,0xbf,0x00,0x00,0x20,0x70,0xff,
  0x80,0xef,0xbf,0xff,0xef,0xcf,0xff,
  0x80,0xdf,0x40,0x10,0x00,0x40,0xff,
  0x9f,0xaf,0x00,0x00,0x00,0x40,0xff,
  0xbf,0x80,0x00,0x00,0x00,0x40,0xff,
  0x50,0x30,0x00,0x00,0x00,0x00,0x30,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* I */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x50,0x80,0x80,0x80,0x60,0x20,
  0x50,0x80,0xcf,0xbf,0xaf,0x50,
  0x00,0x00,0xbf,0x80,0x00,0x00,
  0x00,0x00,0xbf,0x80,0x00,0x00,
  0x00,0x00,0xbf,0x80,0x00,0x00,
  0x00,0x00,0xbf,0x80,0x00,0x00,
  0x00,0x00,0xbf,0x80,0x00,0x00,
  0x20,0xff,0xff,0xff,0xff,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* J */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0x80,0x80,0x80,0x80,0x30,
  0x00,0x30,0x80,0xbf,0xdf,0x80,0x40,
  0x00,0x00,0x00,0x80,0xbf,0x00,0x00,
  0x00,0x00,0x00,0x80,0xbf,0x00,0x00,
  0x00,0x00,0x00,0x80,0xbf,0x00,0x00,
  0x50,0x30,0x00,0x9f,0xbf,0x00,0x00,
  0xaf,0xaf,0x00,0xbf,0x80,0x00,0x00,
  0x10,0xcf,0xdf,0xff,0x60,0x00,0x00,
  0x00,0x00,0x30,0x30,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* K */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0x50,0x00,0x00,0x50,0x30,
  0x80,0xbf,0x00,0x30,0xff,0x40,
  0x80,0xbf,0x30,0xef,0x60,0x00,
  0x80,0xdf,0xef,0x60,0x00,0x00,
  0x80,0xff,0x9f,0x00,0x00,0x00,
  0x80,0xef,0xff,0x60,0x00,0x00,
  0x80,0xbf,0x60,0xff,0x60,0x00,
  0x80,0xbf,0x00,0x60,0xef,0x9f,
  0x10,0x30,0x00,0x00,0x20,0x20,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* L */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x50,0x30,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x00,0x00,
  0xbf,0x80,0x00,0x00,0x40,0x00,
  0xbf,0xdf,0xcf,0xff,0xdf,0x20,
  0x20,0x40,0x40,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 9, 0, /* M */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x50,0x40,0x00,0x00,0x80,0x10,0x00,
  0x00,0x00,0xef,0xbf,0x00,0x40,0xff,0x80,0x00,
  0x00,0x40,0xff,0xff,0x00,0x70,0xff,0xbf,0x00,
  0x00,0x60,0xff,0xff,0x30,0xaf,0xff,0xdf,0x00,
  0x00,0x9f,0xcf,0xdf,0x60,0xdf,0x9f,0xff,0x10,
  0x00,0xdf,0x8f,0x9f,0xcf,0xff,0x50,0xdf,0x50,
  0x20,0xff,0x50,0x60,0xff,0xff,0x10,0x9f,0x9f,
  0x40,0xff,0x20,0x20,0xff,0xdf,0x00,0x60,0xef,
  0x00,0x40,0x00,0x00,0x30,0x20,0x00,0x00,0x30,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* N */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x20,0x70,0x00,0x00,0x00,0x00,0x50,0x30,
  0x60,0xff,0x70,0x00,0x00,0x00,0xbf,0x8f,
  0x40,0xff,0xef,0x30,0x00,0x00,0x80,0xbf,
  0x40,0xff,0x80,0xcf,0x10,0x00,0x80,0xbf,
  0x40,0xff,0x00,0xaf,0xaf,0x00,0x80,0xbf,
  0x40,0xff,0x00,0x10,0xcf,0x80,0x80,0xbf,
  0x40,0xff,0x00,0x00,0x30,0xef,0xcf,0xbf,
  0x40,0xff,0x00,0x00,0x00,0x30,0xef,0xbf,
  0x10,0x30,0x00,0x00,0x00,0x00,0x20,0x20,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* O */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x10,0x60,0x80,0x70,0x20,0x00,
  0x00,0x20,0xdf,0xbf,0x80,0xaf,0xef,0x30,
  0x00,0xbf,0xaf,0x00,0x00,0x00,0xaf,0x9f,
  0x30,0xff,0x20,0x00,0x00,0x00,0x80,0xbf,
  0x80,0xbf,0x00,0x00,0x00,0x00,0x8f,0xaf,
  0x80,0xbf,0x00,0x00,0x00,0x00,0xdf,0x70,
  0x30,0xff,0x60,0x00,0x00,0x9f,0xdf,0x10,
  0x00,0x60,0xef,0xcf,0xdf,0xdf,0x30,0x00,
  0x00,0x00,0x10,0x40,0x40,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* P */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x10,0x80,0x80,0x60,0x00,0x00,
  0x80,0xdf,0x80,0xdf,0xcf,0x00,
  0x80,0xbf,0x00,0x10,0xff,0x40,
  0x80,0xbf,0x00,0x40,0xff,0x20,
  0x80,0xef,0xcf,0xff,0x60,0x00,
  0x80,0xcf,0x40,0x10,0x00,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x10,0x20,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 9, 0, /* Q */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x30,0x80,0x80,0x50,0x00,0x00,
  0x00,0x10,0xbf,0xef,0x8f,0x8f,0xef,0x9f,0x00,
  0x00,0xaf,0xcf,0x10,0x00,0x00,0x30,0xff,0x40,
  0x20,0xff,0x30,0x00,0x00,0x00,0x00,0xaf,0x9f,
  0x40,0xff,0x00,0x00,0x00,0x00,0x00,0x80,0xbf,
  0x20,0xff,0x40,0x00,0x80,0x30,0x00,0x8f,0xaf,
  0x00,0x8f,0xcf,0x10,0x9f,0xef,0x60,0xef,0x50,
  0x00,0x10,0xaf,0xef,0xbf,0xff,0xff,0x8f,0x00,
  0x00,0x00,0x00,0x20,0x40,0x20,0x8f,0xff,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9f,0xff,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,
 7, 0, /* R */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0x80,0x80,0x30,0x00,0x00,0x00,
  0x80,0xdf,0x8f,0xef,0xbf,0x10,0x00,
  0x80,0xbf,0x00,0x10,0xaf,0xbf,0x00,
  0x80,0xbf,0x00,0x00,0x50,0xff,0x00,
  0x80,0xcf,0x40,0x70,0xef,0x8f,0x00,
  0x80,0xff,0xff,0xff,0x60,0x00,0x00,
  0x80,0xbf,0x20,0x9f,0xff,0x60,0x00,
  0x70,0xaf,0x00,0x00,0x50,0xef,0x20,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* S */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x50,0x80,0x70,0x20,
  0x00,0x10,0xbf,0xcf,0x80,0xaf,0x8f,
  0x00,0x70,0xcf,0x00,0x00,0x00,0x00,
  0x00,0x60,0xff,0x9f,0x80,0x50,0x00,
  0x00,0x00,0x40,0x80,0x9f,0xef,0x8f,
  0x00,0x00,0x00,0x00,0x00,0x50,0xff,
  0x20,0xaf,0x10,0x00,0x00,0x9f,0xdf,
  0x10,0xbf,0xef,0xbf,0xdf,0xdf,0x30,
  0x00,0x00,0x30,0x40,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* T */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x20,0x80,0x80,0x80,0x80,0x80,0x80,0x30,
  0x10,0x70,0x80,0xdf,0xbf,0x80,0x80,0x40,
  0x00,0x00,0x00,0xbf,0x80,0x00,0x00,0x00,
  0x00,0x00,0x00,0x9f,0x80,0x00,0x00,0x00,
  0x00,0x00,0x00,0x80,0xbf,0x00,0x00,0x00,
  0x00,0x00,0x00,0x80,0xbf,0x00,0x00,0x00,
  0x00,0x00,0x00,0x80,0xbf,0x00,0x00,0x00,
  0x00,0x00,0x00,0x70,0xaf,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* U */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x10,0x70,0x00,0x00,0x00,0x10,0x70,
  0x40,0xff,0x00,0x00,0x00,0x40,0xff,
  0x40,0xff,0x00,0x00,0x00,0x40,0xff,
  0x40,0xff,0x00,0x00,0x00,0x40,0xff,
  0x40,0xff,0x00,0x00,0x00,0x60,0xdf,
  0x30,0xff,0x20,0x00,0x00,0x8f,0xaf,
  0x00,0xdf,0x80,0x00,0x10,0xef,0x60,
  0x00,0x50,0xef,0xcf,0xdf,0xbf,0x00,
  0x00,0x00,0x10,0x40,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* V */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x50,0x20,0x00,0x00,0x00,0x70,0x10,
  0xaf,0x80,0x00,0x00,0x50,0xef,0x10,
  0x60,0xcf,0x00,0x00,0x9f,0x8f,0x00,
  0x20,0xff,0x20,0x10,0xff,0x40,0x00,
  0x00,0xcf,0x60,0x60,0xdf,0x00,0x00,
  0x00,0x8f,0xaf,0xaf,0x8f,0x00,0x00,
  0x00,0x30,0xff,0xff,0x30,0x00,0x00,
  0x00,0x00,0xdf,0xdf,0x00,0x00,0x00,
  0x00,0x00,0x20,0x20,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 12, 0, /* W */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x40,0x60,0x00,0x00,0x10,0x80,0x00,0x00,0x00,0x80,0x20,
  0x00,0x50,0xff,0x00,0x00,0x70,0xff,0x40,0x00,0x40,0xef,0x10,
  0x00,0x00,0xef,0x50,0x00,0xcf,0xff,0x50,0x00,0x8f,0xbf,0x00,
  0x00,0x00,0xaf,0x8f,0x20,0xff,0xdf,0x80,0x00,0xdf,0x60,0x00,
  0x00,0x00,0x70,0xbf,0x70,0xcf,0x9f,0x9f,0x30,0xff,0x10,0x00,
  0x00,0x00,0x30,0xff,0xdf,0x60,0x80,0xcf,0x9f,0x9f,0x00,0x00,
  0x00,0x00,0x00,0xff,0xef,0x00,0x40,0xff,0xef,0x50,0x00,0x00,
  0x00,0x00,0x00,0xbf,0xbf,0x00,0x10,0xff,0xdf,0x00,0x00,0x00,
  0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x70,0x50,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* X */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x70,0x20,0x00,0x00,0x00,0x50,0x30,
  0x00,0x9f,0xcf,0x10,0x00,0x40,0xff,0x40,
  0x00,0x00,0xcf,0x9f,0x10,0xef,0x80,0x00,
  0x00,0x00,0x20,0xef,0xef,0xcf,0x00,0x00,
  0x00,0x00,0x00,0x9f,0xff,0x50,0x00,0x00,
  0x00,0x00,0x60,0xef,0xaf,0xdf,0x10,0x00,
  0x00,0x60,0xff,0x40,0x00,0xcf,0x9f,0x00,
  0x20,0xef,0x60,0x00,0x00,0x30,0xef,0x50,
  0x00,0x30,0x00,0x00,0x00,0x00,0x20,0x10,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* Y */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x70,0x10,0x00,0x00,0x10,0x70,
  0xdf,0x9f,0x00,0x00,0x80,0xbf,
  0x40,0xff,0x40,0x10,0xef,0x50,
  0x00,0xaf,0xbf,0x60,0xef,0x00,
  0x00,0x40,0xff,0xef,0x8f,0x00,
  0x00,0x00,0x9f,0xff,0x20,0x00,
  0x00,0x00,0xbf,0xbf,0x00,0x00,
  0x00,0x30,0xff,0x20,0x00,0x00,
  0x00,0x00,0x30,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* Z */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0x80,0x80,0x80,0x80,0x80,0x80,0x10,
  0x30,0x80,0x80,0x80,0x8f,0xff,0xcf,0x10,
  0x00,0x00,0x00,0x10,0xcf,0x9f,0x10,0x00,
  0x00,0x00,0x10,0xcf,0xcf,0x10,0x00,0x00,
  0x00,0x00,0x8f,0xef,0x30,0x00,0x00,0x00,
  0x00,0x40,0xff,0x60,0x00,0x00,0x00,0x00,
  0x10,0xef,0x8f,0x00,0x00,0x00,0x00,0x00,
  0x70,0xff,0xbf,0xbf,0xbf,0xbf,0xbf,0x20,
  0x10,0x40,0x40,0x40,0x40,0x40,0x40,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 3, 0, /* [ */
  0x00,0x00,0x00,
  0x80,0x80,0x60,
  0xff,0x9f,0x50,
  0xff,0x40,0x00,
  0xff,0x40,0x00,
  0xff,0x40,0x00,
  0xff,0x40,0x00,
  0xff,0x40,0x00,
  0xff,0x40,0x00,
  0xff,0x40,0x00,
  0xef,0xff,0xaf,
  0x00,0x00,0x00,
 5, 0, /* \ */
  0x00,0x00,0x00,0x00,0x00,
  0x10,0x70,0x00,0x00,0x00,
  0x10,0xef,0x40,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,
  0x00,0x10,0xff,0x30,0x00,
  0x00,0x00,0x9f,0x8f,0x00,
  0x00,0x00,0x40,0xef,0x00,
  0x00,0x00,0x00,0xdf,0x60,
  0x00,0x00,0x00,0x70,0xbf,
  0x00,0x00,0x00,0x10,0xbf,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 4, 0, /* ] */
  0x00,0x00,0x00,0x00,
  0x80,0x80,0x60,0x00,
  0x70,0xbf,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0x00,0x80,0xbf,0x00,
  0xef,0xff,0xaf,0x00,
  0x00,0x00,0x00,0x00,
 6, 0, /* ^ */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x9f,0xcf,0x10,0x00,
  0x00,0x9f,0xcf,0x9f,0xcf,0x10,
  0x00,0x70,0x10,0x00,0x70,0x10,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /* _ */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x60,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 4, 0, /* ` */
  0x00,0x00,0x00,0x00,
  0x20,0xef,0x30,0x00,
  0x00,0x70,0xdf,0x00,
  0x00,0x00,0x30,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
 6, 0, /* a */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x50,0xdf,0xff,0xbf,0x20,
  0x20,0xff,0x70,0x40,0xff,0x00,
  0x80,0xcf,0x00,0x40,0xff,0x00,
  0x70,0xdf,0x00,0x30,0xff,0x10,
  0x20,0xef,0xcf,0xef,0xef,0x60,
  0x00,0x10,0x40,0x20,0x20,0x10,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* b */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x70,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xbf,0x00,0x00,0x00,0x00,
  0x80,0xef,0xef,0xff,0x8f,0x00,
  0x80,0xdf,0x30,0x30,0xff,0x50,
  0x80,0xbf,0x00,0x00,0xbf,0x80,
  0x80,0xbf,0x00,0x10,0xef,0x60,
  0x80,0xff,0xcf,0xef,0xaf,0x00,
  0x20,0x30,0x40,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 5, 0, /* c */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x8f,0xff,0xef,0x60,
  0x40,0xff,0x30,0x30,0x50,
  0xaf,0x9f,0x00,0x00,0x00,
  0xaf,0x9f,0x00,0x10,0x20,
  0x30,0xef,0xcf,0xef,0x8f,
  0x00,0x10,0x40,0x20,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 6, 0, /* d */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x8f,0x80,
  0x00,0x00,0x00,0x00,0xbf,0x80,
  0x00,0x00,0x00,0x00,0xbf,0x80,
  0x00,0x80,0xef,0xff,0xef,0x80,
  0x40,0xff,0x30,0x10,0xdf,0x80,
  0x80,0xbf,0x00,0x00,0xbf,0x80,
  0x70,0xdf,0x10,0x00,0xcf,0x80,
  0x10,0xcf,0xdf,0xdf,0xff,0x9f,
  0x00,0x00,0x40,0x40,0x20,0x20,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* e */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x8f,0xff,0xff,0x8f,0x00,
  0x70,0xef,0x20,0x9f,0xef,0x00,
  0xbf,0xcf,0xdf,0x9f,0x20,0x00,
  0xaf,0xcf,0x10,0x00,0x50,0x30,
  0x30,0xef,0xcf,0xcf,0xef,0x30,
  0x00,0x10,0x40,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 5, 0, /* f */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x10,0xbf,0xff,0x60,
  0x00,0x80,0xdf,0x10,0x00,
  0x00,0xbf,0x80,0x00,0x00,
  0xef,0xff,0xff,0xff,0x60,
  0x00,0xbf,0x80,0x00,0x00,
  0x00,0xbf,0x80,0x00,0x00,
  0x00,0xbf,0x80,0x00,0x00,
  0x00,0xbf,0x80,0x00,0x00,
  0x00,0x8f,0x50,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 6, 0, /* g */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0xdf,0xff,0xdf,0x40,
  0x00,0xef,0x80,0x00,0xcf,0x80,
  0x40,0xff,0x00,0x00,0xef,0x80,
  0x30,0xff,0x30,0x60,0xff,0x80,
  0x00,0x8f,0xff,0xdf,0xdf,0x70,
  0x00,0x00,0x00,0x00,0xef,0x40,
  0x10,0x70,0x40,0x8f,0xef,0x10,
  0x20,0xaf,0xbf,0xaf,0x40,0x00,
 7, 0, /* h */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x80,0xaf,0x00,0x00,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,0x00,0x00,
  0x00,0x80,0xcf,0xbf,0xff,0xaf,0x00,
  0x00,0x80,0xff,0x9f,0x50,0xff,0x00,
  0x00,0x80,0xdf,0x00,0x40,0xff,0x00,
  0x00,0x80,0xbf,0x00,0x40,0xff,0x10,
  0x00,0x80,0xaf,0x00,0x00,0xef,0x30,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 3, 0, /* i */
  0x00,0x00,0x00,
  0x00,0x20,0x10,
  0x00,0x80,0x50,
  0x00,0x00,0x00,
  0x00,0xaf,0x70,
  0x00,0xbf,0x80,
  0x00,0xbf,0x80,
  0x00,0xbf,0x80,
  0x00,0xaf,0x70,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
 4, 0, /* j */
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0x9f,0x60,
  0x00,0x00,0x00,0x00,
  0x00,0x00,0xaf,0x70,
  0x00,0x00,0xbf,0x80,
  0x00,0x00,0xbf,0x80,
  0x00,0x00,0x8f,0xbf,
  0x00,0x00,0x80,0xbf,
  0x20,0x10,0x80,0xbf,
  0x9f,0xaf,0x8f,0xbf,
  0x20,0xdf,0xef,0x40,
 6, 0, /* k */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xaf,0x20,0x00,0x00,0x00,
  0x00,0xff,0x40,0x00,0x00,0x00,
  0x00,0xff,0x40,0x00,0x20,0x10,
  0x00,0xff,0x40,0x30,0xef,0x50,
  0x00,0xff,0x9f,0xdf,0x60,0x00,
  0x00,0xff,0xef,0xff,0x30,0x00,
  0x00,0xff,0x50,0x70,0xef,0x10,
  0x00,0xff,0x40,0x00,0xaf,0x9f,
  0x00,0x30,0x00,0x00,0x10,0x20,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 3, 0, /* l */
  0x00,0x00,0x00,
  0x40,0xef,0x00,
  0x40,0xff,0x00,
  0x40,0xff,0x00,
  0x40,0xff,0x00,
  0x40,0xff,0x00,
  0x40,0xff,0x00,
  0x40,0xff,0x00,
  0x40,0xff,0x00,
  0x00,0x30,0x00,
  0x00,0x00,0x00,
  0x00,0x00,0x00,
 9, 0, /* m */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x50,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xbf,0xaf,0xdf,0xef,0xbf,0xff,0x8f,0x00,
  0x00,0xbf,0xff,0x60,0xff,0x8f,0x8f,0xcf,0x00,
  0x00,0xbf,0x8f,0x00,0xff,0x40,0x60,0xff,0x00,
  0x00,0xbf,0x80,0x00,0xdf,0x60,0x40,0xff,0x10,
  0x00,0xbf,0x80,0x00,0xbf,0x80,0x10,0xff,0x40,
  0x00,0x20,0x10,0x00,0x50,0x30,0x00,0x30,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* n */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x40,0xef,0x9f,0xff,0xcf,0x00,
  0x40,0xff,0xcf,0x30,0xff,0x40,
  0x40,0xff,0x50,0x00,0xff,0x40,
  0x40,0xff,0x00,0x00,0xff,0x40,
  0x40,0xff,0x00,0x00,0xff,0x40,
  0x00,0x40,0x00,0x00,0x30,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* o */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0xdf,0xff,0xbf,0x00,
  0x00,0xef,0x80,0x10,0xef,0x60,
  0x40,0xff,0x00,0x00,0xbf,0x80,
  0x30,0xff,0x20,0x10,0xdf,0x60,
  0x00,0x9f,0xef,0xdf,0xcf,0x00,
  0x00,0x00,0x30,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 5, 0, /* p */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x30,0x10,0x00,0x00,0x00,
  0xff,0xdf,0xff,0xef,0x30,
  0xdf,0xbf,0x10,0xbf,0x9f,
  0xbf,0x80,0x00,0x80,0xbf,
  0xbf,0x80,0x00,0x9f,0xaf,
  0xbf,0xef,0xcf,0xef,0x30,
  0xbf,0x9f,0x40,0x10,0x00,
  0xbf,0x80,0x00,0x00,0x00,
  0x80,0x50,0x00,0x00,0x00,
 5, 0, /* q */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x80,0xef,0xff,0xaf,
  0x60,0xef,0x40,0x80,0xbf,
  0xbf,0x8f,0x00,0x80,0xbf,
  0xbf,0x8f,0x00,0xbf,0x8f,
  0x50,0xff,0xcf,0xff,0x80,
  0x00,0x20,0x40,0xff,0x50,
  0x00,0x00,0x00,0xff,0x40,
  0x00,0x00,0x00,0xaf,0x20,
 5, 0, /* r */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x40,0xef,0x8f,0xff,0x9f,
  0x40,0xff,0x9f,0x8f,0xbf,
  0x40,0xff,0x00,0x20,0x20,
  0x40,0xff,0x00,0x00,0x00,
  0x40,0xff,0x00,0x00,0x00,
  0x10,0x40,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 5, 0, /* s */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x20,0x70,0x30,
  0x20,0xbf,0xdf,0xdf,0x80,
  0x80,0xdf,0x30,0x20,0x10,
  0x10,0x9f,0xdf,0xdf,0x20,
  0x20,0x10,0x00,0xcf,0x80,
  0x9f,0xdf,0xbf,0xff,0x40,
  0x00,0x30,0x40,0x10,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 5, 0, /* t */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0xaf,0x00,0x00,
  0x00,0x40,0xff,0x00,0x00,
  0xaf,0xff,0xff,0xff,0x70,
  0x00,0x40,0xff,0x00,0x00,
  0x00,0x40,0xff,0x00,0x00,
  0x00,0x40,0xff,0x00,0x00,
  0x00,0x40,0xff,0x00,0x00,
  0x00,0x10,0x30,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 5, 0, /* u */
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
  0xaf,0x70,0x00,0x70,0xaf,
  0xbf,0x80,0x00,0x80,0xbf,
  0xbf,0x80,0x00,0x80,0xbf,
  0xbf,0x80,0x00,0x80,0xbf,
  0x8f,0xdf,0xbf,0xef,0xbf,
  0x00,0x30,0x40,0x30,0x20,
  0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 6, 0, /* v */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x60,0xbf,0x00,0x00,0xdf,0x30,
  0x20,0xff,0x20,0x50,0xdf,0x00,
  0x00,0xaf,0x8f,0xbf,0x80,0x00,
  0x00,0x50,0xef,0xff,0x10,0x00,
  0x00,0x00,0xdf,0x9f,0x00,0x00,
  0x00,0x00,0x20,0x10,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 7, 0, /* w */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x70,0xaf,0x00,0xcf,0xaf,0x30,0xef,
  0x70,0xcf,0x30,0xff,0xcf,0x80,0xbf,
  0x40,0xff,0x9f,0xdf,0xff,0xaf,0x8f,
  0x30,0xff,0xef,0x70,0xff,0xef,0x50,
  0x00,0xdf,0xdf,0x00,0xef,0xef,0x10,
  0x00,0x20,0x20,0x00,0x20,0x20,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* x */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x40,0x30,
  0x60,0xcf,0x10,0x30,0xef,0x50,
  0x00,0xaf,0xbf,0xef,0x60,0x00,
  0x00,0x40,0xff,0x9f,0x00,0x00,
  0x30,0xef,0x80,0xef,0x50,0x00,
  0xdf,0x60,0x00,0x50,0xef,0x20,
  0x00,0x00,0x00,0x00,0x30,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* y */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x20,0xff,0x30,0x00,0x40,0xdf,
  0x00,0xbf,0xbf,0x00,0xbf,0x80,
  0x00,0x40,0xff,0x70,0xef,0x10,
  0x00,0x00,0xbf,0xff,0x9f,0x00,
  0x00,0x00,0x50,0xff,0x20,0x00,
  0x00,0x00,0x9f,0x9f,0x00,0x00,
  0x00,0x10,0xef,0x30,0x00,0x00,
  0x00,0x20,0x9f,0x00,0x00,0x00,
 6, 0, /* z */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x30,0xff,0xff,0xff,0xff,0x30,
  0x00,0x00,0x10,0xdf,0x70,0x00,
  0x00,0x00,0x8f,0xbf,0x00,0x00,
  0x00,0x50,0xef,0x10,0x00,0x00,
  0x40,0xef,0xdf,0xbf,0xaf,0x00,
  0x20,0x40,0x40,0x40,0x30,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 6, 0, /* { */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x10,0xbf,0xff,0x70,0x00,
  0x00,0x70,0xdf,0x10,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,0x00,
  0x00,0xcf,0x9f,0x00,0x00,0x00,
  0x20,0xff,0x50,0x00,0x00,0x00,
  0x00,0x8f,0xbf,0x00,0x00,0x00,
  0x00,0x80,0xbf,0x00,0x00,0x00,
  0x00,0x50,0xff,0x10,0x00,0x00,
  0x00,0x00,0x9f,0xff,0x60,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 3, 0, /* | */
  0x00,0x70,0x20,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xff,0x40,
  0x00,0xaf,0x20,
  0x00,0x00,0x00,
 5, 0, /* } */
  0x00,0x00,0x00,0x00,0x00,
  0x30,0xff,0xbf,0x00,0x00,
  0x00,0x10,0xff,0x40,0x00,
  0x00,0x00,0xff,0x40,0x00,
  0x00,0x00,0xff,0x40,0x00,
  0x00,0x00,0xdf,0x9f,0x00,
  0x00,0x00,0x8f,0xef,0x20,
  0x00,0x00,0xff,0x50,0x00,
  0x00,0x00,0xff,0x40,0x00,
  0x00,0x40,0xff,0x20,0x00,
  0x30,0xff,0x8f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,
 6, 0, /* ~ */
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x30,0xbf,0x60,0x00,0x70,
  0x10,0xef,0x80,0xff,0x8f,0xef,
  0x10,0x70,0x00,0x60,0xbf,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
 8, 0, /*   */
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x50,0xcf,0xff,0xff,0x9f,0x10,
  0x00,0x60,0xef,0x80,0x80,0x40,0xcf,0x8f,
  0x10,0xef,0x80,0xff,0x8f,0x40,0x50,0xef,
  0x40,0xff,0x80,0xcf,0x10,0x70,0x40,0xff,
  0x30,0xff,0x40,0xdf,0xff,0x8f,0x9f,0xbf,
  0x00,0xcf,0x9f,0x20,0x00,0x70,0xff,0x30,
  0x00,0x20,0xaf,0xff,0xff,0xdf,0x40,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0 };

/////////////////////////////////////////////////////////////////////////////

const int Cosmic10Font::font_char_addr[96] = {
0, 38, 64, 126, 248, 334, 432, 518, 556, 606, 656, 730, 792, 842, 904, 930,
992, 1078, 1128, 1202, 1276, 1362, 1436, 1510, 1584, 1658, 1732, 1758, 1808,
1858, 1908, 1958, 2032, 2142, 2228, 2302, 2388, 2474, 2548, 2622, 2708,
2794, 2868, 2954, 3028, 3102, 3212, 3310, 3408, 3482, 3592, 3678, 3764,
3862, 3948, 4034, 4180, 4278, 4352, 4450, 4488, 4550, 4600, 4674, 4772,
4822, 4896, 4970, 5032, 5106, 5180, 5242, 5316, 5402, 5440, 5490, 5564,
5602, 5712, 5786, 5860, 5922, 5984, 6046, 6108, 6170, 6232, 6306, 6392,
6466, 6540, 6614, 6688, 6726, 6788, 6862 };

/////////////////////////////////////////////////////////////////////////////
