// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLImageFormat.h

  Stephane Rehel

  September 20 1997
*/

#ifndef __MLImageFormat_h
#define __MLImageFormat_h

#ifndef __OString_h
#include "tools/OString.h"
#endif

class MLImage;

/////////////////////////////////////////////////////////////////////////////

class MLImageFormat
{
public:
  enum FORMAT
       {
       NULL_FMT= 0,

       JPG,
       TIF,
       GIF,
       RGB,
       TGA,
       PNM,
       BMP,

       LAST_FMT
       };

public:
  static int getNFormats();

  // 1 <= i <= nFormats
  static FORMAT getFromIndex( int i );

  static OString getName( FORMAT fmt );

  static FORMAT getFromName( const OString& name );

  static OString getExtension( FORMAT fmt );

  static FORMAT getFromFilename( const OString& filename );

  static IBOOL availableReader( FORMAT fmt );
  static IBOOL availableWriter( FORMAT fmt );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLImageFormat_h
