/* "lispish" nested lists of strings.
 *
 * gsumi version 0.5
 *
 * Copyright 1997 Owen Taylor <owt1@cornell.edu>
*/

/* The two possibilities for a node */
typedef enum {
  NODE_STRING,
  NODE_LIST
} NodeType;

/* the basic structure which comprises a tree */
typedef struct _Node Node;

struct _Node {
  NodeType type;
  union {
    char *s;
    Node *l;
  } c;
  Node *next;
};

void node_free(Node *node);
Node *node_string_from_file(FILE *file);
Node *node_list_from_file(FILE *file, int is_toplevel);
void node_string_to_file(Node *node,FILE *file);
void node_list_to_file(Node *node, FILE *file, int level);
Node *node_list_new();
Node *node_string_new(char *str);
void node_list_append(Node *list, Node *new);

Node *node_pair_double(char *key, double val);
Node *node_pair_string(char *key, char *val);
Node *node_list_remove_pair(Node *list, char *key);
char *node_list_lookup_pair(Node *list, char *key);

int node_list_matches(Node *node, ...);
Node *node_list_remove_match(Node *list, ...);
Node *node_list_find_match(Node *list, ...);
