/*  SCAVENGER by David Ashley  dash@netcom.com dash5@geocities.com */
/*
 * sound.c - Platform Independant Sound Support - Apr. 1995
 *
 * Copyright 1994-1995 Sujal M. Patel (smpatel@wam.umd.edu)
 * Conditions in "copyright.h"          
 */


#include <stdio.h>
#include <unistd.h>
#include <signal.h>

#include "scav.h"
#include "sound.h"

char *unixSoundDev = SOUNDDEV;

static int  soundfd;
static char audioOK = 1;
static char sound_flags[20];	/* Sound Flag for sound 1-19 */
int         child;

void test_sound ()
{
  if (audioOK)
    if (kill (child, 0))
      {
	audioOK = 0;
	close (soundfd);
      };
}

void init_sound ()
{
  int             i, fd[2];
  char           *argv[4];
  char            filename[512];
  char  dirnames[256];

  signal (SIGCHLD, SIG_IGN);

  if (*unixSoundDev==0)
    {
      audioOK = 0;
      return;
    };

  /*  Create a pipe, set the write end to close when we exec the sound server,
     and set both (is the write end necessary?) ends to non-blocking   */
  pipe (fd);
  soundfd = fd[1];

  if (!(child = fork ()))
    {
      close (fd[1]);
      dup2 (fd[0], STDIN_FILENO);
      close (fd[0]);
      sprintf (filename,"%s/%s",libname, SOUNDSERVER);
		sprintf(dirnames,"%s/%s,%s",localname,localdirname,libname);
      argv[0] = filename;
      argv[1] = dirnames;
      argv[2] = unixSoundDev;
      argv[3] = NULL;
      execvp (filename, argv);
      fprintf (stderr, "Couldn't Execute Sound Server %s!\n", filename);
      sprintf (filename,"%s/%s/%s",localname,localdirname, SOUNDSERVER);
      execvp (filename, argv);
      fprintf (stderr, "Couldn't Execute Sound Server %s!\n", filename);
      exit (0);
    };
  close (fd[0]);

  for (i = 0; i < 19; i++)
    sound_flags[i] = 0;
}

int play_sound (int k)
{
  char            c;
  test_sound ();
  c = k;
  if ((playSounds) && (audioOK))
    write (soundfd, &c, sizeof (c));
  return 0;
}



void maybe_play_sound (int k)
{
  char            c;

  if (sound_flags[k] & 1)
    return;

  sound_flags[k] |= 1;
  test_sound ();
  c = (unsigned char) (k);
  if ((playSounds) && (audioOK))
    write (soundfd, &c, sizeof (c));
}



void sound_completed (int k)
{
  sound_flags[k] &= ~1;
}



void kill_sound ()
{
  signed char            c;

  c = -1;
  test_sound ();
  if ((playSounds) && (audioOK))
    write (soundfd, &c, sizeof (c));
}
