/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __XQF_H__
#define __XQF_H__

#include <gtk/gtk.h>


#define RC_DIR		".qf"
#define RC_FILE		"qfrc"
#define EXEC_CFG	"__qf__.cfg"

#define MAX_PING	9999
#define MAX_RETRIES	10

#define	QWM_DEFAULT_PORT	27000
#define	QW_DEFAULT_PORT		27500
#define	Q2_DEFAULT_PORT		27910


#define SERVER_CHEATS		1
#define SERVER_PASSWORD		2
#define SERVER_SP_PASSWORD	4


enum server_type { QW_SERVER, Q2_SERVER };


struct player {
  int	id;
  char	*name;
  int	frags;
  int 	time;
  int	shirt;
  int	pants;
  int	ping;
  char	*skin;
};


enum psort_mode {
  SORT_PLAYER_NONE = 0,
  SORT_PLAYER_ID,
  SORT_PLAYER_NAME,
  SORT_PLAYER_FRAGS,
  SORT_PLAYER_TIME,
  SORT_PLAYER_COLOR,
  SORT_PLAYER_PING,
  SORT_PLAYER_SKIN
};


struct server {
  enum server_type type;

  char	*address;
  int	port;

  char	*name;
  char	*map;
  int	maxplayers;
  int	curplayers;
  int	ping;
  int	retries;
  struct player **players;
  char 	**info;
  char 	*game;	/* a reference to info item */
  int 	flags;

  int 	ref_count;
};


enum ssort_mode {
  SORT_SERVER_NONE = 0,
  SORT_SERVER_NAME,
  SORT_SERVER_ADDRESS,
  SORT_SERVER_MAP,
  SORT_SERVER_PLAYERS,
  SORT_SERVER_PING,
  SORT_SERVER_TO,
  SORT_SERVER_GAME
};


struct master {
  char	*address;
  char	*name;
  GSList *servers;
};


struct clist_coldef {
  char 	*name;
  int	width;
  GtkJustification justify;
  int	sortmode;
  GtkWidget *widget;
};


extern	struct clist_coldef server_clist_columns[];
extern  struct clist_coldef player_clist_columns[];
extern  struct clist_coldef serverinfo_clist_columns[];
extern 	int psort_column;
extern 	int ssort_column;


struct user_info {
  char	*name;
  char	*home;
  char	*rcdir;
};

extern  struct user_info user;


extern 	GtkWidget *main_window;
extern  GtkWidget *server_clist;
extern  GtkWidget *player_clist;
extern  GtkWidget *serverinfo_clist;


extern	void print_status (char *fmt, ...);

extern	int window_delete_event_callback (GtkWidget *widget, gpointer data);
extern	void register_window (GtkWidget *window);
extern	void unregister_window (GtkWidget *window);


#endif /* __XQF_H__ */

