/**********************************************************************/
/* COULEURS.C : Definitions des couleurs pour l'Editeur JERED         */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include <ctype.h>
#include "jered.h"
#include "messages.h"

typedef struct _COULEUR_
        {
                char *couleur;
                char *color;
                int valeur;
        }
        COULEUR;

typedef struct _ATTRIBUT_
        {
                char *attribut;
                chtype valeur;
        }
        ATTRIBUT;

static COULEUR tab_couleurs[] = {
                                        { "COULEUR_STATUS", "COLOR_STATUS", COULEUR_STATUS },
                                        { "COULEUR_AIDE", "COLOR_HELP", COULEUR_AIDE },
                                        { "COULEUR_MOTCLE", "COLOR_KEYWORD", COULEUR_MOTCLE },
                                        { "COULEUR_CHAINE", "COLOR_STRING", COULEUR_CHAINE },
                                        { "COULEUR_COMMENT", "COLOR_COMMENT", COULEUR_COMMENT },
                                        { "COULEUR_ALERTE1", "COLOR_ALERT1", COULEUR_ALERTE1 },
                                        { "COULEUR_ALERTE2", "COLOR_ALERT2", COULEUR_ALERTE2 },
                                        { "COULEUR_NORMALE", "COLOR_NORMAL", COULEUR_NORMALE },
                                        { "COULEUR_BLOC", "COLOR_BLOCK", COULEUR_BLOC },
                                        { "COULEUR_CHAR", "COLOR_CHAR", COULEUR_CHAR },
                                        { "COULEUR_SURBRILLANCE", "COLOR_HIGHLIGHT", COULEUR_SURBRILLANCE },
                                        { "COLOR_BLACK", "COLOR_BLACK", COLOR_BLACK },
                                        { "COLOR_RED", "COLOR_RED", COLOR_RED },
                                        { "COLOR_GREEN", "COLOR_GREEN", COLOR_GREEN },
                                        { "COLOR_YELLOW", "COLOR_YELLOW", COLOR_YELLOW },
                                        { "COLOR_BLUE", "COLOR_BLUE", COLOR_BLUE },
                                        { "COLOR_MAGENTA", "COLOR_MAGENTA", COLOR_MAGENTA },
                                        { "COLOR_CYAN", "COLOR_CYAN", COLOR_CYAN },
                                        { "COLOR_WHITE", "COLOR_WHITE", COLOR_WHITE },
                                        { NULL, NULL, -1 }
                                };

static ATTRIBUT tab_attributs[] = {
                                        { "A_NORMAL", A_NORMAL },
                                        { "A_STANDOUT", A_STANDOUT },
                                        { "A_UNDERLINE", A_UNDERLINE },
                                        { "A_REVERSE", A_REVERSE },
                                        { "A_BLINK", A_BLINK },
                                        { "A_DIM", A_DIM },
                                        { "A_BOLD", A_BOLD },
                                        { NULL, 0 }
                                  };

static JEREDCOLOR tab_colors[NBJEREDCOLORS];

int hascolors;

char helpbar[256];
char eschelpbar[256];

extern int autoplay;    /* joue automatiquement les macros ou non */
extern int tabsize;     /* taille des tabulations */
extern int backup;      /* copie de sauvegarde: YES/NO/OUI/NON */
extern time_t autosave; /* delay between two autosaves of a file */
extern int savetabs;    /* indicates if we save files with their tabs or with spaces */
extern int autowordwrap;  /* indicates if autowordwrapping is enabled or not */
extern int wordwrapbegin; /* beginning column */
extern int wordwrapend;   /* end column */
extern int locking;       /* locking type for edited files */


int recherche_couleur(char **pt);
chtype recherche_attribut(char **pt);
void control_wordwrap_limits(void);
/**********************************************************************/
void initialise_profile(char *filename)
{
        FILE *fp;
        char buffer[256];
        char *ptl;
        char *ptw;

        /* here follow all default values */
        tabsize = 8;    /* valeurs par defaut */
        backup = OUI;
        language = ENGLISH;
        hascolors = NON; /* par defaut on tient compte de has_colors() */
        autoplay = OUI;
        autosave = (time_t)0; /* no autosave by default */
        savetabs = NON; /* by default we don't save tabs, we save spaces */
        autowordwrap = NON;
        wordwrapbegin = 1;
        wordwrapend = (SZBUF - 10);
        locking = LOCK_NONE;    /* no lock for edited files */

        *helpbar = *eschelpbar = '\0';
        
        /* default user interface language */
        set_language(language);

        build_default_keymap(); /* default key mappings */

        /* couleurs par defaut */
        /* ce sont celles que j'utilise habituellement */
        /* il fallait bien en choisir !!! */
        tab_colors[COULEUR_STATUS].color1 = COLOR_BLACK;
        tab_colors[COULEUR_STATUS].color2 = COLOR_CYAN;
        tab_colors[COULEUR_STATUS].attr1 = A_NORMAL;
        tab_colors[COULEUR_STATUS].attr2 = A_NORMAL;
        tab_colors[COULEUR_AIDE].color1 = COLOR_BLACK;
        tab_colors[COULEUR_AIDE].color2 = COLOR_CYAN;
        tab_colors[COULEUR_AIDE].attr1 = A_NORMAL;
        tab_colors[COULEUR_AIDE].attr2 = A_NORMAL;
        tab_colors[COULEUR_NORMALE].color1 = COLOR_WHITE;
        tab_colors[COULEUR_NORMALE].color2 = COLOR_BLACK;
        tab_colors[COULEUR_NORMALE].attr1 = A_NORMAL;
        tab_colors[COULEUR_NORMALE].attr2 = A_NORMAL;
        tab_colors[COULEUR_MOTCLE].color1 = COLOR_RED;
        tab_colors[COULEUR_MOTCLE].color2 = COLOR_BLACK;
        tab_colors[COULEUR_MOTCLE].attr1 = A_BOLD;
        tab_colors[COULEUR_MOTCLE].attr2 = A_NORMAL;
        tab_colors[COULEUR_CHAINE].color1 = COLOR_BLUE;
        tab_colors[COULEUR_CHAINE].color2 = COLOR_BLACK;
        tab_colors[COULEUR_CHAINE].attr1 = A_BOLD;
        tab_colors[COULEUR_CHAINE].attr2 = A_NORMAL;
        tab_colors[COULEUR_COMMENT].color1 = COLOR_GREEN;
        tab_colors[COULEUR_COMMENT].color2 = COLOR_BLACK;
        tab_colors[COULEUR_COMMENT].attr1 = A_NORMAL;
        tab_colors[COULEUR_COMMENT].attr2 = A_NORMAL;
        tab_colors[COULEUR_ALERTE1].color1 = COLOR_BLACK;
        tab_colors[COULEUR_ALERTE1].color2 = COLOR_CYAN;
        tab_colors[COULEUR_ALERTE1].attr1 = A_NORMAL;
        tab_colors[COULEUR_ALERTE1].attr2 = A_NORMAL;
        tab_colors[COULEUR_ALERTE2].color1 = COLOR_BLACK;
        tab_colors[COULEUR_ALERTE2].color2 = COLOR_CYAN;
        tab_colors[COULEUR_ALERTE2].attr1 = A_REVERSE;
        tab_colors[COULEUR_ALERTE2].attr2 = A_BLINK;
        tab_colors[COULEUR_BLOC].color1 = COLOR_WHITE;
        tab_colors[COULEUR_BLOC].color2 = COLOR_BLUE;
        tab_colors[COULEUR_BLOC].attr1 = A_NORMAL;
        tab_colors[COULEUR_BLOC].attr2 = A_NORMAL;
        tab_colors[COULEUR_CHAR].color1 = COLOR_MAGENTA;
        tab_colors[COULEUR_CHAR].color2 = COLOR_BLACK;
        tab_colors[COULEUR_CHAR].attr1 = A_BOLD;
        tab_colors[COULEUR_CHAR].attr2 = A_NORMAL;
        tab_colors[COULEUR_SURBRILLANCE].color1 = COLOR_RED;
        tab_colors[COULEUR_SURBRILLANCE].color2 = COLOR_CYAN;
        tab_colors[COULEUR_SURBRILLANCE].attr1 = A_BOLD;
        tab_colors[COULEUR_SURBRILLANCE].attr2 = A_NORMAL;

        /* on essaie d'ouvrir le fichier des preferences */
        fp = fopen(filename, "rt");
        if (fp != NULL)
        {
                /* on lit les couleurs dans le fichier */
                while ((ptl = fgets(buffer, 255, fp)) != NULL)
                {
                        ptw = ptl + strlen(ptl);

                        /* delete all not interesting tailing chars */
                        while ((ptw >= ptl) && ((! *ptw) || isspace(*ptw)))
                                *ptw-- = '\0';

                        test_config(ptl);
                }
                fclose(fp);
        }

        /* si le terminal n'accepte pas les couleurs on force */
        /* des valeurs pas trop craignos */
        if ((hascolors == NON) && (has_colors() == FALSE))
        {
                /* le terminal n'accepte pas les couleurs */
                couleur[COULEUR_STATUS] = A_REVERSE;
                couleur[COULEUR_AIDE] = A_REVERSE;
                couleur[COULEUR_NORMALE] = A_NORMAL;
                couleur[COULEUR_MOTCLE] = A_BOLD;
                couleur[COULEUR_CHAINE] = A_BOLD;
                couleur[COULEUR_COMMENT] = A_REVERSE;
                couleur[COULEUR_ALERTE1] = A_REVERSE;
                couleur[COULEUR_ALERTE2] = A_NORMAL;
                couleur[COULEUR_BLOC] = A_REVERSE | A_BLINK;
                couleur[COULEUR_CHAR] = A_BOLD;
                couleur[COULEUR_SURBRILLANCE] = A_BLINK;
        }
        else
                set_jered_colors();
}
/**********************************************************************/
void set_jered_colors(void)                        
{
        int paire;
        
        for (paire = 1; paire <= NBJEREDCOLORS; paire++)
        {
                init_pair(paire, tab_colors[paire].color1, tab_colors[paire].color2);
                couleur[paire] = tab_colors[paire].attr1 | tab_colors[paire].attr2 | COLOR_PAIR(paire);
        }
}        
/**********************************************************************/
int recherche_couleur(char **pt)
{
        COULEUR *ptc;
        int trouve = 0;
        int lg;

        for (ptc = tab_couleurs; ptc->couleur != NULL; ptc++)
        {
                lg = strlen(ptc->couleur);
                if (strncasecmp(ptc->couleur, *pt, lg))
                {
                        lg = strlen(ptc->color);
                        if (strncasecmp(ptc->color, *pt, lg))
                                lg = -1;
                }
                if (lg != -1)
                {
                        trouve = ptc->valeur;
                        (*pt) += lg;
                        while (**pt && (**pt != ':'))
                                (*pt)++;
                        if (**pt)
                                (*pt)++;           /* on saute les ':' */

                        /* on pointe vers le prochain mot */
                        while (**pt && ((**pt == ' ') || (**pt == '\t')))
                                (*pt)++;
                        break;
                }
        }
        return(trouve);
}
/**********************************************************************/
chtype recherche_attribut(char **pt)
{
        ATTRIBUT *pta;
        chtype trouve = A_NORMAL;

        for (pta = tab_attributs; pta->attribut != NULL; pta++)
        {
                if (! strncasecmp(pta->attribut, *pt, strlen(pta->attribut)))
                {
                        trouve = pta->valeur;
                        (*pt) += strlen(pta->attribut);
                        while (**pt && (**pt != ':'))
                                (*pt)++;
                        if (**pt)
                                (*pt)++;        /* on saute les ':' */
                        while (**pt && ((**pt == ' ') || (**pt == '\t')))
                                (*pt)++;
                        break;
                }
        }
        return(trouve);
}
/**********************************************************************/
void test_config(char *line)
{
        int paire;
        
        if ((! strncasecmp(line, "ESC_KEY_", 8)) || (! strncasecmp(line, "KEY_", 4)))
                remap_a_key(line);      /* we have found a key mapping definition */
        else if (! strncasecmp(line, "HELPBAR:", 8))
                init_helpbars(line + 8, NULL);
        else if (! strncasecmp(line, "ESCHELPBAR:", 11))
                init_helpbars(NULL, line + 11);
        else if (! strncasecmp(line, "TABSIZE:", 8))
                tabsize = atoi(line + 8);
        else if (! strncasecmp(line, "AUTOSAVE:", 9))
                autosave = (time_t)atol(line + 9);
        else if (! strncasecmp(line, "WORDWRAPBEGIN:", 14))
        {
                wordwrapbegin = atoi(line + 14);
                control_wordwrap_limits();
        }
        else if (! strncasecmp(line, "WORDWRAPEND:", 12))
        {
                wordwrapend = atoi(line + 12);
                control_wordwrap_limits();
        }
        else if (! strncasecmp(line, "AUTOWORDWRAP:", 13))
        {
                /* ce double test est bien inutile, mais enfin */
                if ((! strncasecmp(line + 13, "YES", 3)) || (! strncasecmp(line + 13, "OUI", 3)))
                        autowordwrap = OUI;
                else
                        autowordwrap = NON;
        }
        else if (! strncasecmp(line, "LOCK:", 5))
        {
                if (! strncasecmp(line + 5, "READONLY", 8))
                        locking = LOCK_READONLY;
                else if (! strncasecmp(line + 5, "STRICT", 6))        
                        locking = LOCK_STRICT;
                else
                        locking = LOCK_NONE;
        }
        else if (! strncasecmp(line, "SAVETABS:", 9))
        {
                /* ce double test est bien inutile, mais enfin */
                if ((! strncasecmp(line + 9, "YES", 3)) || (! strncasecmp(line + 9, "OUI", 3)))
                        savetabs = OUI;
                else
                        savetabs = NON;
        }
        else if (! strncasecmp(line, "BACKUP:", 7))
        {
                /* ce double test est bien inutile, mais enfin */
                if ((! strncasecmp(line + 7, "NON", 3)) || (! strncasecmp(line + 7, "NO", 2)))
                        backup = NON;
                else
                        backup = OUI;
        }
        else if (! strncasecmp(line, "AUTOPLAYMACRO:", 14))
        {
                /* ce double test est bien inutile, mais enfin */
                if ((! strncasecmp(line + 14, "NON", 3)) || (! strncasecmp(line + 14, "NO", 2)))
                        autoplay = NON;
                else
                        autoplay = OUI;
        }
        else if (! strncasecmp(line, "COLORS:", 7))
        {
                if ((! strncasecmp(line + 7, "YES", 3)) || (! strncasecmp(line + 7, "OUI", 3)))
                        hascolors = OUI;
                else
                        hascolors = NON;
        }
        else if (! strncasecmp(line, "LANGUAGE:", 9))
        {
                if ((! strncasecmp(line + 9, "FRENCH", 6)) || (! strncasecmp(line + 9, "FRANCAIS", 8)))
                        language = FRENCH;
                else if ((! strncasecmp(line + 9, "FINNISH", 7)) || (! strncasecmp(line + 9, "SUOMI", 5)))
                        language = FINNISH;
                else if ((! strncasecmp(line + 9, "GERMAN", 6)) || (! strncasecmp(line + 9, "DEUTSCH", 6)))
                        language = GERMAN;
                else if ((! strncasecmp(line + 9, "RUSSIAN", 7)) || (! strncasecmp(line + 9, "RUSSIAN", 7)))
                        language = RUSSIAN;
                else
                        language = ENGLISH;
                        
                /* now we know the user interface language */
                set_language(language);
        }
        else
        {
                paire = recherche_couleur(&line);
                if (paire)
                {
                        tab_colors[paire].color1 = recherche_couleur(&line);
                        tab_colors[paire].color2 = recherche_couleur(&line);
                        tab_colors[paire].attr1 = recherche_attribut(&line);
                        tab_colors[paire].attr2 = recherche_attribut(&line);
                }
        }
}                        
/**********************************************************************/
void control_wordwrap_limits(void)
{
        /* we ensure that wordwrapbegin is <= wordwrapend */
        if (wordwrapbegin > wordwrapend)
        {
                int tmp = wordwrapbegin;
                wordwrapbegin = wordwrapend;
                wordwrapend = tmp;
        }

        /* we ensure that (wordwrapend - wordwrapbegin) is >= 1 */
        if ((wordwrapend - wordwrapbegin) < 1)
                wordwrapend = wordwrapbegin + 1;
}
/**********************************************************************/
void init_helpbars(char *hb, char *eschb)
{
        if (hb != NULL)
                strcpy(helpbar, hb);
        if (eschb != NULL)
                strcpy(eschelpbar, eschb);
}        
/**********************************************************************/
