-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
class REAL_REF

inherit
   HASHABLE;
   NUMERIC
      undefine out_in_tagged_out_memory, fill_tagged_out_memory
      redefine
	 infix "^", prefix "+", prefix "-"
      end;
   COMPARABLE
      redefine
	 compare, out_in_tagged_out_memory, fill_tagged_out_memory
      end;

creation make

feature 

   item: REAL;

   make(value: REAL) is
      do
	 item := value
      end;
   
feature
   
   set_item(value: like item) is
      do
	 item := value;
      end;

   infix "+" (other: like Current): like Current is
	 -- Add `other' to Current.
      do
	 !!Result.make (item + other.item)
      end;

   infix "-" (other: like Current): like Current is
	 -- Subtract `other' from Current.
      do
	 !!Result.make (item - other.item);
      end;

   infix "*" (other: like Current): like Current is
	 -- Multiply `other' by Current.
      do
	 !!Result.make (item * other.item)
      end;

   infix "/" (other: like Current): like Current is
	 -- Divide Current by `other'.
      do
	 !!Result.make (item / other.item)
      end;

   infix "^" (exp: INTEGER): DOUBLE_REF is
	 -- Raise Current to `exp'-th power.
      do
	 !!Result.make (item ^ exp)
      end;

   prefix "+" : like Current is
      do
	 !!Result.make (item)
      end;

   prefix "-" : like Current is
      do
	 !!Result.make (-item);
      end;

   infix "<" (other: like Current): BOOLEAN is
	 -- Is Current less than `other'?
      do
	 Result := item < other.item
      end;

   compare (other: like Current): INTEGER is
	 -- Compare Current with `other'.
	 -- '<' <==> Result < 0
	 -- '>' <==> Result > 0
	 -- Otherwise Result = 0
      do
	 Result := item.compare (other.item)
      end;

   valid_divisor (other: like Current): BOOLEAN is
      do
	 Result := (other.item /= 0.0)
      end;

   one: like Current is
      do
	 !!Result.make (1.0)
      end;

   zero: like Current is
      do
	 !!Result.make (0.0)
      end;

   out_in_tagged_out_memory, fill_tagged_out_memory is
      do
	 item.fill_tagged_out_memory;
      end;

   hash_code: INTEGER is
      do
	 Result := item.hash_code;
      end;

end -- REAL_REF

