-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
class BOOLEAN_REF
   
inherit 
   ANY 
      redefine out_in_tagged_out_memory, fill_tagged_out_memory
      end;
   
creation make

feature 

   item: BOOLEAN;      
	 -- Value of Current

   make(value: BOOLEAN) is
	 -- Initialize object
      do  
	 item := value
      end;

feature
   
   set_item(value: like item) is
      do
	 item := value;
      end;

   infix "and" (other : BOOLEAN_REF) : BOOLEAN_REF is
	 -- `and' of Current with `other'.
      require
	 other /= Void
      do
	 !!Result.make (item and other.item)
      end;

   infix "and then" (other : BOOLEAN_REF) : BOOLEAN_REF is
	 -- Semi-strict `and' of Current with `other'.
      require
	 other /= Void
      do
	 !!Result.make (item and then other.item)
      end;

   infix "implies" (other : BOOLEAN_REF) : BOOLEAN_REF is
	 -- Does Current imply `other'.
      require
	 other /= Void
      do
	 !!Result.make (item implies other.item)
      end;

   infix "or" (other : BOOLEAN_REF) : BOOLEAN_REF is
	 -- `or' of Current with `other'
      require
	 other_not_void : other /= Void
      do
	 !!Result.make (item or other.item)
      end;

   infix "or else" (other : BOOLEAN_REF) : BOOLEAN_REF is
	 -- Semi-strict `or' of Current with `other'
      require
	 other_not_void : other /= Void
      do
	 !!Result.make (item or else other.item)
      end;

   infix "xor" (other: BOOLEAN_REF): BOOLEAN_REF is
	 -- `xor' of Current with `other'
      require
	 other /= Void
      do
	 !!Result.make (item xor other.item)
      end;

   prefix "not": BOOLEAN_REF is
	 -- `not' of Current.
      do
	 !!Result.make(not item)
      end;

   out_in_tagged_out_memory, fill_tagged_out_memory is
      do
	 item.fill_tagged_out_memory;
      end;

   to_string: STRING is
      do
	 if Current.item then
	    Result := "true";
	 else
	    Result := "false";
	 end;
      end;
   
   to_integer: INTEGER is
      do
	 if Current.item then
	    Result := 1;
	 else
	    Result := 0;
	 end;
      end;
   
end -- BOOLEAN_REF

