dnl ---------------------------------------------------------------------------
dnl Check if C compiler supports -c -o file.ooo
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CC_O],
[
AC_MSG_CHECKING(whether $CC understand -c and -o together)
set dummy $CC; ac_cc="`echo [$]2 |
changequote(, )dnl
		       sed -e 's/[^a-zA-Z0-9_]/_/g' -e 's/^[0-9]/_/'`"
changequote([, ])dnl
AC_CACHE_VAL(ac_cv_prog_cc_${ac_cc}_c_o,
[echo 'foo(){}' > conftest.c
# We do the test twice because some compilers refuse to overwrite an
# existing .o file with -o, though they will create one.
eval ac_cv_prog_cc_${ac_cc}_c_o=no
ac_try='${CC-cc} -c conftest.c -o conftest.ooo 1>&AC_FD_CC'
if AC_TRY_EVAL(ac_try) && test -f conftest.ooo && AC_TRY_EVAL(ac_try);
then
  ac_try='${CC-cc} -c conftest.c -o conftest.ooo 1>&AC_FD_CC'
  if AC_TRY_EVAL(ac_try) && test -f conftest.ooo && AC_TRY_EVAL(ac_try);
  then
    eval ac_cv_prog_cc_${ac_cc}_c_o=yes
  fi
fi
rm -f conftest*
])dnl
if eval "test \"`echo '$ac_cv_prog_cc_'${ac_cc}_c_o`\" = yes"; then
	O2SHO=""
	O2SAVE=""
	SAVE2O=""
	CC2O="-o $"'@'
	AC_MSG_RESULT(yes)
else
	O2SHO="-mv \`basename "$'@'" .sho\`.o "$'@'
	O2SAVE="-mv \`basename "$'@'" .sho\`.o \`basename "$'@'" .sho\`.o.save"
	SAVE2O="-mv \`basename "$'@'" .sho\`.o.save \`basename "$'@'" .sho\`.o"
	CC2O=""
	AC_MSG_RESULT(no)
fi
])

dnl ---------------------------------------------------------------------------
dnl Work out how to create a dynamically loaded module
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_HOWTO_DYN_LINK],
[
mh_compile='${CC-cc} -c $DYN_COMP conftest.$ac_ext 1>&AC_FD_CC'
cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int foo()
{
return(0);
}
EOF
if AC_TRY_EVAL(mh_compile) && test -s conftest.o; then
	mh_dyn_link='ld -shared -o conftest.rxlib conftest.o -lc 1>&AC_FD_CC'
	if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.rxlib; then
		LD_RXLIB1="ld -shared"
		LD_RXLIB2="-L. -l${LIBFILE}"
	else
		mh_dyn_link='ld -G -o conftest.rxlib conftest.o 1>&AC_FD_CC'
		if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.rxlib; then
			LD_RXLIB1="ld -G"
			LD_RXLIB2="-L. -l${LIBFILE}"
		else
			LD_RXLIB1=""
			LD_RXLIB2=""
		fi
	fi
fi
rm -f conftest*
])dnl

dnl ---------------------------------------------------------------------------
dnl Work out how to create a shared library
dnl ---------------------------------------------------------------------------
AC_DEFUN(MH_HOWTO_SHARED_LIBRARY,
[
AC_MSG_CHECKING(how to create a shared library)
mh_compile='${CC-cc} -c $DYN_COMP conftest.$ac_ext 1>&AC_FD_CC'
cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int foo()
{
return(0);
}
EOF
if AC_TRY_EVAL(mh_compile) && test -s conftest.o; then
	mh_dyn_link='ld -shared -o conftest.so.1.0 conftest.o -lc 1>&AC_FD_CC'
	if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
		SHL_LD="ld -shared -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'" -lc"
	else
		mh_dyn_link='ld -G -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
		if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
			SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		else
			mh_dyn_link='ld -o conftest.so.1.0 -shared -no_archive conftest.o  -lc 1>&AC_FD_CC'
			if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
				SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" -shared -no_archive "'$('SHOFILES')'" -lc"
			else
				mh_dyn_link='ld -b -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
				if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
					SHL_LD="ld -b -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
				else
					mh_dyn_link='ld -Bshareable -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
					if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
						SHL_LD="ld -Bshareable -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
					else
						mh_dyn_link='ld -assert pure-text -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
						if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
							SHL_LD="ld -assert pure-text -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
						else
							SHL_LD=""
						fi
					fi
				fi
			fi
		fi
	fi
fi
if test "$SHL_LD" = ""; then
	AC_MSG_RESULT(unknown)
else
	AC_MSG_RESULT(found)
fi
rm -f conftest*
])

dnl ---------------------------------------------------------------------------
dnl Check for presence of various libraries
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_LIB],
[
MH_EXTRA_LIBS=''
for mh_lib in $1; do
	AC_CHECK_LIB($mh_lib,main,mh_lib_found=yes,mh_lib_found=no)
	if test "$mh_lib_found" = yes; then
		MH_EXTRA_LIBS="${MH_EXTRA_LIBS} -l${mh_lib}"
	fi
done
])dnl

dnl ---------------------------------------------------------------------------
dnl Determine how to build shared libraries etc..
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_SHARED_LIBRARY],
[
dnl
dnl If compiler is gcc, then flags should be the same for all platforms
dnl (just guessing on this)
dnl
SHL="so"
LIBPRE="lib"
LIBFILE="regina"
SHLFILE="regina"
OSAVE=".o.save"
OBJ="o"
EXE=""
LIBPST="a"
LIBEXE="ar"
RXLIB="rxlib"
GETOPT=""
OBJECTS='$('OFILES')'
CURSESLIB="-lcurses"
STATIC_LDFLAGS=""
AIX_DYN="no"

AC_REQUIRE([AC_CANONICAL_SYSTEM])
case "$target" in
	*hp-hpux10*)
		SYS_DEFS="-D_HPUX_SOURCE"
#		MH_EXTRA_LIBS="-ll -ldld"
#		SHLIBS="-ldld"
		CURSESLIB="-lcur_colr"
		SHL="sl"
		;;
	*hp-hpux*) 
		SYS_DEFS="-D_HPUX_SOURCE"
#		MH_EXTRA_LIBS="-ll -ldld"
#		SHLIBS="-ldld"
		SHL="sl"
		CURSESLIB="-lcurses"
		;;
	*ibm-aix4.2*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
#		MH_EXTRA_LIBS="-ll"
		SHLFILE="regina_dlo"
		SHL="a"
		AIX_DYN="yes"
		CURSESLIB="-lcurses"
		DYN_COMP="-DDYNAMIC"
		;;
	*ibm-aix4.3*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
#		MH_EXTRA_LIBS="-ll"
		SHLFILE="regina_dlo"
		SHL="a"
		AIX_DYN="yes"
		CURSESLIB="-lcurses"
		DYN_COMP="-DDYNAMIC"
		;;
	*ibm-aix*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
#		MH_EXTRA_LIBS="-ll"
		SHLFILE="regina_dlo"
		SHL="a"
		AIX_DYN="yes"
		CURSESLIB="-lcurses"
		DYN_COMP="-DDYNAMIC"
		;;
	*dec-osf*)
		SYS_DEFS="-D_POSIX_SOURCE -D_XOPEN_SOURCE -Olimit 800"
#		MH_EXTRA_LIBS="-ll -lm"
		CURSESLIB="-lcurses"
		;;
	*sequent-dynix*)
#		MH_EXTRA_LIBS="-ll -ldl"
		CURSESLIB="-lcurses"
		;;
	*solaris*)
#		MH_EXTRA_LIBS="-ll -ldl"
#		SHLIBS="-ldl"
		CURSESLIB="-L/usr/ccs/lib -lcurses"
		;;
	*esix*)
#		MH_EXTRA_LIBS="-ll -ldl"
		CURSESLIB="-lcurses"
		;;
	sparc*sunos*)
		SYS_DEFS="-DSUNOS -DSUNOS_STRTOD_BUG"
#		MH_EXTRA_LIBS="-ll -lm"
		CURSESINC="-I/usr/5include"
		CURSESLIB="-L/usr/5lib -lcurses -ltermcap"
		;;
	*linux*)
		SYS_DEFS="-ansi -D_POSIX_SOURCE"
#		MH_EXTRA_LIBS="-lm"
#		SHLIBS="-ldl"
		CURSESLIB="-lncurses"
		;;
esac

dnl
dnl set variables for compiling if we don't already have it
dnl
if test "$DYN_COMP" = ""; then
AC_MSG_CHECKING(compiler flags for a dynamic object)

cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int a=0
EOF

	DYN_COMP=""
	mh_cv_stop=no
	save_cflags="$CFLAGS"
	mh_cv_flags="-fPIC -KPIC +Z"
	for a in $mh_cv_flags; do
		CFLAGS="-c $a"

		mh_compile='${CC-cc} -c $CFLAGS conftest.$ac_ext > conftest.tmp 2>&1'
		if AC_TRY_EVAL(mh_compile); then
			DYN_COMP=""
		else
			slash="\\"
			mh_dyncomp="`egrep -c $slash$a conftest.tmp`"
			if test "$mh_dyncomp" = "0"; then
				DYN_COMP="$a -DDYNAMIC"
				AC_MSG_RESULT($a)
				break
			else
				DYN_COMP=""
			fi
		fi
	done
	if test "$DYN_COMP" = ""; then
		AC_MSG_RESULT(none of $mh_cv_flags supported)
	fi
	CFLAGS=$save_cflags
	rm -f conftest.*
fi


#if test "$ac_cv_prog_CC" = "gcc"; then
#	DYN_COMP="-fPIC -DDYNAMIC"
##	LIBS="-ll"
#else
#	case "$target" in
#		*hp-hpux*) 
#			DYN_COMP="+Z -DDYNAMIC"
#			;;
#		*ibm-aix4.2*)
#			DYN_COMP="-DDYNAMIC"
#			;;
#		*ibm-aix*)
#			DYN_COMP=""
#			;;
#		*dec-osf*)
#			DYN_COMP="-KPIC -DDYNAMIC"
#			CEXTRA="-std -Olimit 800"
#			;;
#		*sequent-dynix*)
#			;;
#		*esix*)
#			DYN_COMP="-KPIC -DDYNAMIC"
#			;;
#		*solaris*)
#			DYN_COMP="-KPIC -DDYNAMIC"
#			;;
#		sparc*sunos*)
#			;;
#		*linux*)
#			;;
#	esac
#fi

dnl
dnl set variables for linking
dnl
SHL_LD=""
TEST1EXPORTS=""
TEST2EXPORTS=""
CURSESEXPORTS=""
case "$target" in
	*hp-hpux*) 
		EEXTRA="-Wl,-E"
		LD_RXLIB1="ld -b -q -n"
		LD_RXLIB2=""
		SHL_LD="ld -b -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		;;
#	*ibm-aix4.2*)
#		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
#		LD_RXLIB1="ld -G"
#		LD_RXLIB2=""
#		SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" -shared -no_archive "'$('SHOFILES')'" -lc"
#		;;
	*ibm-aix3*)
		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
		LD_RXLIB1="ld -bnoentry -bM:SRE -bT:512 -bH:512 -bI:regina.exp"
		LD_RXLIB2="${LIBPRE}${LIBFILE}_dlo.${SHL} -lc"
		SHL_LD="ld -o ${LIBPRE}${LIBFILE}_dlo.${SHL} -bnoentry -bE:regina.exp -bM:SRE -bT:512 -bH:512 "'$('SHOFILES')'" -lc"
		CURSESEXPORTS="-bE:curses.exp"
		TEST1EXPORTS="-bE:test1.exp"
		TEST2EXPORTS="-bE:test2.exp"
		;;
	*ibm-aix4*)
		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
		LD_RXLIB1="ld -bnoentry -bM:SRE"
		LD_RXLIB2="${LIBPRE}${LIBFILE}_dlo.${SHL} -lc"
		SHL_LD="ld -o ${LIBPRE}${LIBFILE}_dlo.${SHL} -bnoentry -bE:regina.exp -bM:SRE "'$('SHOFILES')'" -lc "'$('SHLIBS')'
		CURSESEXPORTS="-bE:curses.exp"
		TEST1EXPORTS="-bE:test1.exp"
		TEST2EXPORTS="-bE:test2.exp"
		;;
	*dec-osf*)
		LD_RXLIB1="ld -shared"
		LD_RXLIB2="-lc -L. -l${LIBFILE}"
		SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" -shared -no_archive "'$('SHOFILES')'" -lc"
		;;
	*esix*)
		LD_RXLIB1="ld -G"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS=""
		SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		;;
	*solaris*)
		LD_RXLIB1="ld -G"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS=""
		SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		;;
	sparc*sunos*)
		LD_RXLIB1="ld"
		SHL_LD="ld -assert pure-text -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		;;
	*freebsd*)
		LD_RXLIB1="ld -Bdynamic -Bshareable"
		LD_RXLIB2="-lc -L. -l${LIBFILE}"
		SHL_LD="ld -Bdynamic -Bshareable -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'
		;;
	*linux*)
		LD_RXLIB1="ld -shared"
		LD_RXLIB2="-L. -l${LIBFILE}"
		SHL_LD="ld -shared -o ${LIBPRE}${LIBFILE}.${SHL}."'$('VERDOT')'" "'$('SHOFILES')'" -lc"
		;;
	*)
		MH_HOWTO_SHARED_LIBRARY()
		MH_HOWTO_DYN_LINK()
		;;
esac
if test "$AIX_DYN" = "yes"; then
	SHL1=""
	SHL2=""
	SHL3=""
	SHL4=""
else
	SHL1="rm -f ${LIBPRE}${SHLFILE}.${SHL}."'$('ABI')'
	SHL2="ln -s ${LIBPRE}${SHLFILE}.${SHL}."'$('VERDOT')'" ${LIBPRE}${SHLFILE}.${SHL}."'$('ABI')'
	SHL3="rm -f ${LIBPRE}${SHLFILE}.${SHL}"
	SHL4="ln -s ${LIBPRE}${SHLFILE}.${SHL}."'$('ABI')'" ${LIBPRE}${SHLFILE}.${SHL}"
fi
LIBFLAGS="cr ${LIBPRE}${LIBFILE}.${LIBPST}"
LIBLINK="-L. -l${LIBFILE}"
LINKSHL="${LIBPRE}${SHLFILE}.${SHL}"

if test "$ac_cv_header_dl_h" = "yes" -o "$ac_cv_header_dlfcn_h" = "yes" -o "$AIX_DYN" = "yes"; then
	SHL_TARGETS="regina${EXE} ${LIBPRE}${SHLFILE}.${SHL} test1.${RXLIB} test2.${RXLIB} curses.${RXLIB}"
else
	SHL_TARGETS=""
fi

AC_SUBST(SHL)
AC_SUBST(EEXTRA)
AC_SUBST(CEXTRA)
AC_SUBST(LIBPRE)
AC_SUBST(LIBFILE)
AC_SUBST(SHLFILE)
AC_SUBST(OSAVE)
AC_SUBST(OBJ)
AC_SUBST(EXE)
AC_SUBST(LIBPST)
AC_SUBST(LIBEXE)
AC_SUBST(LIBFLAGS)
AC_SUBST(LIBLINK)
AC_SUBST(LINKSHL)
AC_SUBST(RXLIB)
AC_SUBST(GETOPT)
AC_SUBST(SHL1)
AC_SUBST(SHL2)
AC_SUBST(SHL3)
AC_SUBST(SHL4)
AC_SUBST(OBJECTS)
AC_SUBST(DYN_COMP)
AC_SUBST(LIBS)
AC_SUBST(SHLIBS)
AC_SUBST(LD_RXLIB1)
AC_SUBST(LD_RXLIB2)
AC_SUBST(DYNAMIC_LDFLAGS)
AC_SUBST(STATIC_LDFLAGS)
AC_SUBST(SHL_LD)
AC_SUBST(SHL_TARGETS)
AC_SUBST(O2SAVE)
AC_SUBST(O2SHO)
AC_SUBST(CC2O)
AC_SUBST(SAVE2O)
AC_SUBST(CURSESLIB)
AC_SUBST(CURSESINC)
AC_SUBST(CURSESEXPORTS)
AC_SUBST(TEST1EXPORTS)
AC_SUBST(TEST2EXPORTS)
])dnl
