# Makefile for Applications:
#
# omniNames: COSS Naming Service
#
# utils:     - nameclt: Naming Service administrative tool.
#            - genior : Generate object reference.
#            - catior : List components of an object reference.
#
# Type NMAKE CFG="HELP" for help.

CONFIG_MAKEFILE=.\CONFIG.win32

!INCLUDE "$(CONFIG_MAKEFILE)"


!IF "$(CFG)" == ""
CFG=ALL
!ENDIF 

!IF "$(CFG)" != "omniNames" && "$(CFG)" != "utils"\
	 && "$(CFG)" != "ALL" && "$(CFG)" != "all"\
	 && "$(CFG)" != "catior" && "$(CFG)" != "genior"\
	 && "$(CFG)" != "nameclt"
!IF "$(CFG)" != "HELP"
!MESSAGE Invalid configuration "$(CFG)" specified.
!ENDIF
!MESSAGE You can specify a configuration when running NMAKE on this makefile
!MESSAGE by defining the macro CFG on the command line.  For example:
!MESSAGE 
!MESSAGE NMAKE /f "Applications.mak" CFG="omniNames"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "omniNames"        (COSS Naming Service)
!MESSAGE "utils"            (Utilities - nameclt, genior, and catior)
!MESSAGE 
!MESSAGE "ALL" (default)    (Makes all of the above)
!MESSAGE
!MESSAGE A build can be cleaned by specifying:
!MESSAGE
!MESSAGE NMAKE /f "Applications.mak" CLEAN CFG="<configuration>"
!MESSAGE
!ERROR Please specify one of the above configurations.
!ENDIF 

!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE 
NULL=nul
!ENDIF 


#Source directory for applications:

SRCDIR = $(SRCDIR)\appl
INCLUDE = $(INCLUDE);$(BASEDIR)\src\appl\omniNames

################################################################################
# Begin Project

!IF "$(CFG)" == "ALL" || "$(CFG)" == "all"

ALL : 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CFG="omniNames" 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CFG="utils" 


CLEAN:
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CLEAN CFG="omniNames" 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CLEAN CFG="utils" 

!ELSEIF "$(CFG)" == "utils"
	

ALL : "$(BASEDIR)\appl" "$(BASEDIR)\appl\utils"
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CFG="catior" 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CFG="genior" 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CFG="nameclt" 


CLEAN:
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CLEAN CFG="catior" 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CLEAN CFG="genior" 
	$(MAKE) /$(MAKEFLAGS) /F "Applications.mak" CLEAN CFG="nameclt"


"$(BASEDIR)\appl":
	if not exist "$(BASEDIR)\appl/$(NULL)" mkdir "$(BASEDIR)\appl"

"$(BASEDIR)\appl\utils":
	if not exist "$(BASEDIR)\appl\utils/$(NULL)" mkdir "$(BASEDIR)\appl\utils"


!ELSEIF  "$(CFG)" == "omniNames"

OUTDIR=$(BASEDIR)\appl\omniNames
INTDIR=$(BASEDIR)\appl\omniNames

ALL : "$(BASEDIR)\appl" "$(OUTDIR)\omniNames.exe"

CLEAN : 
	-@erase "$(INTDIR)\log.obj"
	-@erase "$(INTDIR)\NamingContext_i.obj"
	-@erase "$(INTDIR)\omniNames.obj"
	-@erase "$(OUTDIR)\omniNames.exe"

"$(BASEDIR)\appl":
	if not exist "$(BASEDIR)\appl/$(NULL)" mkdir "$(BASEDIR)\appl"
"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /D "DEFAULT_LOGDIR=$(OMNINAMES_LOG_DEFAULT_LOCATION)" \
 /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\appl\omniNames/

LINK32_FLAGS=kernel32.lib user32.lib wsock32.lib advapi32.lib omniORB2_rt.lib\
 omnithread_rt.lib /nologo /subsystem:console /pdb:none /machine:I386\
 /out:"$(OUTDIR)/omniNames.exe" 
LINK32_OBJS= \
	"$(INTDIR)\log.obj" \
	"$(INTDIR)\NamingContext_i.obj" \
	"$(INTDIR)\omniNames.obj"

"$(OUTDIR)\omniNames.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "genior"

OUTDIR=$(BASEDIR)\appl\utils\genior
INTDIR=$(BASEDIR)\appl\utils\genior

ALL : "$(OUTDIR)\genior.exe"

CLEAN : 
	-@erase "$(INTDIR)\genior.obj"
	-@erase "$(OUTDIR)\genior.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\appl\utils\genior/

LINK32_FLAGS=kernel32.lib user32.lib wsock32.lib advapi32.lib omniORB2_rt.lib\
 omnithread_rt.lib /nologo /subsystem:console /pdb:none /machine:I386\
 /out:"$(OUTDIR)/genior.exe" 
LINK32_OBJS= \
	"$(INTDIR)\genior.obj"

"$(OUTDIR)\genior.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "catior"

OUTDIR=$(BASEDIR)\appl\utils\catior
INTDIR=$(BASEDIR)\appl\utils\catior

ALL : "$(OUTDIR)\catior.exe"

CLEAN : 
	-@erase "$(INTDIR)\catior.obj"
	-@erase "$(OUTDIR)\catior.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\appl\utils\catior/

LINK32_FLAGS=kernel32.lib user32.lib wsock32.lib advapi32.lib omniORB2_rt.lib\
 omnithread_rt.lib /nologo /subsystem:console /pdb:none /machine:I386\
 /out:"$(OUTDIR)/catior.exe" 
LINK32_OBJS= \
	"$(INTDIR)\catior.obj"

"$(OUTDIR)\catior.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ELSEIF  "$(CFG)" == "nameclt"

OUTDIR=$(BASEDIR)\appl\utils\nameclt
INTDIR=$(BASEDIR)\appl\utils\nameclt

ALL : "$(OUTDIR)\nameclt.exe"

CLEAN : 
	-@erase "$(INTDIR)\nameclt.obj"
	-@erase "$(OUTDIR)\nameclt.exe"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MD /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /D\
 "__NT__" /D "_X86_" /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\appl\utils\nameclt/

LINK32_FLAGS=kernel32.lib user32.lib wsock32.lib advapi32.lib omniORB2_rt.lib\
 omnithread_rt.lib /nologo /subsystem:console /pdb:none /machine:I386\
 /out:"$(OUTDIR)/nameclt.exe" 
LINK32_OBJS= \
	"$(INTDIR)\nameclt.obj"

"$(OUTDIR)\nameclt.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

!ENDIF 

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $<

################################################################################
# Begin Target

# Name "omniNames"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniNames\NamingContext_i.cc
DEP_CPP_NAMIN=\
	"$(SRCDIR)\omniNames\BindingIterator_i.h"\
	"$(SRCDIR)\omniNames\log.h"\
	"$(SRCDIR)\omniNames\NamingContext_i.h"\
	"$(SRCDIR)\omniNames\ObjectBinding.h"\
	"$(SRCDIR)\omniNames\ReadersWritersLock.h"\
	

"$(INTDIR)\NamingContext_i.obj" : $(SOURCE) $(DEP_CPP_NAMIN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniNames\log.cc
DEP_CPP_LOG_C=\
	"$(SRCDIR)\omniNames\log.h"\
	"$(SRCDIR)\omniNames\NamingContext_i.h"\
	"$(SRCDIR)\omniNames\ObjectBinding.h"\
	"$(SRCDIR)\omniNames\ReadersWritersLock.h"\
	{$(INCLUDE)}"\sys\stat.h"\
	{$(INCLUDE)}"\sys\types.h"\
	

"$(INTDIR)\log.obj" : $(SOURCE) $(DEP_CPP_LOG_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniNames\omniNames.cc
DEP_CPP_OMNIN=\
	"$(SRCDIR)\omniNames\log.h"\
	"$(SRCDIR)\omniNames\NamingContext_i.h"\
	"$(SRCDIR)\omniNames\ReadersWritersLock.h"\	

"$(INTDIR)\omniNames.obj" : $(SOURCE) $(DEP_CPP_OMNIN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "genior - Win32 Release"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\utils\genior\genior.cc

!IF  "$(CFG)" == "genior"


"$(INTDIR)\genior.obj" : $(SOURCE) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


!ENDIF 

# End Source File
# End Target
################################################################################
# Begin Target

# Name "catior - Win32 Release"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\utils\catior\catior.cc

!IF  "$(CFG)" == "catior"

"$(INTDIR)\catior.obj" : $(SOURCE) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


!ENDIF 

# End Source File
# End Target
################################################################################
# Begin Target

# Name "nameclt - Win32 Release"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\utils\nameclt\nameclt.cc

!IF  "$(CFG)" == "nameclt"

"$(INTDIR)\nameclt.obj" : $(SOURCE) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


!ENDIF 

# End Source File
# End Target
# End Project
################################################################################
