#ifndef GTKMM_SIGSLOT
#define GTKMM_SIGSLOT

#include <gtk--sigcommon.h>
#include <gtk--sigconn.h>

template <class rettype, class T>
class Slot : public Connection_impl
{
private:
  T* obj;
  rettype (T::*method)();
public:
  Slot(T* obj_,rettype (T::*method_)()) : obj(obj_),method(method_) {}
  rettype call() {VR_RETURN (obj->*method)();}
  static gint callback(GtkWidget*,Slot<rettype,T>* s) {s->call(); return 0; }	
};

template <class rettype, class T,class E>
class Slotcb : public Connection_impl
{
private:
  T* obj;
  rettype (T::*method)(E);
  E cbdata;
public:
  Slotcb(T* obj_,rettype (T::*method_)(E),E e) : obj(obj_),method(method_),cbdata(e) {}
  rettype call() { VR_RETURN (obj->*method)(cbdata);}
  static gint callback(GtkWidget*,Slotcb<rettype,T,E>* s) {s->call(); return 0; }	
};


// -------------------------- 1-5 args ----------------------------------
//         This is a scaleable #define, a technique blatently nicked
//                  from Tero's implementation (Cheers Tero)
#define CALLBACK_IMPL(SLOTNAME, T_CLASS_ARGS,ARG_TYPES,F_ARG_NAMES,F_ARG_BOTH,CB_ARG_TYPES,CB_ARG_BOTH,CB_CONSTRUCTOR,CB_VAR_DECL,CB_ARG_NAMES,CB_T_TYPE,CB_T_ARG)\
\
template <class rettype,class T, T_CLASS_ARGS> \
class SLOTNAME : public Connection_impl \
{ \
  private: \
	T* obj; \
	rettype (T::*method)(ARG_TYPES CB_ARG_TYPES); \
	CB_VAR_DECL\
  public:\
	SLOTNAME(T* obj_,rettype (T::*method_)(ARG_TYPES CB_ARG_TYPES) CB_ARG_BOTH): obj(obj_),method(method_) CB_CONSTRUCTOR {}\
	rettype call(F_ARG_BOTH) \
		{VR_RETURN (obj->*method)(F_ARG_NAMES CB_ARG_NAMES);}\
	static rettype callback(GtkWidget*,F_ARG_BOTH,SLOTNAME<rettype,T,ARG_TYPES CB_T_TYPE>* s) \
		{VR_RETURN (s->call(F_ARG_NAMES));}	\
}; \

#ifdef HAVE_PARTIAL_SPECIALIZATION
#define CALLBACK_IMPL1(SLOTNAME, T_CLASS_ARGS,ARG_TYPES,F_ARG_NAMES,F_ARG_BOTH,CB_ARG_TYPES,CB_ARG_BOTH,CB_CONSTRUCTOR,CB_VAR_DECL,CB_ARG_NAMES,CB_T_TYPE,CB_T_ARG)\
template <class T, T_CLASS_ARGS> \
class SLOTNAME<void,T,T_CLASS_ARGS> : public Connection_impl \
{ \
  private: \
	T* obj; \
	void (T::*method)(ARG_TYPES CB_ARG_TYPES); \
	CB_VAR_DECL\
  public:\
	SLOTNAME(T* obj_,void (T::*method_)(ARG_TYPES CB_ARG_TYPES) CB_ARG_BOTH): obj(obj_),method(method_) CB_CONSTRUCTOR {}\
	void call(F_ARG_BOTH) \
		{ (obj->*method)(F_ARG_NAMES CB_ARG_NAMES);}\
	static void callback(GtkWidget*,F_ARG_BOTH,SLOTNAME<void,T,ARG_TYPES CB_T_TYPE>* s) \
		{ (s->call(F_ARG_NAMES));}	\
}; 


#else
#define CALLBACK_IMPL1(SLOTNAME, T_CLASS_ARGS,ARG_TYPES,F_ARG_NAMES,F_ARG_BOTH,CB_ARG_TYPES,CB_ARG_BOTH,CB_CONSTRUCTOR,CB_VAR_DECL,CB_ARG_NAMES,CB_T_TYPE,CB_T_ARG)
#endif



#define COMMA ,

//one arg
CALLBACK_IMPL(Slot1, class Arg1, Arg1, a1, Arg1 a1,,,,,,,)

CALLBACK_IMPL(Slot1cb, class Arg1 COMMA class E, Arg1, a1, Arg1 a1,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)



//two args
CALLBACK_IMPL(Slot2, class Arg1 COMMA class Arg2,
			  Arg1 COMMA Arg2,
			  a1 COMMA a2,
			  Arg1 a1 COMMA Arg2 a2,,,,,,,)

CALLBACK_IMPL(Slot2cb, class Arg1 COMMA class Arg2 COMMA class E,
			  Arg1 COMMA Arg2,
			  a1 COMMA a2,
			  Arg1 a1 COMMA Arg2 a2,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)
	     


//three args
CALLBACK_IMPL(Slot3, class Arg1 COMMA class Arg2 COMMA class Arg3,
			  Arg1 COMMA Arg2 COMMA Arg3,
			  a1 COMMA a2 COMMA a3,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3,,,,,,,)

CALLBACK_IMPL(Slot3cb, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class E,
	      Arg1 COMMA Arg2 COMMA Arg3,
	      a1 COMMA a2 COMMA a3,
	      Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)

//four args
CALLBACK_IMPL(Slot4, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4,
			  Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4,
			  a1 COMMA a2 COMMA a3 COMMA a4,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4,,,,,,,)

CALLBACK_IMPL(Slot4cb, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4 COMMA class E,
			  Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4,
			  a1 COMMA a2 COMMA a3 COMMA a4,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)

//five args
CALLBACK_IMPL(Slot5, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4
              COMMA class Arg5,
			  Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4 COMMA Arg5,
			  a1 COMMA a2 COMMA a3 COMMA a4 COMMA a5,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4 COMMA Arg5 a5,,,,,,,)

CALLBACK_IMPL(Slot5cb, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4
              COMMA class Arg5 COMMA class E,
	      Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4 COMMA Arg5,
	      a1 COMMA a2 COMMA a3 COMMA a4 COMMA a5,
	      Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4 COMMA Arg5 a5,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)

//------------------------------------------------
//one arg
CALLBACK_IMPL1(Slot1, class Arg1, Arg1, a1, Arg1 a1,,,,,,,)

CALLBACK_IMPL1(Slot1cb, class Arg1 COMMA class E, Arg1, a1, Arg1 a1,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)



//two args
CALLBACK_IMPL1(Slot2, class Arg1 COMMA class Arg2,
			  Arg1 COMMA Arg2,
			  a1 COMMA a2,
			  Arg1 a1 COMMA Arg2 a2,,,,,,,)

CALLBACK_IMPL1(Slot2cb, class Arg1 COMMA class Arg2 COMMA class E,
			  Arg1 COMMA Arg2,
			  a1 COMMA a2,
			  Arg1 a1 COMMA Arg2 a2,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)
	     


//three args
CALLBACK_IMPL1(Slot3, class Arg1 COMMA class Arg2 COMMA class Arg3,
			  Arg1 COMMA Arg2 COMMA Arg3,
			  a1 COMMA a2 COMMA a3,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3,,,,,,,)

CALLBACK_IMPL1(Slot3cb, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class E,
	      Arg1 COMMA Arg2 COMMA Arg3,
	      a1 COMMA a2 COMMA a3,
	      Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)

//four args
CALLBACK_IMPL1(Slot4, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4,
			  Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4,
			  a1 COMMA a2 COMMA a3 COMMA a4,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4,,,,,,,)

CALLBACK_IMPL1(Slot4cb, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4 COMMA class E,
			  Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4,
			  a1 COMMA a2 COMMA a3 COMMA a4,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)

//five args
CALLBACK_IMPL1(Slot5, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4
              COMMA class Arg5,
			  Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4 COMMA Arg5,
			  a1 COMMA a2 COMMA a3 COMMA a4 COMMA a5,
			  Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4 COMMA Arg5 a5,,,,,,,)

CALLBACK_IMPL1(Slot5cb, class Arg1 COMMA class Arg2 COMMA class Arg3 COMMA class Arg4
              COMMA class Arg5 COMMA class E,
	      Arg1 COMMA Arg2 COMMA Arg3 COMMA Arg4 COMMA Arg5,
	      a1 COMMA a2 COMMA a3 COMMA a4 COMMA a5,
	      Arg1 a1 COMMA Arg2 a2 COMMA Arg3 a3 COMMA Arg4 a4 COMMA Arg5 a5,
	      COMMA E,COMMA E e,COMMA cbdata(e),E cbdata;,COMMA cb_data,COMMA E,COMMA e)


#endif
