#include <sys/types.h>
#include <sys/stat.h>

#define MAXMSG 2048
#define MAXPATH 1500
#define FAKE_PROJ 'C'
#define FAKEROOTKEY_ENV "FAKEROOTKEY"
#define LDD_BINARY "/usr/bin/ldd"

typedef  enum {chown_func, fchown_func, 
	/*2*/  chmod_func, fchmod_func,
	/*4*/  mknod_func, 
	       stat_func,
	/*6*/  unlink_func, 
	/*7*/  checklibc_func, 
	       debian_pedantic_func,
	       debug_func, debugdata_func,
	       last_func} func_id;

/*any *_param struct that is used for question/answer communications
  with the daemon must have this structure as first element */

struct q_and_a_serial{
  pid_t pid;
  int   serial;
};

struct q_and_a_func_id{
  func_id id;
  pid_t pid;
  int   serial;
};

struct my_msgbuf{
  long mtype;
  char mtext[MAXMSG];
};

struct chown_param{
  uid_t owner;
  gid_t group;
  struct stat st;
};
struct fchown_param{
  uid_t owner;
  gid_t group;
  struct stat st;
};

struct chmod_param{
  mode_t mode;
  struct stat st;
};
struct fchmod_param{
  mode_t mode;
  struct stat st;
};

struct mknod_param{
  mode_t mode;
  dev_t  dev;
  struct stat st;
};

struct stat_param{
  struct stat st;
};

struct unlink_param{
  struct stat st;  
};

struct checklibc_param{
  int check;
  char path[MAXPATH];
};

struct debianpedantic_param{
  int debian;
};
struct debug_param{
  int  pid;
  char msg[MAXPATH];
};

extern void  fakeroot_debug();


/* this function is both defined in the header file, as
   that was the easiest: it needs to be defined in both
   the lib and the fakeroot main programme */
void *get_par(struct my_msgbuf *buf){
  return (void *) ((char *)buf->mtext+sizeof(struct q_and_a_func_id));
};

