/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: ecommand.h,v $
 *
 * $Revision: 1.1 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *  Some things to remember:
 *  
 *  - Only add a command to the combo-list when successfull
 *  - Try to be shell independent 
 *  - Do not forget to covert the string to upper case 
 *
 *
 */

#ifndef __ECOMMAND_H__
#define __ECOMMAND_H__

#include <qcombo.h>
#include <qlined.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

class ECommandClass : public QComboBox
{

     Q_OBJECT

  public:
  
     ECommandClass (QWidget *,const char *);

     ~ECommandClass ()
     {
     
     }   
     
  private:

     char **tokens;
    
     int create_tokens (int);
     
  public slots:
  
     void interpret (int);     
     
  signals:
  
     // below are the signals the parser is able to generate

     void c_exit       ();     
     void c_select     (char *);
     void c_select_inv ();
     
     void c_copy       (char *);
     void c_move       (char *);
     void c_delete     (char *);
     
     void c_cd         (char *);
     
     void c_find       (char *);
     
     void c_mount      (char *);
     void c_umount     (char *);
};


#endif // __ECOMMAND_H__
