#ifndef _RVS_QT_CPD_H_
#define _RVS_QT_CPD_H_
/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: cpdlg.h,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: cpdlg.h,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 */



 
#include <qwidget.h>
#include <qlabel.h>
#include <qfile.h>
#include <qdialog.h>
#include <qstrlist.h>
class QTimer;
class QProgressCtrl;
class QString;
class QStrList;
class CopyProgressWidget;
class QPushButton;

class CopyProgressDlg: public QDialog
{
	Q_OBJECT
	
	friend class CopyProgressWidget;

	QTimer * spTimer;
	QStrList *szSources,
	       *szDestinations;
	QStrListIterator *Sources,
	       *Destinations;
	CopyProgressWidget *widget;

	int iOpmode;
	bool bRecursive;

	private slots:

	void    tryStart();
	void    doStuff();
	void	shutdowndlg();	

	public:

	enum ops {Copy, CopyAs, Move, MoveAs, Delete};

	CopyProgressDlg(const QStrList & szSources_arg, const QString & szDestination_arg, int opmode=Copy, bool bRecursive_arg=false, QWidget * parent = 0, const char *name = 0);
	~CopyProgressDlg();

};

class CopyProgressWidget: public QLabel
{
	Q_OBJECT

	QFile	in, 
			out;

	QTimer			*spTimer;
	QProgressCtrl	*spProgress;
	QLabel 			*spBusyText;
	QPushButton *spAbortButton;
	
	QString	szInname,
			szOutname;
	
	unsigned int uiMyBuffersize;
	char *cBuffer;
	bool bBusy;
	
	void setup_gui();

	public:

	CopyProgressWidget(QWidget *parent=0, const char *name=0);

	QString getSource();
	QString getDestination();

	int setBuffersize(unsigned int uiBuffersize);

	
	public slots:
	
	void abort();
	void start();
	void setSource(const char* szSource);
	void setDestination(const char*szDestination);
	
	private slots:
	
	void ch_abort_to_close_me(int);
	void do_close_me_please();
	void copyfile();
	
	signals:
	
	void completed();
	void failed(int);
	void quit_me();
	void sourceChanged(const char *);
	void destinationChanged(const char *);
};
#endif // _RVS_QT_CPD_H_
