/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "globals.pas" */


#include "cfuncs.h"


#define GLOBALS_G
#include "globals.h"


short verbose = 0;
boolean ignore = false, dochords = true, dotext = true, dolyrics = true,
	musixlyr = true, split_dots = false, set_names = false,
	unbeam_if_vocal = true, extended_dots = false;

boolean bind_left[18] = {
  false, false, true, false, true, true, false, true, true, false, true,
  false, true, true, false, false, false, false
};

char name[18][9] = {
  "?", "note", "znote", "(", ")", ")(", "[", "]", "PMX<", "meter", "ornament",
  "rest", "//", "BAR", "TeX", "@", "FirstOnly", "ERROR"
};

#ifndef STRINGS_H

#endif


void onumber(char *s, short *j, short *n1)
{
  if (s[*j - 1] == 'o')
    *n1 = 1;
  else if (s[*j - 1] == '1') {
    *n1 = digit(s[*j]) + 10;
    (*j)++;
  } else
    *n1 = digit(s[*j - 1]);
  (*j)++;
}


void stripblanks(char *s)
{
  short k;

  k = posnot(blank, s);
  if (k > 1)
    predelete(s, k - 1);
  else if (k == 0)
    *s = '\0';
}


void fatalerror(char *message)
{
  ignore = false;
  error(message);
}


void error(char *message)
{
  printf("%s: ERROR on line %d\n", message, line_no);
  exit_code++;
  if (ignore)
    return;
  if (outfile != NULL)
    fclose(outfile);
  outfile = NULL;
  outfile = fopen(outfile_NAME, "w");
  if (outfile == NULL)
    _EscIO2(FileNotFound, outfile_NAME);
  fclose(outfile);
  outfile = NULL;
  _Escape(exit_code);
}


void error3(short voice, char *message)
{
  char STR2[256];

  printf("In voice \"%s\" near word %d:\n",
	 voice_label[voice-1], info[voice-1].here);
  sprintf(STR2, "   %s", message);
  error(STR2);
}


void warning(char *message)
{
  printf("%s: WARNING on line %d\n", message, line_no);
}


short word_count(char *s)
{
  short i, n, FORLIM;

  if (*s == '\0')
    return 0;
  if (s[0] == blank)
    n = 0;
  else
    n = 1;
  FORLIM = strlen(s);
  for (i = 1; i <= FORLIM - 1; i++) {
    if (s[i-1] == blank && s[i] != blank)
      n++;
  }
  return n;
}


char *GetNextWord(char *Result, char *s, char Delim, char Term)
{
  /* A delimiter is a character that separates words, but forms no part
     of them.  A terminator is a character that appears at the end of
     a word. */
  short n = 1;
  short start, last;

  last = strlen(s);
  while (n <= last && s[n-1] == Delim)
    n++;
  start = n;
  while (n <= last && s[n-1] != Term && s[n-1] != Delim)
    n++;
  if (n <= last && s[n-1] == Term)
    n++;
  substr_(Result, s, start, n - start);
  while (n <= last && s[n-1] == Delim)
    n++;
  predelete(s, n - 1);
  return Result;
}


char *NextWord(char *Result, char *s_, char Delim, char Term)
{
  char s[256];

  strcpy(s, s_);
  return (GetNextWord(Result, s, Delim, Term));
}


char *plural(char *Result, short n)
{
  if (n == 1)
    return strcpy(Result, "");
  else
    return strcpy(Result, "s");
}


short curtail(char *s, char c)
{
  short Result = 0;
  short l;

  l = strlen(s);
  if (s[l-1] == c) {
    shorten(s, l - 1);
    return l;
  }
  return Result;
}


char *strnum(char *Result, short n)
{
  char s[256];

  sprintf(s, "%d", n);
  return strcpy(Result, s);
}


short digit(char c)
{
  return (c - '0');
}


short instrument(short voice)
{
  return (ninstr - info[voice-1].voice_stave + 1);
}




/* End. */
