//
// /home/ms/sidplay/qtsidplay/RCS/rcfile.cpp,v
//

#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>

#include <qdir.h>
#include <qfiledlg.h>
#include <qstring.h>

#include "MainDialog.h"
#include "GlobalExt.h"
#include "textfile.h"

#include "xsidplay.h"
#include "mytypes.h"
#include "emucfg.h"

extern uword voiceMasterVol[4];

struct voiceVol { uword l, r; };  // as used in mixerwin
extern voiceVol voiceHQvol[4];
extern voiceVol voiceFPvol[4];

QDir* hvscPath;
bool stilInfoDesired = true;

// --------------------------------------------------------------------------
// CONFIGURATION FILE EVALUATION
// --------------------------------------------------------------------------

extern bufferConfig myBufferConfig;
extern bufferConfig bakBufferConfig;
extern udword usage;

static QString configPath;
static const QString configFile = ".sidplayrc";

static void catConfigFilePath()
{
	const char* homeDir = getenv("HOME");
	if (homeDir != 0)
    {
		configPath = homeDir;
    }
	else
	{
		configPath = "/var/tmp";
	}
	configPath += "/";
	configPath += configFile;
#ifdef WB_DEBUG
	cout << configPath << endl;
#endif
}

// Keywords.
static const char keyword_Frequency[] = "Frequency=";
static const char keyword_Channels[] = "Channels=";
static const char keyword_BitsPerSample[] = "BitsPerSample=";
static const char keyword_Fragments[] = "Fragments=";
static const char keyword_FragmentSize[] = "FragmentSize=";
static const char keyword_BufferSize[] = "BufferSize=";

static const char keyword_ForceSongSpeed[] = "ForceSongSpeed=";
static const char keyword_ClockSpeed[] = "ClockSpeed=";
static const char keyword_MemoryMode[] = "MemoryMode=";
static const char keyword_MOS8580[] = "MOS8580=";
static const char keyword_MeasuredMasterVolume[] = "MeasuredMasterVolume=";
static const char keyword_UseFilter[] = "UseFilter=";
static const char keyword_FilterFs[] = "FilterFs=";
static const char keyword_FilterFm[] = "FilterFm=";
static const char keyword_FilterFt[] = "FilterFt=";

static const char keyword_Mixer[] = "Mixer=";
static const char keyword_AutoPanning[] = "AutoPanning=";
static const char keyword_Voice1Vol[] = "Voice1Vol=";
static const char keyword_Voice2Vol[] = "Voice2Vol=";
static const char keyword_Voice3Vol[] = "Voice3Vol=";
static const char keyword_Voice4Vol[] = "Voice4Vol=";
static const char keyword_PanPosLeftHQ[] = "PanPosLeftHQ=";
static const char keyword_PanPosRightHQ[] = "PanPosRightHQ=";
static const char keyword_PanPosLeftFP[] = "PanPosLeftFP=";
static const char keyword_PanPosRightFP[] = "PanPosRightFP=";

static const char keyword_Yes[] = "Yes";
static const char keyword_No[] = "No";
static const char keyword_PAL[] = "PAL";
static const char keyword_NTSC[] = "NTSC";
static const char keyword_FullBankSwitching[] = "FullBankSwitching";
static const char keyword_TransparentROM[] = "TransparentROM";
static const char keyword_PlaySID[] = "PlaySID";
static const char keyword_Normal[] = "Normal";
static const char keyword_Centered[] = "Centered";
static const char keyword_StereoSurround[] = "StereoSurround";
static const char keyword_HQ[] = "HighQuality";
static const char keyword_FP[] = "FullPanning";

static const char keyword_Usage[] = "Usage=";

static const char keyword_Directory[] = "Directory=";
static const char keyword_NameFilter[] = "NameFilter=";
static const char keyword_HVSCroot[] = "HVSCroot=";

static const char keyword_MainPosX[] = "MainPosX=";
static const char keyword_MainPosY[] = "MainPosY=";
static const char keyword_DirPosX[] = "DirPosX=";
static const char keyword_DirPosY[] = "DirPosY=";
static const char keyword_DirExtX[] = "DirExtX=";
static const char keyword_DirExtY[] = "DirExtY=";
static const char keyword_DirOpen[] = "DirOpen=";
static const char keyword_StilOpen[] = "StilOpen=";

extern MainDialog* myMainDlg;
extern QFileDialog* myFileDlg;

// -------------------------------------------------------------------- Input

void readMergedPanPosLeft(voiceVol panLevels[4], udword allPanPosLeft)
{
	panLevels[0].l = (allPanPosLeft>>24)&255;
	panLevels[1].l = (allPanPosLeft>>16)&255;
	panLevels[2].l = (allPanPosLeft>>8)&255;
	panLevels[3].l = allPanPosLeft&255;
}

void readMergedPanPosRight(voiceVol panLevels[4], udword allPanPosRight)
{
	panLevels[0].r = (allPanPosRight>>24)&255;
	panLevels[1].r = (allPanPosRight>>16)&255;
	panLevels[2].r = (allPanPosRight>>8)&255;
	panLevels[3].r = allPanPosRight&255;
}

void readConfigFile()
{
	catConfigFilePath();
	textFile myTxt(configPath);
	while ( myTxt && !myTxt.endOfFile() )
    {
		myTxt.readNextLine();
		// Skip blank and comment lines.
		while ( myTxt && !myTxt.endOfFile() && (myTxt.isBlank() || myTxt.isComment()) )
		{
			myTxt.readNextLine();
		};
		// Evaluate line.
#ifdef WB_DEBUG
		cout << "Line " << myTxt.retLineNum() << ", " << myTxt.retLineLen() << ": ";
		cout << myTxt.retLineBuf() << endl;
		cout << "ParseBuf: " << myTxt.retParseBuf() << endl;
#endif
		// Audio settings.
		if (myTxt.isKeyword(keyword_Frequency))
			myEmuConfig.frequency = (udword)atol(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_Channels))
		{
			int channels = atoi(myTxt.retCurParseBuf());
			(channels == 1) ? (myEmuConfig.channels = SIDEMU_MONO)
				: (myEmuConfig.channels = SIDEMU_STEREO);
		}
		else if (myTxt.isKeyword(keyword_BitsPerSample))
		{
			int bitsPerSample = atoi(myTxt.retCurParseBuf());
			(bitsPerSample == 8) ? (myEmuConfig.bitsPerSample = SIDEMU_8BIT)
				: (myEmuConfig.bitsPerSample = SIDEMU_16BIT);
		}
		else if (myTxt.isKeyword(keyword_Fragments))
		{
			int frag = (uword)atoi(myTxt.retCurParseBuf());
			if (frag < 2)
				frag = 2;
			myBufferConfig.fragments = frag;
		}
		else if (myTxt.isKeyword(keyword_FragmentSize))
		{
			udword size = atol(myTxt.retCurParseBuf());
			int fragExp = 0;
			while (size > 1)
			{
				size >>= 1;
				fragExp++;
			};
			if (fragExp < 7)
				fragExp = 7;
			myBufferConfig.fragSizeExp = fragExp;
		}
		else if (myTxt.isKeyword(keyword_BufferSize))
		{
			int bufSize = atoi(myTxt.retCurParseBuf());
			if (bufSize < 256)
				bufSize = 256;
			myBufferConfig.bufferSize = bufSize;
		}
		
		// Emulator settings.
		else if (myTxt.isKeyword(keyword_ClockSpeed))
		{
			if (myTxt.isAgainKeyword(keyword_PAL))
				myEmuConfig.clockSpeed = SIDTUNE_CLOCK_PAL;
			else
				myEmuConfig.clockSpeed = SIDTUNE_CLOCK_NTSC;
		}
		else if (myTxt.isKeyword(keyword_ForceSongSpeed))
			myEmuConfig.forceSongSpeed = myTxt.isAgainKeyword(keyword_Yes);
		else if (myTxt.isKeyword(keyword_MemoryMode))
		{
			if (myTxt.isAgainKeyword(keyword_FullBankSwitching))
				myEmuConfig.memoryMode = MPU_BANK_SWITCHING;
			else if (myTxt.isAgainKeyword(keyword_TransparentROM))
				myEmuConfig.memoryMode = MPU_TRANSPARENT_ROM;
			else
				myEmuConfig.memoryMode = MPU_PLAYSID_ENVIRONMENT;
		}
		else if (myTxt.isKeyword(keyword_MOS8580))
			myEmuConfig.mos8580 = myTxt.isAgainKeyword(keyword_Yes);
		else if (myTxt.isKeyword(keyword_MeasuredMasterVolume))
			myEmuConfig.measuredVolume = myTxt.isAgainKeyword(keyword_Yes);
		
		// Filter settings.
		else if (myTxt.isKeyword(keyword_UseFilter))
			myEmuConfig.emulateFilter = myTxt.isAgainKeyword(keyword_Yes);
		else if (myTxt.isKeyword(keyword_FilterFs))
			myEmuConfig.filterFs = atof(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_FilterFm))
			myEmuConfig.filterFm = atof(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_FilterFt))
			myEmuConfig.filterFt = atof(myTxt.retCurParseBuf());
		
		// Mixer settings.
		else if (myTxt.isKeyword(keyword_Mixer))
		{
			if (myTxt.isAgainKeyword(keyword_HQ))
				myEmuConfig.volumeControl = SIDEMU_VOLCONTROL;
			else if (myTxt.isAgainKeyword(keyword_FP))
				myEmuConfig.volumeControl = SIDEMU_FULLPANNING;
			else if (myTxt.isAgainKeyword(keyword_StereoSurround))
				myEmuConfig.volumeControl = SIDEMU_STEREOSURROUND;
			else
				myEmuConfig.volumeControl = SIDEMU_NONE;
		}
		else if (myTxt.isKeyword(keyword_AutoPanning))
		{
			if (myTxt.isAgainKeyword(keyword_Centered))
				myEmuConfig.autoPanning = SIDEMU_CENTEREDAUTOPANNING;
			else
				myEmuConfig.autoPanning = SIDEMU_NONE;
		}
		else if (myTxt.isKeyword(keyword_Voice1Vol))
			voiceMasterVol[0] = atoi(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_Voice2Vol))
			voiceMasterVol[1] = atoi(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_Voice3Vol))
			voiceMasterVol[2] = atoi(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_Voice4Vol))
			voiceMasterVol[3] = atoi(myTxt.retCurParseBuf());
		
		else if (myTxt.isKeyword(keyword_PanPosLeftHQ))
			readMergedPanPosLeft(voiceHQvol,atol(myTxt.retCurParseBuf()));
		else if (myTxt.isKeyword(keyword_PanPosRightHQ))
			readMergedPanPosRight(voiceHQvol,atol(myTxt.retCurParseBuf()));
		else if (myTxt.isKeyword(keyword_PanPosLeftFP))
			readMergedPanPosLeft(voiceFPvol,atol(myTxt.retCurParseBuf()));
		else if (myTxt.isKeyword(keyword_PanPosRightFP))
			readMergedPanPosRight(voiceFPvol,atol(myTxt.retCurParseBuf()));

		// Listening mileage.
		else if (myTxt.isKeyword(keyword_Usage))
			usage = (udword)atol(myTxt.retCurParseBuf());
		
		// Window geometries.
		// Main dialog.
		else if (myTxt.isKeyword(keyword_MainPosX))
			myMainDlg->setGeometry(atoi(myTxt.retCurParseBuf()),myMainDlg->y(),
								   myMainDlg->width(),myMainDlg->height());
		else if (myTxt.isKeyword(keyword_MainPosY))
			myMainDlg->setGeometry(myMainDlg->x(),atoi(myTxt.retCurParseBuf()),
								   myMainDlg->width(),myMainDlg->height());
		// File dialog.
		else if (myTxt.isKeyword(keyword_DirPosX))
			myFileDlg->setGeometry(atoi(myTxt.retCurParseBuf()),myFileDlg->y(),
								   myFileDlg->width(),myFileDlg->height());
		else if (myTxt.isKeyword(keyword_DirPosY))
			myFileDlg->setGeometry(myFileDlg->x(),atoi(myTxt.retCurParseBuf()),
								   myFileDlg->width(),myFileDlg->height());
		else if (myTxt.isKeyword(keyword_DirExtX))
			myFileDlg->setGeometry(myFileDlg->x(),myFileDlg->y(),
								   atoi(myTxt.retCurParseBuf()),myFileDlg->height());
		else if (myTxt.isKeyword(keyword_DirExtY))
			myFileDlg->setGeometry(myFileDlg->x(),myFileDlg->y(),
								   myFileDlg->width(),atoi(myTxt.retCurParseBuf()));
		else if (myTxt.isKeyword(keyword_DirOpen))
		{
			if (myTxt.isAgainKeyword(keyword_Yes))
				myFileDlg->show();
		}
		else if (myTxt.isKeyword(keyword_StilOpen))
		{
			if (myTxt.isAgainKeyword(keyword_No))
				stilInfoDesired = false;
		}
		// Sidtunes directory.
		else if (myTxt.isKeyword(keyword_Directory))
			myFileDlg->setDir(myTxt.retCurParseBuf());
		else if (myTxt.isKeyword(keyword_NameFilter))
		{
			QFileDialog* myBakFileDlg = myFileDlg;
			myFileDlg = new QFileDialog(myBakFileDlg->dirPath(),myTxt.retCurParseBuf(),0,0,false);
			myFileDlg->setGeometry(myBakFileDlg->frameGeometry());
			myFileDlg->setCaption("Sidtune Selection");
			myFileDlg->setIcon(*myMainIcon);
			delete myBakFileDlg;
			myMainDlg->connectFileDialog();
		}
		else if (myTxt.isKeyword(keyword_HVSCroot))
			hvscPath = new QDir(myTxt.retCurParseBuf());
    };
}

// ------------------------------------------------------------------- Output

void writeMergedPanPosLeft(ofstream& toFile, voiceVol panLevels[4])
{
	long int allPanPosLeft;
	allPanPosLeft = (panLevels[0].l<<24)+(panLevels[1].l<<16)+
		(panLevels[2].l<<8)+(panLevels[3].l);
	toFile << allPanPosLeft << endl;
}

void writeMergedPanPosRight(ofstream& toFile, voiceVol panLevels[4])
{
	long int allPanPosRight;
	allPanPosRight = (panLevels[0].r<<24)+(panLevels[1].r<<16)+
		(panLevels[2].r<<8)+(panLevels[3].r);
	toFile << allPanPosRight << endl;
}


bool writeConfigFile()
{
	catConfigFilePath();
	bool wasSuccess = false;

    ofstream toFile(configPath,ios::out|ios::bin|ios::trunc);
	if (toFile)
	{
		toFile 
			<< "# ~/.sidplayrc" << endl
			<< "#" << endl
			<< "# SIDPLAY/X11 configuration file." << endl
			<< "#" << endl
			<< "# DO NOT edit manually." << endl
			<< endl;

		// Order is important because of Qt function calls !
		
		// Sidtunes directory.
		toFile << keyword_Directory << myFileDlg->dirPath() << endl;
		toFile << keyword_NameFilter << myFileDlg->dir()->nameFilter() << endl;
		if (hvscPath != 0)
		{
			toFile << keyword_HVSCroot << hvscPath->path() << endl;
		}
		
		// Listening mileage.
		toFile
			<< keyword_Usage << (usage+myEmuEngine.getSecondsTotal()) << endl
			<< endl;
		
		toFile
			<< "# Audio quality settings." << endl
			<< keyword_Frequency << (ulong)myEmuConfig.frequency << endl
			<< keyword_Channels << (int)myEmuConfig.channels << endl
			<< keyword_BitsPerSample << (int)myEmuConfig.bitsPerSample << endl;
		extern bool expertMode;
		if (expertMode)
		{
			// Don't destroy user's sane settings.
			toFile
				<< keyword_Fragments << bakBufferConfig.fragments << endl
				<< keyword_FragmentSize << (1L<<bakBufferConfig.fragSizeExp) << endl
				<< keyword_BufferSize << bakBufferConfig.bufferSize << endl;
		}
		else
		{
			toFile
				<< keyword_Fragments << myBufferConfig.fragments << endl
				<< keyword_FragmentSize << (1L<<myBufferConfig.fragSizeExp) << endl
				<< keyword_BufferSize << myBufferConfig.bufferSize << endl;
		}
		toFile
			<< endl;

		toFile << "# Emulator settings." << endl;

		toFile << keyword_ClockSpeed;
		if (myEmuConfig.clockSpeed == SIDTUNE_CLOCK_PAL)
			toFile << keyword_PAL << endl;
		else  // if (myEmuConfig.clockSpeed == SIDTUNE_CLOCK_NTSC)
			toFile << keyword_NTSC << endl;

		toFile << keyword_ForceSongSpeed;
		(myEmuConfig.forceSongSpeed) ? (toFile << keyword_Yes << endl) : (toFile << keyword_No << endl);
		
		toFile << keyword_MemoryMode;
		if (myEmuConfig.memoryMode == MPU_BANK_SWITCHING)
			toFile << keyword_FullBankSwitching << endl;
		else if (myEmuConfig.memoryMode == MPU_TRANSPARENT_ROM)
			toFile << keyword_TransparentROM << endl;
		else if (myEmuConfig.memoryMode == MPU_PLAYSID_ENVIRONMENT)
			toFile << keyword_PlaySID << endl;

		toFile << keyword_MOS8580;
		(myEmuConfig.mos8580) ? (toFile << keyword_Yes << endl)
			: (toFile << keyword_No << endl);

		toFile << keyword_MeasuredMasterVolume;
		(myEmuConfig.measuredVolume) ? (toFile << keyword_Yes << endl)
			: (toFile << keyword_No << endl);

		toFile << keyword_UseFilter;
		(myEmuConfig.emulateFilter) ? (toFile << keyword_Yes << endl)
			: (toFile << keyword_No << endl);
		toFile << keyword_FilterFs;
		toFile << myEmuConfig.filterFs << endl;
		toFile << keyword_FilterFm;
		toFile << myEmuConfig.filterFm << endl;
		toFile << keyword_FilterFt;
		toFile << myEmuConfig.filterFt << endl;

		toFile << endl << "# Mixer settings." << endl;

		toFile << keyword_Mixer;
		if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL)
			toFile << keyword_HQ << endl;
		else if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING)
			toFile << keyword_FP << endl;
		else if (myEmuConfig.volumeControl == SIDEMU_STEREOSURROUND)
			toFile << keyword_StereoSurround << endl;
		else
			toFile << keyword_No << endl;
			
		toFile << keyword_AutoPanning;
		if (myEmuConfig.autoPanning == SIDEMU_CENTEREDAUTOPANNING)
			toFile << keyword_Centered;
		else
			toFile << keyword_No;
		toFile << endl;
		
		toFile << keyword_Voice1Vol;
		toFile << (int)voiceMasterVol[0] << endl;
		toFile << keyword_Voice2Vol;
		toFile << (int)voiceMasterVol[1] << endl;
		toFile << keyword_Voice3Vol;
		toFile << (int)voiceMasterVol[2] << endl;
		toFile << keyword_Voice4Vol;
		toFile << (int)voiceMasterVol[3] << endl;

		toFile << keyword_PanPosLeftHQ;
		writeMergedPanPosLeft(toFile,voiceHQvol);
		toFile << keyword_PanPosRightHQ;
		writeMergedPanPosRight(toFile,voiceHQvol);
		toFile << keyword_PanPosLeftFP;
		writeMergedPanPosLeft(toFile,voiceFPvol);
		toFile << keyword_PanPosRightFP;
		writeMergedPanPosRight(toFile,voiceFPvol);
		toFile << endl;

		// Window geometries.
/*
[WINDOWS]
DirPosX=206
DirPosY=6
DirExtX=768
DirExtY=454
MainPosX=209
MainPosY=6
MixerOpen=No
FilterOpen=No
ListViewOpen=No
FilterPosX=365
FilterPosY=406
MixerPosX=268
MixerPosY=104
 */

/*
 * Qt bug !!!
 */
		
//		QRect blah = myMainDlg->frameGeometry();
//		cout << blah.x() << " / " << myMainDlg->x() << endl;
//		cout << blah.y() << " / " << myMainDlg->y() << endl;
		
		toFile
			<< "# Window geometries." << endl
			<< keyword_MainPosX << myMainDlg->x()-1 << endl
			<< keyword_MainPosY << myMainDlg->y()-1 << endl
			<< keyword_DirPosX << myFileDlg->x()-1 << endl
			<< keyword_DirPosY << myFileDlg->y()-1 << endl
			<< keyword_DirExtX << myFileDlg->width() << endl
			<< keyword_DirExtY << myFileDlg->height() << endl
			<< keyword_DirOpen;
		myFileDlg->isVisible() ? (toFile << keyword_Yes << endl) : (toFile << keyword_No << endl);
		toFile
			<< keyword_StilOpen;
		myMainDlg->isStilInfoEnabled() ? (toFile << keyword_Yes << endl) : (toFile << keyword_No << endl);
		toFile
			<< endl;

		toFile.close();
		wasSuccess = toFile;
	}
	
	return wasSuccess;
}
