//
// /home/ms/sidplay/X11/RCS/LEDButton.cpp,v
//

#include <LEDButton.h>
#include <qpainter.h>

#include "images/greenledon.xpm"
#include "images/greenledoff.xpm"
#include "images/redledon.xpm"
#include "images/redledoff.xpm"

LEDButton::LEDButton(QWidget* parent, const char* name) : QButton(parent,name)
{
	backgCol = parent->backgroundColor();
	ledColour = red;
	
	onPixmap = new QPixmap(size());
	offPixmap = new QPixmap(size());
	createPixmaps();
	
	bChecked = false;
}

LEDButton::~LEDButton()
{
	delete onPixmap;
	delete offPixmap;
}

void LEDButton::createPixmaps()
{
	onPixmap->resize(size().width(),size().height());
	offPixmap->resize(size().width(),size().height());
	
	QPainter paint;
	
	QPixmap onPixmap2green((const char**)greenledon_xpm);
	QPixmap onPixmap2red((const char**)redledon_xpm);
	paint.begin(onPixmap);
	paint.setBackgroundColor(backgCol);
	paint.eraseRect(0,0,size().width(),size().height());
	switch (ledColour)
	{
	 case green:
		{
			paint.drawPixmap(0,0,onPixmap2green);
			break;
		}
	 case red:
	 default:
		{
			paint.drawPixmap(0,0,onPixmap2red);
			break;
		}
	}
	if (text() != 0)
	{
		QColor myPenColor(black);
		paint.setPen(myPenColor);
		paint.drawText(20,12,text());
	}
	paint.end();

	QPixmap offPixmap2green((const char**)greenledoff_xpm);
	QPixmap offPixmap2red((const char**)redledoff_xpm);
	paint.begin(offPixmap);
	paint.setBackgroundColor(backgCol);
	paint.eraseRect(0,0,size().width(),size().height());
	switch (ledColour)
	{
	 case green:
		{
			paint.drawPixmap(0,0,offPixmap2green);
			break;
		}
	 case red:
	 default:
		{
			paint.drawPixmap(0,0,offPixmap2red);
			break;
		}
	}
	if (text() != 0)
	{
		QColor myPenColor(black);
		paint.setPen(myPenColor);
		paint.drawText(20,12,text());
	}
	paint.end();
}

void LEDButton::setColour(int col)
{
	if ((col == green) || (col == red))
		ledColour = col;
}

void LEDButton::setText(const char* newText)
{
	QButton::setText(newText);
	createPixmaps();
}

bool LEDButton::isChecked()
{
	return bChecked;
}

void LEDButton::setChecked(bool val)
{
	bChecked = val;
	repaint(false);
}

void LEDButton::toggle()
{
	bChecked = !bChecked;
	repaint(false);
}

void LEDButton::drawButton(QPainter* painter)
{
	if (bChecked)
		painter->drawPixmap(0,0,*onPixmap);
	else
		painter->drawPixmap(0,0,*offPixmap);
}
