/*****************************************************************************

	  Confidential and Proprietary to RADLogic Pty. Ltd.

       Copyright 1994, RADLogic Pty. Ltd.  All rights reserved.

This precautionary copyright notice against inadvertent publication is
neither an acknowledgement of publication, nor a waiver of confidentiality.

*******************************************************************************
*******************************************************************************

Filename:	~icurtis/src/gnet/menu.c

Description:	

Update History:   (most recent first)
     I. Curtis  21-Feb-94 13:47 -- Created.

******************************************************************************/
#include <stdio.h>
#include "mx_lib.h"

#define MAIN_N_ITEMS 7
mx_menu_item main_items[] = {
  {MXItemFlag_Center, "Edit", 0},
  {MXItemFlag_Left, "Delete", 0},
  {MXItemFlag_Left, "Rotate Clock", 0},
  {MXItemFlag_Left, "Buttons..", 0},
  {MXItemFlag_Left | MXItemFlag_Disabled, " ", 0},
  {MXItemFlag_Left, "Add Shape..", 0},
  {MXItemFlag_Left, "Add Instance..", 0},
};

#define SHAPE_N_ITEMS 4
mx_menu_item shape_items[] = {
  {MXItemFlag_Center, "Add Shape", 0},
  {MXItemFlag_Left, "Line", 0},
  {MXItemFlag_Left, "Ellipse", 0},
  {MXItemFlag_Left | MXItemFlag_Disabled, "Box", 0},
};

#define INST_N_ITEMS 11
mx_menu_item inst_items[] = {
  {MXItemFlag_Center, "Select Cell", 0},
  {MXItemFlag_Left, "nfet", 0},
  {MXItemFlag_Left, "pfet", 0},
  {MXItemFlag_Left, "invx1", 0},
  {MXItemFlag_Left, "invx2", 0},
  {MXItemFlag_Left, "nand2x1", 0},
  {MXItemFlag_Left, "nand2x2", 0},
  {MXItemFlag_Left, "nand3x1", 0},
  {MXItemFlag_Left, "nor2x1", 0},
  {MXItemFlag_Left, "nor2x2", 0},
  {MXItemFlag_Left, "nor3x1", 0},
};

mx_menu_item item_request[] = {
  {MXItemFlag_Center, "Save As..", 0}
};

#define FLAG_N_ITEMS 5
mx_menu_item flag_items[] = {
  {MXItemFlag_Center, "Program Flags", 0},
  {MXItemFlag_Left, "Selected", 0},
  {MXItemFlag_Left, "Expanded", 0},
  {MXItemFlag_Left | MXItemFlag_Disabled, "Traversed", 0},
  {MXItemFlag_Left, "Hidden", 0},
};

#define BYE_N_ITEMS 3
mx_menu_item bye_items[] = {
  {MXItemFlag_Center, "Question:", 0},
  {MXItemFlag_Left, "Do you want to terminate", 0},
  {MXItemFlag_Left, "the program?", 0},
};

#define BUTT_N_ITEMS 3
mx_menu_item butt_items[] = {
  {MXItemFlag_Center, "Yes", 0},
  {MXItemFlag_Center, "Huh?", 0},
  {MXItemFlag_Center, "No", 0},
};

#define HELP_N_ITEMS 3
mx_menu_item help_items[] = {
  {MXItemFlag_Center, "Help", 0},
  {MXItemFlag_Left, "Please select one of the", 0},
  {MXItemFlag_Left, "other options next time.", 0},
};

/*****************************************************************************
 *                                                                           *
 * 				 Main                                        *
 *                                                                           *
 *****************************************************************************/

main()
{
  Display *display;		          /* X Display */
  int screen;			          /* X screen */
  XEvent event;
  Window main_window, menu_window;          /* X Menu window */
  int done, choice;
  mx_appearance *app, *app2;
  mx_panel *panel_request, *panel_inst, *panel_shape;
  mx_panel *panel_bye, *panel_main, *panel_flags, *panel_butt, *panel_help;
  int main_width, main_height, main_x, main_y;
  char text[20];
  int x, y;

  strcpy(text, "Hello, World");
				/*** Open display ***/
  display = XOpenDisplay("");
  screen = DefaultScreen(display);

  main_window = mx_window_open(display, screen, "Menu", 140, 300, 2);

  XSelectInput(display, main_window, StructureNotifyMask |
	       OwnerGrabButtonMask | ButtonPressMask | ButtonReleaseMask);

  /* -adobe-helvetica-bold-r-normal--18-* */
  app = mx_appearance_create(display, screen, main_window, "9x15bold", 2, 2,
			     0, 0, NULL, NULL);
  app2 = mx_appearance_create(display, screen, main_window, "-adobe-helvetica-bold-r-normal--18-*", 2, 5,
			     0, 0, NULL, NULL);
  panel_main = mx_panel_create(display, app, MAIN_N_ITEMS, main_items);
  panel_shape = mx_panel_create(display, app, SHAPE_N_ITEMS, shape_items);
  panel_inst = mx_panel_create(display, app, INST_N_ITEMS, inst_items);
  panel_request = mx_panel_create(display, app, 1, item_request);
  panel_flags = mx_panel_create(display, app, FLAG_N_ITEMS, flag_items);
  panel_bye = mx_panel_create(display, app, BYE_N_ITEMS, bye_items);
  panel_butt = mx_panel_create(display, app2, BUTT_N_ITEMS, butt_items);
  panel_help = mx_panel_create(display, app2, HELP_N_ITEMS, help_items);

  done = 0;
  while (!done) {
    XNextEvent(display, &event);
    switch(event.type) {
    case ConfigureNotify:
      printf("config event (%d %d %d %d)\n",
	     event.xconfigure.x, event.xconfigure.y,
	     event.xconfigure.width, event.xconfigure.height);
      main_x = event.xconfigure.x;
      main_y = event.xconfigure.y;
      main_width = event.xconfigure.width;
      main_height = event.xconfigure.height;
      break;
    case Expose:
      break;
    case ButtonPress:
      x = event.xbutton.x_root;
      y = event.xbutton.y_root;
      if (event.xbutton.button == 1) {
	choice = mx_popup_alert(display, screen, panel_bye, panel_butt, &x, &y);
	printf("Choice was %d\n", choice);
	if (choice == 0)
	  done = 1;
	else if (choice == 1)
	  choice = mx_popup_alert(display, screen, panel_help, NULL, &x, &y);
      }
      else if (event.xbutton.button == 2) {
	choice = mx_popup_menu(display, screen, panel_main, &x, &y, True);
	printf("Choice was %d\n", choice);
	if (choice >= 0)
	  printf("== \"%s\"\n", panel_main->item[choice].text);
	if (choice == 3) {
	  choice = mx_popup_button(display, screen, panel_flags, 5, &x, &y);
	  printf("Choice was %d\n", choice);
	}
	else if (choice == 5) {
	  choice = mx_popup_menu(display, screen, panel_shape, &x, &y, False);
	  printf("Choice was %d\n", choice);
	  if (choice >= 0)
	    printf("== \"%s\"\n", panel_shape->item[choice].text);
	}
	else if (choice == 6) {
	  choice = mx_popup_select(display, screen, panel_inst, &x, &y, 4);
	  printf("Choice was %d\n", choice);
	  if (choice >= 0)
	    printf("== \"%s\"\n", panel_inst->item[choice].text);
	}
      }
      else if (event.xbutton.button == 3) {
	mx_popup_request(display, screen, panel_request, &x, &y, text, 20);
	printf("Request was  \"%s\"\n", text);
      }
      break;
    case ButtonRelease:
      break;
    default:
      break;
    }
  }
  mx_window_close(display, main_window);
}
