/* 
   PXKSliderCell.m

   NSSliderCell for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <DPS/psops.h>
#include <AppKit/NSColor.h>
#include <gnustep/xdps/PXKSliderCell.h>
#include <gnustep/xdps/PXKWindow.h>

@implementation PXKSliderCell

- (void)drawBarInside:(NSRect)rect flipped:(BOOL)flipped
{
  if ([self image])
    return;

  /* We should now draw the bar. Since this code depends on backend this method
     should be overwritten in backend. */
  PSgsave ();
  PSsetgray (0.5);
  PSrectfill (rect.origin.x, rect.origin.y, rect.size.width, rect.size.height);
  PSgrestore ();
}

@end
