/* 
   PXKApplication.m

   NSApplication for GNUstep GUI X/DPS Backend

   The NSApplication class manages the main event loop of
   the program, keeps track of the application's windows
   and which one is the key window.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: January 1996
   Author:  Ovidiu Predescu <ovidiu@net-community.com>
   Date: June 1997

   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>
#include <gnustep/xdps/stdpxk.h>
#include <stdlib.h>

#include <Foundation/NSArray.h>
#include <Foundation/NSRunLoop.h>
#include <Foundation/NSTimer.h>
#include <Foundation/NSNotification.h>

#include <AppKit/NSWindow.h>
#include <AppKit/NSApplication.h>

#include <gnustep/xdps/PXKEvent.h>
#include <gnustep/xdps/PXKEventFactory.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include <gnustep/xdps/PXKApplication.h>
#include <gnustep/xdps/PXKScreen.h>

#if LIB_FOUNDATION_LIBRARY
# include <Foundation/NSPosixFileDescriptor.h>
#elif defined(NeXT_PDO)
# include <Foundation/NSFileHandle.h>
# include <Foundation/NSNotification.h>
#endif

//
// Backend structure for PXKApplication
//
typedef struct _PXKApp_struct
{
  Window grab_window;
} PXKApp_struct;

#define XGRAB (((PXKApp_struct *)be_app_reserved)->grab_window)

@implementation PXKApplication

- init
{
  // Allocate backend structure
  be_app_reserved = malloc(sizeof(PXKApp_struct));
  XGRAB = 0;

  return [super init];
}

- (void)dealloc
{
  // Deallocate backend structure
  free(be_app_reserved);

  [super dealloc];
}

- (void)run
{
  Display* xDisplay = [(PXKDPSContext *)[NSDPSContext currentContext]
				xDisplay];

  [super run];

  // xxx We should close the DPS context as well?

  // Close the X Display
  XCloseDisplay(xDisplay);
}

#if !defined(LIB_FOUNDATION_LIBRARY) && !defined(NeXT_PDO)
/* Assume gnustep-base */
- (void)readyForReadingOnFileDescriptor:(int)fd
{
  [self getNextEvent];
}
#endif

// Get next event
- (void)getNextEvent
{
  NSEvent *e = nil;
  NSEvent* nullEvent = [NSApplication getNullEvent];

  /* loop and grap all the events from the X queue */
  do
    {
      e = checkEvent();

      if ((!e) || (e == nullEvent))
	NSDebugLog(@"Got the null event\n");
      else
	{
	  [event_queue addObject: e];
	  NSDebugLog(@"Event is for window %d type %d\n",
		     [e windowNumber], [e type]);
	}
    }
  while (e);
}

// Peek next event
- (NSEvent *)peekNextEvent
{
  NSEvent* nullEvent = [NSApplication getNullEvent];
  NSEvent *e = peekEvent();

  if ((!e) || (e == nullEvent))
    NSDebugLog(@"Got the null event\n");
  else
    [event_queue addObject: e];

  NSDebugLog(@"Event is for window %d type %d\n", [e windowNumber], [e type]);

  return e;
}

// handle a non-translated event
- (void)handleNullEvent
{}

- (void)setupRunLoopInputSourcesForMode:(NSString*)mode
{
  Display* xDisplay
      = [(PXKDPSContext *)[NSDPSContext currentContext] xDisplay];
  int xEventQueueFd = XConnectionNumber (xDisplay);
  NSRunLoop* currentRunLoop = [NSRunLoop currentRunLoop];

  /* Invoke limitDateForMode: to setup the current mode of the run loop (the
     doc says that this method and acceptInputForMode:beforeDate: are the only
     ones that setup the current mode).
  */
  [currentRunLoop limitDateForMode:mode];

#if defined(LIB_FOUNDATION_LIBRARY)
  {
    id fileDescriptor = [[[NSPosixFileDescriptor alloc]
				initWithFileDescriptor:xEventQueueFd]
				autorelease];

    [fileDescriptor setDelegate:self];
    [fileDescriptor monitorFileActivity:NSPosixReadableActivity];
  }
#elif defined(NeXT_PDO)
  {
    id fileDescriptor = [[[NSFileHandle alloc]
				initWithFileDescriptor:xEventQueueFd]
				autorelease];

    [[NSNotificationCenter defaultCenter]
	    addObserver:self
	    selector:@selector(activityOnFileHandle:)
	    name:NSFileHandleDataAvailableNotification
	    object:fileDescriptor];
    [fileDescriptor waitForDataInBackgroundAndNotifyForModes:
			[NSArray arrayWithObject:mode]];
  }
#else
  /* Assume gnustep-base */
  [(id)currentRunLoop addReadDescriptor:xEventQueueFd object:self forMode:mode];
#endif
}

#if LIB_FOUNDATION_LIBRARY
- (void)activity:(NSPosixFileActivities)activity
  posixFileDescriptor:(NSPosixFileDescriptor*)fileDescriptor
{
  [self getNextEvent];
}
#elif defined(NeXT_PDO)
- (void)activityOnFileHandle:(NSNotification*)notification
{
  id fileDescriptor = [notification object];
  id runLoopMode = [[NSRunLoop currentRunLoop] currentMode];

  [fileDescriptor waitForDataInBackgroundAndNotifyForModes:
		    [NSArray arrayWithObject:runLoopMode]];
  [self getNextEvent];
}
#endif

- (void)setGrabXWindow:(Window)w
{
  XGRAB = w;
}

- (Window)grabXWindow
{
  return XGRAB;
}

- (void)_flushCommunicationChannels
{
}

@end
