/*
 * dfile.c - PTX file processing functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.3 98/03/06 08:27:28 abe Exp $";
#endif


#include "lsof.h"


/*
 * print_dev() - print dev
 */

char *
print_dev(lf)
	struct lfile *lf;		/* file whose device is to be printed */
{
	static char buf[128];

#if	PTXV>=400
	if (major(lf->dev) == NAMEFS_DEV) {
	    (void) sprintf(buf, "NMFS,%d", minor(lf->dev));
	    return(buf);
	}
#endif	/* PTXV>=400 */

	(void) sprintf(buf, "%d,%d", major(lf->dev), minor(Lf->dev));
	return(buf);
}


/*
 * print_nm() - print name
 */

void
print_nm(lf)
	struct lfile *lf;		/* file whose name is to be printed */
{

#if	defined(HASLFILEADD)
	if (Fxopt && (lf->fct_def || lf->ina_def)) {
	    printname(0);
	    if (lf->fct_def)
		(void) printf(" ct=%ld", lf->fct);
	    if (lf->ina_def)
		(void) printf(" ina=%s\n", print_kptr(lf->ina, (char *)NULL));
	    else
		putchar('\n');
	} else
#endif	/* defined(HASLFILEADD) */

	    printname(1);
}


/*
 * process_file() - process file
 */

void
process_file(fp)
	KA_T fp;			/* kernel file structure address */
{
	struct file f;
	int flag;

	if (kread(fp, (char *)&f, sizeof(f))) {
	    (void) sprintf(Namech, "can't read file struct from %s",
		print_kptr(fp, (char *)NULL));
	    enter_nm(Namech);
	    return;
	}
	Lf->off = (SZOFFTYPE)f.f_offset;

#if	defined(HASLFILEADD)
	Lf->fct = f.f_count;
	Lf->fct_def = 1;
#endif	/* defined(HASLFILEADD) */

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
	    if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
		Lf->access = 'r';
	    else if (flag == FWRITE)
		Lf->access = 'w';
	    else if (flag == (FREAD | FWRITE))
		Lf->access = 'u';
	/*
	 * Process structure.
	 */
	    process_node((KA_T)f.f_vnode);
	    return;
	}
	enter_nm("no more information");
}
