/*
 * Copyright 1991 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 */
#ifndef lint
static char	*RCSid = "$Header: /home/harbor/davy/stuff/xpostit/RCS/xpostit.c,v 1.7 1992/12/10 16:39:38 davy Exp $";
#endif

/*
 * xpostit.c - Post-It Notes for the X Window System.
 *
 * This version is for X11R4/R5 and uses the Xt toolkit and Athena widgets.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log: xpostit.c,v $
 * Revision 1.7  1992/12/10  16:39:38  davy
 * Added code for keyboard accelerators, tearoff notes, wm protocols, etc.
 * from Joe English (joe@trystero.art.com).
 *
 * Revision 1.6  1992/12/09  20:11:55  davy
 * Miscellaneous System V compilation fixes.
 *
 * Revision 1.5  1992/12/09  19:54:16  davy
 * Added XI18N international Xaw support from Hiroshi Kuribayashi,
 * kuri@omron.co.jp.
 *
 * Revision 1.4  1991/09/06  18:29:40  davy
 * Added copyright/permission notice for submission to MIT R5 contrib.
 *
 * Revision 1.3  91/09/06  17:15:13  davy
 * New features, bug fixes, etc.
 * 
 * Revision 1.2  90/06/14  11:21:24  davy
 * Ported to X11 Release 4.
 * 
 * Revision 1.1  90/06/13  09:48:51  davy
 * Initial revision
 * 
 */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <signal.h>
#include <stdio.h>

#include "xpostit.h"

/*
 * Command line options and the resources they set.
 */
static XrmOptionDescRec options[] = {
    { "-bs",	".bufSize",		XrmoptionSepArg,	NULL },
    { "-dir",	".noteDir",		XrmoptionSepArg,	NULL },
    { "-sb",	".scrollBar",		XrmoptionNoArg,		"true" },
    { "-sv",	".saveNotes",		XrmoptionNoArg,		"true" }
};

/*
 * Fallback resources.
 */
static String fallback_resources[] = {
#ifdef XI18N
    "*fontSet:			-*--14-*",
    "*Text*wrap:		line",
    "*CommandLocale*shapeStyle: oval",
    "*preeditType:		OverTheSpot",
#else
    "*Command*font: -adobe-helvetica-bold-r-normal--11-*-*-*-*-*-*-*",
    "*Menu*font:    -adobe-helvetica-medium-r-normal--12-*-*-*-*-*-*-*",
    "*Text*font:    -b&h-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*",

    "*Text*wrap:		word",
    "*Command*shapeStyle:	oval",
#endif

    NULL
};
	
/*
 * Resources we maintain besides those maintained by the toolkit.
 */
static XtResource resources[] = {
#define offset(field)	XtOffset(AppResPtr,field)
    { "bufSize", "BufSize", XtRInt, sizeof(int),
      offset(buf_size), XtRImmediate, (caddr_t) DefaultBufSize },
    { "noteDir", "NoteDir", XtRString, sizeof(String),
      offset(note_dir), XtRString, DefaultNoteDir },
    { "saveNotes", "SaveNotes", XtRBoolean, sizeof(Boolean),
      offset(save_notes), XtRImmediate, (caddr_t) False },
    { "scrollBar", "Scroll", XtRBoolean, sizeof(Boolean),
      offset(scroll_bar), XtRImmediate, (caddr_t) False },
#undef offset
};

static Atom	wm_delete_window, wm_save_yourself, wm_protocols, wm_command;
static void	WMProtocolsHandler();

AppRes	app_res;		/* xpostit application resources	*/
Widget	toplevel;		/* top level application shell widget	*/
Screen	*screen;		/* pointer to the screen of the display	*/
Display	*display;		/* pointer to the display we're on	*/
XtAppContext appcontext;	/* application context			*/

void
main(argc, argv)
char **argv;
int argc;
{
	Arg args[4];
	char *appname;
	char *rindex();
	Atom protos[2];
	register int nargs;
	Boolean setsigs = False;

	/*
	 * Ignore signals for now, but record whether they were
	 * already ignored or not so we can catch them later if
	 * need be.
	 */
	if ((signal(SIGQUIT, SIG_IGN) != SIG_IGN) &&
	    (signal(SIGINT, SIG_IGN) != SIG_IGN))
		setsigs = True;

	/*
	 * Get application name.
	 */
	if ((appname = rindex(*argv, '/')) == NULL)
		appname = *argv;
	else
		appname++;

	/*
	 * Initialize the toolkit and create an application shell.
	 */
#ifdef XI18N
	XtSetLanguageProc(NULL, NULL, NULL);
#endif
	toplevel = XtAppInitialize(&appcontext, PostItNoteClass, options,
			XtNumber(options), &argc, argv, fallback_resources,
			NULL, 0);

	display = XtDisplay(toplevel);
	screen = DefaultScreenOfDisplay(display);

	/*
	 * If we need to handle keyboard signals, do it now.
	 */
	if (setsigs) {
		signal(SIGQUIT, ByeBye);
		signal(SIGINT, ByeBye);
	}

	/*
	 * Always handle these.
	 */
	signal(SIGTERM, ByeBye);
	signal(SIGHUP, ByeBye);

	/*
	 * Send X errors to the exit routine.
	 */
	XSetErrorHandler((XErrorHandler) ByeBye);

	/*
	 * Now get any resources we're interested in.
	 */
	XtGetApplicationResources(toplevel, &app_res, resources,
				  XtNumber(resources), argv, argc);

	/*
	 * Construct the path to the directory notes are
	 * stored in.
	 */
	SetNoteDir();

	/*
	 * Create the plaid and menu widgets.
	 */
	CreatePlaidWidget();
	CreateMenuWidget();

	/*
	 * Realize the top level and flush the server, which will
	 * let the user position the plaid window and map it.
	 */
	XtRealizeWidget(toplevel);

	/*
	 * Set some properties for the window manager.
	 */
	wm_command = XInternAtom(display, "WM_COMMAND", False);
	wm_protocols = XInternAtom(display, "WM_PROTOCOLS", False);
	wm_delete_window = XInternAtom(display, "WM_DELETE_WINDOW", False);
	wm_save_yourself = XInternAtom(display, "WM_SAVE_YOURSELF", False);

	protos[0] = wm_delete_window;
	protos[1] = wm_save_yourself;
	XSetWMProtocols(display, XtWindow(toplevel), protos, 2);
	XtAddEventHandler(toplevel, 0, True, WMProtocolsHandler, NULL);
	XtVaSetValues(toplevel, XtNwindowGroup, XtWindow(toplevel), NULL);

	XFlush(display);

	/*
	 * Load the notes the user has saved, and create widgets
	 * for them.
	 */
	LoadSavedNotes();

	/*
	 * Never returns.
	 */
	XtAppMainLoop(appcontext);
}

/*
 * WMProtocolsHandler - top level WM protocol handler.  WM_DELETE_WINDOW
 *			is quit xpostit, WM_SAVE_YOURSELF is save all notes.
 */
static void
WMProtocolsHandler(w, client_data, event, continue_to_dispatch)
Boolean *continue_to_dispatch;
XtPointer client_data;
XEvent *event;
Widget w;
{
	XClientMessageEvent *c_event = (XClientMessageEvent *) event;

	if (event->type != ClientMessage ||
	    c_event->message_type != wm_protocols)
		return;

	if (c_event->data.l[0] == wm_delete_window) {
		ByeBye();
	}
	else if (c_event->data.l[0] == wm_save_yourself) {
		if (app_res.save_notes)
			SaveAllNotes();

		/*
		 * Let session manager know we've saved ourself by doing
		 * a zero-length append on the WM_COMMAND property.
		 */
		XChangeProperty(XtDisplay(w), XtWindow(w), wm_command,
				XA_STRING, 8, PropModeAppend, "", 0);
	}
}
