#include <config.h>

#include <stdio.h>
#include <string.h>


#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <slang.h>
#include "slrn.h"
#include "menu.h"
#include "misc.h"

typedef struct 
{
   char *menu_name;
   char *function_name;
}
Menu_Type;

static Menu_Type Group_Mode_Menu [] =
{
     {"Quit", "quit"},
     {"Refresh", "refresh_groups"},
     {"Top", "bob"},
     {"Bot", "eob"},
     {"Post", "post"},
     {"Help", "help"},
     {NULL, NULL}
};

	
static Menu_Type Article_Mode_Menu [] =
{
     {"Quit", "quit"},
     {"Catchup", "catchup_all"},
     {"NextGrp", "skip_to_next_group"},
     {"NextArt", "next"},
     {"Top", "goto_beginning"},
     {"Bot", "goto_end"},
     {"Post", "post"},
     {"Reply", "reply"},
     {"Followup", "followup"},
     {"Help", "help"},
     {NULL, NULL}
};

static Menu_Type *Current_Menu;


static void update_menu (Menu_Type *m)
{
   Current_Menu = m;
   /* if (Slrn_Full_Screen_Update == 0) return; */
   SLsmg_gotorc (0, 0);
   slrn_set_color (MENU_COLOR);
   if (m != NULL) while (m->menu_name != NULL)
     {
	SLsmg_write_string (m->menu_name);
	SLsmg_write_string ("   ");
	m++;
     }
   SLsmg_erase_eol ();
   slrn_set_color (0);
}

int slrn_execute_menu (int want_col, SLKeymap_Function_Type *kf)
{
   Menu_Type *m;
   char *fun, *kf_fun;
   int col;
   int color;
   
   if ((want_col < 0) || (want_col >= SLtt_Screen_Cols)) return -1;
   
   m = Current_Menu;
   if (m == NULL) return -1;
   
   col = -1;
   while (m->menu_name != NULL)
     {
	int dcol = 2 + strlen (m->menu_name);
	if ((want_col > col) 
	    && (want_col <= col + dcol))
	  break;
	col += dcol + 1;
	m++;
     }
   if (m->menu_name == NULL) return -1;
   
   /* redraw menu item so that user sees that it has been pressed */
   if (col == -1) col = 0;
   color = MENU_PRESS_COLOR;
   SLsmg_gotorc (0, col);
   while (1)
     {
	slrn_set_color (color);
	if (col) SLsmg_write_string(" ");
	SLsmg_write_string (m->menu_name);
	SLsmg_write_string (" ");
	SLsmg_gotorc (0, col);
	slrn_smg_refresh ();
	if (color == MENU_COLOR) break;
	(void) SLang_input_pending (1);	       /* 1/10 sec */
	color = MENU_COLOR;
     }
   slrn_set_color (0);
   fun = m->function_name;
   while (NULL != (kf_fun = kf->name))
     {
	if (!strcmp (kf_fun, fun))
	  {
	     ((void (*)(void)) (kf->f)) ();
	     return 0;
	  }
	kf++;
     }
   return -1;
}

	
   
void slrn_update_article_menu (void)
{
   update_menu (Article_Mode_Menu);
}

void slrn_update_group_menu (void)
{
   update_menu (Group_Mode_Menu);
}
