/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#ifndef MenuGP_h
#define MenuGP_h

#include "MenuG.h"
#include <X11/RectObjP.h>
#include "MenuP.h"

#define MenuGadgetChangeHighlighted(g) \
(((MenuGadgetClass)(g)->object.widget_class)->menu_g_class.change_highlighted)
#define MenuGadgetCallCallbacks(g) \
(((MenuGadgetClass)(g)->object.widget_class)->menu_g_class.call_callbacks)
#define MenuGadgetUnhighlightOnLeave(g) \
(((MenuGadgetClass)(g)->object.widget_class)->menu_g_class.unhighlight_on_leave)

typedef void (*MenuGadgetProc)(MenuGadget);

#define XtInheritChangeHighlighted ((MenuGadgetProc)_XtInherit)
#define XtInheritCallCallbacks	   ((MenuGadgetProc)_XtInherit)

typedef struct {
    MenuGadgetProc	change_highlighted;
    MenuGadgetProc	call_callbacks;
    Boolean		unhighlight_on_leave;
    XtPointer		extension;
} MenuGadgetClassPart;

typedef struct MenuGadgetClassRec {
    RectObjClassPart	rect_class;
    MenuGadgetClassPart	menu_g_class;
} MenuGadgetClassRec;

extern MenuGadgetClassRec menuGadgetClassRec;

typedef struct {
    XtCallbackList	callback;
    /* private data */
    Boolean		highlighted;
} MenuGadgetPart;

typedef struct MenuGadgetRec {
    ObjectPart		object;
    RectObjPart		rectangle;
    MenuGadgetPart	menu_g;
} MenuGadgetRec;

#endif /* MenuGP_h */
