/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#ifndef ArtText_h
#define ArtText_h

#ifndef XtCMargin
#define XtCMargin "Margin"
#endif
#ifndef XtCPreferredLines
#define XtCPreferredLines "PreferredLines"
#endif
#ifndef XtCPreferredColumns
#define XtCPreferredColumns "PreferredColumns"
#endif

#ifndef XtNhighlightColor
#define XtNhighlightColor "highlightColor"
#endif
#ifndef XtNresizeCallback
#define XtNresizeCallback "resizeCallback"
#endif
#ifndef XtNseparatorMargin
#define XtNseparatorMargin "separatorMargin"
#endif
#ifndef XtNpreferredLines
#define XtNpreferredLines "preferredLines"
#endif
#ifndef XtNpreferredColumns
#define XtNpreferredColumns "preferredColumns"
#endif
#ifndef XtNurlCallback
#define XtNurlCallback "urlCallback"
#endif

typedef struct ArtTextClassRec*		ArtTextWidgetClass;
typedef struct ArtTextRec*		ArtTextWidget;

extern WidgetClass artTextWidgetClass;

typedef struct {
    long	canvas_length;
    long	slider_length;
    long	slider_position;
} ArtTextReport;

typedef struct {
    const char	*line;
    int		sel_ok;
    long	start;
    long	stop;
} ArtTextUrlReport;

extern void ArtTextRot13(Widget);
extern void ArtTextClearLines(Widget);
extern void ArtTextAddLine(Widget, char*, XFontStruct*, Pixel);
extern void ArtTextAddWLine(Widget, XChar2b*, long, XFontStruct*, Pixel);
extern void ArtTextAppendToLast(Widget, char*);
extern void ArtTextWAppendToLast(Widget, XChar2b*, long);
extern void ArtTextAddSelected(Widget, char*, XFontStruct*, Pixel, long, long);
extern void ArtTextAddSeparator(Widget, int, int);
extern void ArtTextAddClickable(Widget, char*, XFontStruct*, Pixel,
				XtCallbackProc, XtPointer);
extern void ArtTextGetFirstShownSize(Widget, long*, long*, long*);
extern void ArtTextSetFirst(Widget, long);
extern int  ArtTextDumpToFile(Widget, FILE*);
extern void ArtTextAllocLines(Widget, long);

#endif /* ArtText_h */
