#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/main.tcl,v $
# $Date: 1996/04/07 15:56:17 $
# $Revision: 1.16.1.54 $
#
proc playBell {this tag} {
    global zircon Bl TBl
    set snd $Bl($this)
    switch -glob -- $tag {
      @me {catch { set snd $TBl($this,@me) }}
      user* { set foo [$tag lname] ; catch { set snd $TBl($this,$foo) } }
    }
    if {[info exists zircon(soundcmd)] && ![string match {} $zircon(soundcmd)] 
      && ![string match {} $snd]} {
	eval exec $zircon(soundcmd) $snd &
    } {
	eval $zircon(bellcmd)
    }
}
#
proc away {args} { global aways ; lappend aways [join $args] }
#
proc nick {args} { global nicks ; lappend nicks [join $args] }
#
proc ircname {args} { global ircnames ; lappend ircnames [join $args] }
#
proc action {args} { global actions ; lappend actions [join $args] }
#
proc leave {args} { global leaves ; lappend leaves [join $args] }
#
proc signoff {args} { global signoffs ; lappend signoffs [join $args] }
#
proc zbind {chan sequence action} {
    if [string match {} $chan] {
	global bindings
	lappend bindings [list $sequence $action]
    } {
	set chn [Channel :: make $chan]
	set b [$chn bindings]
	lappend b [list $sequence $action]
	$chn configure -bindings $b
    }
}
#
class Channel {
    name	{}
    lname	{}
    open	0
    close	0
    history	50
    draw	1
    jump	1
    quiet	0
    hpos	end
    actions	0
    logfile	{}
    log		{}
    closetime	0
    crypt	{}
    buttons	1
    closecount	0
    window	{}
    patterns	{}
    menu	0
    join	0
    ops		{}
    msg		{}
    bindings	{}
    icon	{}
    topics	{}
    keep	0
    monitor	0
    key		{}
    text	{}
    foreground	{}
    background	{}
    font	{}
    geometry	{}
    height	{}
    width	{}
    boldfont	{}
    sys		0
    actionmode	0
    p		0
    m		0
    s		0
    i		0
    t		0
    n		0
}
#
# Configuration panel stuff
#
array set cVars {
    IRC		{nicks ircnames}
    Channels	{}
    People	{ignores showFriends friendsOn}
    Info	{showLocal showPublic showPrivate topicOnly minMembers \
		 noConfirm toInfo popInfo verboseCTCP helpService \
		 noPopup noRefresh killPath listPattern topicPattern }
    Others	{aways actions invisible wallops srvmsg leaves signoffs}
}
#
array set confData {
    channel	{{{Auto Join} join} {{Pop Up} open} \
		 {{Pop Down} close} {{On Menu} menu} {Draw draw} \
		 {Jump jump} {Quiet quiet}}
    single	{showLocal showPublic showPrivate \
		 topicOnly minMembers popInfo verboseCTCP helpService \
		 invisible wallops srvmsg noRefresh noPopup friendsOn
		 killPath listPattern topicPattern showFriends }
    msg		{Join Kick Kill Leave Mode Quit Topic}
    info	{Ctcp Signoff Who Whois Whowas Error Ison Info}
    nconf	{Quit Leave Kill SaveConf}
}
#
proc srcit {file what} {
    if [file exists $file] {
	if [catch {uplevel #0 source $file} msg] {
	    puts stderr "**** Error in the $what file - $msg"
	    exit 1
	}
	return 1
    }
    return 0
}
#
proc InitGlobals {} {
    global env user argv zircon host defaults
    if [file exist $zircon(lib)/zircon.ad] {
	option readfile $zircon(lib)/zircon.ad startupFile
    }
    option add *Checkbutton*relief flat widgetDefault
    option add *Checkbutton*borderwidth 0 widgetDefault
    option add *CheckButton*padX 5 widgetDefault
    option add *CheckButton*padY 4 widgetDefault
    option add *CheckButton*highlightThickness 0 widgetDefault
    option add *Button*padX 5 widgetDefault
    option add *Button*padY 4 widgetDefault
    option add *Button*highlightThickness 0 widgetDefault
    option add *Menubutton*padX 5 widgetDefault
    option add *Menubutton*pady 4 widgetDefault
    option add *Menubutton*relief raised widgetDefault
    option add *Menubutton*width 10 widgetDefault
    option add *Frame*borderWidth 2 widgetDefault
    option add *Scrollbar*relief raised widgetDefault
    option add *Listbox*relief raised widgetDefault
    option add *Entry*relief raised widgetDefault
    option add *Entry*highlighThickness 1 widgetDefault
    option add *Text*setGrid 1 widgetDefault
    option add *Text*wrap word widgetDefault
    option add *Text*relief raised widgetDefault
    option add *Text*exportSelection 1 widgetDefault
    option add *Canvas*relief raised widgetDefault
    
    foreach x [bind Text] { bind ROText $x [bind Text $x] }
    foreach x {<KeyPress-F20> <KeyPress-F18> <Tab> <Control-i> <Return>
      <Delete> <BackSpace> <Insert> <KeyPress> <Control-d> <Control-k>
      <Control-o> <Control-t> <Meta-BackSpace> <Meta-Delete>
      <Control-h> <ButtonRelease-2>} {
	bind ROText $x {}
    }

    array set zircon "
	tmp		/tmp
	busymsg		{I am busy and am not accepting calls at the moment.}
	multion		0
	images		0
	bellcmd		bell
	envnick		IRCNICK
	envname		IRCNAME
	envserver	IRCSERVER
	prefdir		~/.zircon
	reconnect	0
	register	[file exist ~/.zirconreg]
	command		0
	raw		0
	style		original
	language	english
	look		standard
	autos		{join open close menu draw jump quiet}
	ircIImode	0
	action		Shift-Return
	beep		BEEP
	sepColor	red
	ping		0
	autoreconnect	0
    "
    array set default [array get zircon]
    array set zircon {
	nameCount 0
	idle	0
	j	0
	o	0
	z	0
	host	{}
	i	{}
	N	{}
	S	{}
	p	{}
    }
    getOption showFriends 0
    getOption friendsStyle window
    getOption smiley {:-\)}
    getOption scowl {:-\(}
    getOption wink {;-\)}
    getOption listPattern {.*}
    getOption topicPattern {.*}
    getOption minMembers 3
    foreach arg {noPopup popInfo \
      invisible wallops srvmsg showPrivate topicOnly DEBUG monitorIn \
      monitorOut verboseCTCP } {
	getOption $arg 0
    }
    foreach arg {noRefresh friendsOn killPath showLocal showPublic} {
	getOption $arg 1
    }
    foreach arg {ons bindings nicks ircnames actions noConfirm aways \
	 toInfo ignores leaves signoffs} {
	getOption $arg {}
    }
    global monitor ; set monitor {}
# control panel
    global namesTxt namesChan monitorTime notifyInterval testTime trust notify
    set notify {}
    set namesTxt {}
    set namesChan {}
    getOption monitorTime 60
    set monitorTime [expr $monitorTime * 1000]
    set notifyInterval 30000
    set testTime $notifyInterval
# Messages
    getOption signoff {I run Zircon - so should you}
    getOption helpService {Help_UK}
    array set trust {
	eval	{}
	draw	.+
    }
    global defChan defChat defMsg defNotice
    set defChan [Channel *default* -height 24 -width 80]
    set defChat [Chat *default* -height 10 -width 80]
    set defMsg [Message *default* -height 10 -width 80]
    set defNotice [Notice *default* -height 10 -width 80]
#
# Array variables
#
    makeArray TFg TBg TAF TAB TSplit Heal Split MkOp MTO NTO \
      OnCode Host Nick STO AChat Chat Offer Send Get Shost CTO CHTO
# Process args
    set opts {}
    foreach arg $argv {
	if [string match {-*} $arg] {
	    foreach bit [split [string range $arg 1 end]] {
		switch $bit {
		j - o -	z { set zircon($bit) 1 }
		r - i -	N - S -	p { lappend opts $bit}
		default { puts stderr "Unknown option -$bit" }
		}
	    }
	} {
	    set opt [lindex $opts 0]
	    set opts [lrange $opts 1 end]
	    switch $opt {
	    i - N - S - r - p { set zircon($opt) $arg }
	    default { }
	    }
	}
    }
#
# Source the system and then the user's rc file if they exist. The -z
# flag turns off reading rc files.
#
    if !$zircon(z) {
	if [info exists zircon(r)] {
	    srcit $zircon(r) "your $zircon(r)"
	} {
	    if [srcit $zircon(lib)/rc {the system rc}] {
	        foreach sv [Server :: list] { $sv configure -sys 1 }
	        foreach sv [Channel :: list] { $sv configure -sys 1 }
	    }
	    if ![srcit $zircon(prefdir)/preferences \
		"your $zircon(prefdir)/preferences"] {
		if [srcit ~/.zirconrc {your .zirconrc}] { upgradeRC }
	    }
	}
    }
    global signoffs signoff monitorIn monitorOut DEBUG
    catch {set zircon(prefdir) $env(ZIRCONPREFDIR)}
    if ![srcit $zircon(prefdir)/look/$zircon(look).tcl \
      "your Zircon $zircon(look) look"] {
	srcit $zircon(lib)/look/$zircon(look).tcl \
	  "the system Zircon $zircon(look)"
    }
    srcit $zircon(lib)/lang/english.tcl "the system Zircon english message"
    if [string compare english $zircon(language)] {
	srcit $zircon(lib)/lang/$zircon(language).tcl \
	  "system Zircon $zircon(language) message"
    }
    srcit $zircon(prefdir)/lang/$zircon(language).tcl \
      "your Zircon $zircon(language) message"
    if {$monitorIn || $monitorOut} { set DEBUG 1 }
    set signoffs [linsert $signoffs 0 $signoff]
    global nicks myid
    set host [thisHost]
    set user [expr {[info exists env(USER)] ? $env(USER) : [exec whoami]}]
    envCheck $zircon(N) $zircon(envnick) nicks $user
    envCheck $zircon(i) $zircon(envname) ircnames $user@$host
    if ![string match {} $zircon(S)] {
	Server :: make $zircon(S)
	Server :: select $zircon(S)
    } \
    elseif {[info exists env($zircon(envserver))]} {
	set ss [split $env($zircon(envserver))]
	foreach v $ss {
	    Server :: make $v
	    if [string match {} $zircon(host)] { Server :: select $v }
	}
	Server :: select [lindex $v 0]
    }
    if [string match {} $zircon(host)] { Server :: select default }
    if {![string match {} $zircon(p)] || [info exists env(IRCPORT)]} {
	set v [expr {$zircon(p) != {} ? $zircon(p) : $env(IRCPORT)}]
    }
#
# Re-Initialise things in case they were set in the rc file....
#
    array set zircon {
	version		1.16
	patchlevel	1beta63
	windows		 0
    }
#
#
#
    global busy startup allChannels confChange closeTime
    set closeTime [expr [$defChan closetime] * 1000]
    set zircon(ping) [expr $zircon(ping) * 1000]
    set busy 0
    set startup 1
    set allChannels {}
    set confChange 0
#
#	1 if user is an IRC operator
#
    set zircon(ircop) 0
    set zircon(ignore) {Notices Public Invites Wallops Notes CTCP Others}
#
# Create the User object for me!! It gets ref'd just below
#
    set myid [User [lindex $nicks 0]]
    foreach x [User :: list]	{ $x ref }
#
# Flag channels that are created in the rc file. This makes sure they
# dont get thrown away when the channel is closed
#
    foreach x [Channel :: list] { $x configure -keep 1 }
    foreach x [Message :: list] { $x configure -keep 1 }
    processOns
}
#
proc notIdle {win} {
    [channel $win] extendTime
    uplevel #0 set zircon(idle) 0
}
#
proc doScroll {win what args} {eval $win yview $what $args}
#
proc setScroll {txt win total window} {
    set id [channel $win]
    upvar #0 $id cdata
    if {$total > $cdata(history)} {
	incr total -$cdata(history)
	$txt delete 1.0 "1.0 + $total lines"
	set total $cdata(history)
    }
    $win set $total $window
}
#
# alter menu item states - used for oping and ircoping
#
proc setState {name pick state} {
    if [string compare none [$name index last]] {
	global Ops
	foreach cmd $Ops($pick) {
	    if ![catch {set idx [$name index [trans $cmd]]}] {
		$name entryconfigure $idx -state $state
	    }
	}
    }
}
#
proc makeMB {win text} {
    menubutton $win -text [trans $text] -menu $win.menu -width 10
    return [menu $win.menu]
}
#
proc getOValue {win opt lc uc} {
    if [string match {} [set x [option get ${win} $lc $uc]]] {
	set x [$win cget -$opt]
    }
    return $x
}
#
proc getTValue {win win2 opt lc uc} {
    if {[set x [option get ${win} $lc $uc]] == {}} { set x [$win2 cget -$opt] }
    return $x
}
#
proc doHelp {net topic service} {
    if ![string match {} $service] {$net PRIVMSG $service $topic}
}
#
proc getHelp {net} {
    global helpService ztrans
    mkEntryBox .@help$net $ztrans(help) "Enter topic on which you need help:" \
      "{$ztrans(topic) {zircon ?}} {$ztrans(service) $helpService}" \
      "$ztrans(ok) {doHelp $net}" "$ztrans(cancel) {}"
}
#
proc pickvar {v1 v2} { return [expr {[uplevel info exists $v1] ? $v2 : $v1}]}
#
proc setTags {this nk} {
    global TFn TFa TFg TBg TAF TAB TBl Bl
    set w [$this text]
    set x "$this,$nk"
    set ch [$this tagWindow]
    set TFn($x) [getTValue $ch $w font ${nk}Font Font]
    set TFg($x) [getTValue $ch $w foreground ${nk}Foreground Foreground]
    set TBg($x) [getTValue $ch $w background ${nk}Background Background]
    set TFa($x) [getTValue $ch $w font ${nk}ActionFont Font]
    set TAF($x) [getTValue $ch $w foreground ${nk}ActionForeground Foreground]
    set TAB($x) [getTValue $ch $w background ${nk}ActionBackground Background]
    if {[set TBl($x) [option get $ch ${nk}Bell Bell]] == {} &&
      [info exists Bl($this)]} { set TBl($x) $Bl($this) }
}
#
proc insertText {this name text tag} {
    set taglist $tag
    if [string match "*\[\002\007\017\026\037\]*" $text] {
	while {[regexp \
	  "^(\[^\002\007\017\026\037\]*)(\[\002\007\017\026\037\])(.*)$" \
	  $text match m1 ch text]} {
	    $name insert end $m1 $taglist
	    switch -- $ch {
	    \002 { set spc @b@ }
	    \007 {
		    if ![$this quiet] { playBell $this $tag }
		    global zircon
		    $name insert end { } $taglist $zircon(beep) \
		      [concat $taglist @a@$tag] { } $taglist
		    continue
		}
	    \017 { set taglist $tag ; continue }
	    \026 { set spc @v@ }
	    \037 { set spc @u@ }
	    }
	    if {[set x [lsearch $taglist ${spc}*]] < 0} {
		lappend taglist $spc$tag
	    } {	set taglist [lreplace $taglist $x $x] }
	}
    }
    $name insert end $text $taglist
}
#
proc channelInvite {net chan args} {if {$chan != {}} { userInvite $net $chan }}
#
proc doNotice {net chan string} {
    if ![string match {} $string] {
	if {![string compare nil [set cn [Channel :: find $chan]]] ||
	    ![$cn active]} {
	    $net display @me "$chan>- $string"
	} {
	    $cn addText @me "- $string"
	    $cn configure -hpos end
	}
	$net NOTICE $chan $string
    }
}
#
proc channelNotice {net chan args} {
    if ![string match {} $chan] {
	global ztrans
	mkEntryBox .@[newName wn] "Notice to ${chan}" \
	  {Enter your notice text:} \
	  "{$ztrans(notice) {}}" "$ztrans(ok) {doNotice $net {$chan}}" \
	  "$ztrans(cancel) {}"
    }
}
#
proc channelList {net chan} { $net channelList $chan }
#
proc channelJoin {net chan args} {
    if ![string match {} $chan] { [Channel :: make $chan] sendJoin [lindex $args 0] }
}
#
proc channelMonitor {net chan} {
    if ![string match {} $chan] {
	if ![[set chid [Channel :: make $chan]] active] {
	    global monitor
	    set flg [string match {} $monitor]
	    set chan [$chid lname]
	    if {[lsearch $monitor ${chan}] < 0} { lappend monitor ${chan} }
	    $chid configure -monitor 1
	    if $flg { $net send NAMES $chan } { $net monitorTest }
	}
    }
}
#
proc channelWho {net chan} { if ![string match {} $chan] { $net send WHO $chan } }
#
proc channelNames {net chan} {
    if [string match {} $chan] {
	global ztrans
	mkDialog {} .@names $ztrans(names) {That will list *ALL* users on irc!!!} {} \
	    "$ztrans(ok) {$net send NAMES}" "$ztrans(cancel) {}"
    } {
	$net send NAMES $chan
    }
}
#
proc popup {win} { wm deiconify $win ; raise $win }
#
proc markButton {name which} {
    if ![winfo exists $name] return
    foreach opt {font foreground background activeForeground \
      activeBackground} {
	set uopt [capitalise $opt]
	set fopt ${which}[expr {$which != {} ? $uopt : $opt}]
	set lopt [string tolower $opt]
	if {[set cl [option get $name $fopt $uopt]] != {}} {
	    $name conf -$lopt $cl
	} \
	elseif {$which == {}} {
	    if {[set cl [lindex [$name conf -$lopt] 3]] != {}} {
		$name conf -$lopt $cl
	    }
	}
    }
    set af [$name cget -activeforeground]
    set fg [$name cget -foreground]
    if {$af == $fg} {
	set bg [$name cget -background]
	$name conf -activeforeground $bg -activebackground $fg
    }
}
#
proc markEntry {name index which} {
    if {![winfo exists $name] || $index == -1} return
    foreach opt {font background activeBackground} {
	set uopt [capitalise $opt]
	set fopt ${which}[expr {$which != {} ? $uopt : $opt}]
	set lopt [string tolower $opt]
	if {[set cl [option get $name $fopt $uopt]] != {}} {
	    $name entryconfigure $index -$lopt $cl
	} \
	elseif {$which == {}} {
	    if {[set cl [lindex [$name conf -$lopt] 3]] != {}} {
		$name entryconfigure $index -$lopt $cl
	    }
	}
    }
    set af [$name cget -activeforeground]
    set fg [$name cget -foreground]
    if {$af == $fg} {
	set bg [$name cget -background]
	$name entryconfigure $index -activeforeground $bg -activebackground $fg
    }
}
#
array set userFlags {
	o	ircop
	O	ircop
	w	wallops
	s	srvmsg
	i	invisible
}
#
# First message from the server....
#
proc irc001 {net prefix param pargs} {
    global startup myid zircon defMsg defChan
    $net flagControl normal
    $net fast
    $net deIRCOp
    set me [$myid name]
    set opStuff [list [$zircon(host) oper] [$zircon(host) operpw]]
    if {[set nk [lindex $opStuff 0]] != {}} {
	if [string match {} [set pw [lindex $opStuff 1]]] {
	    global ztrans
	    mkEntryBox .@opw$net {IRC Op Password} \
	      {Enter your operator password:} "{$ztrans(password) {}}" \
	      "$ztrans(ok) { doOper $net $nk }" "$ztrans(cancel) {}"
	} {
	    $net send OPER $nk $pw
	}
    }
    if [$net invisible] { $net setFlag invisible }
    if [$net wallops]	{ $net setFlag wallops }
    if [$net srvmsg] { $net setFlag srvmsg }
    if !$zircon(j) {
	foreach id [Channel :: list] {
	    if ![string compare $id $defChan] continue
	    if {[$id join] || [$id active]} {
		$id sendJoin {}
		if [$id active] {
		    $id flag normal
		    $id unmarkV $myid
		    $id unmarkOp $myid
		}
	    } \
	    elseif {[$id monitor]} { channelMonitor $net [$id name] }
	}
	foreach id [Message :: list] {
	    if {$id != $defMsg} {
		if [string compare nil [User :: find [$id name]]] {
		    $id show
		    $id flag normal
		}
	    }
	}
    }
    $net display {} "*** $param"
    $net setupTests
    if $zircon(register) {
	$net send PRIVMSG ZirconBot "!zstartup $zircon(version) $zircon(patchlevel)"
	set zircon(register) 0
    }
    handleOn STARTUP [list [$zircon(host) host] [$zircon(host) port]]
    set startup 0
}
#
proc irc004 {net prefix param pargs} {
    set serverInfo [lrange $pargs 1 4]
    $net display {} \
      "[string range $prefix 1 end]: umodes available [lindex $serverInfo 2],\
channel modes available [lindex $serverInfo 3]"
}
#
proc irc381 {net prefix param pargs} {
    $net configure -ircop 1
    [$net info] addText {} "*** $param"
}
#
proc irc301 {net prefix param pargs} {
    global whois
    if [info exists whois(info)] {
	set whois(away) $param
    } {
	regsub -all {\\} $pargs {\\\\} pargs
	switch [set x [Message :: find [set who [lindex $pargs 1]]]] {
	nil { [$net info] addText {} "*** $who is away: $param" }
	default { $x awayMsg $param }
	}
    }
}
#
proc irc303 {net prefix param pargs} {
    global friendsOn signInfo ztrans
    set frnd [$net friends]
    set signons {}
    set signoffs {}
    set msg {}
    set lpar {}
    set signInfo {}
    foreach who $param {
	set usr [User :: make $who]
	lappend lpar $usr
	if {![$usr ison] || [$usr limbo]} {
	    $usr on
 	    if [$frnd absent $usr] {
		$usr heal
	    } {
		if {[$usr id] != {}} {
		    lappend signInfo $usr
		} {
		    lappend signons $who
		    if {$friendsOn && [$usr friend]} { $frnd add $usr }
		    $frnd mark $usr ison
		}
	    }
	}
    }
    if ![string match {} $signons] { set msg "Signon by $signons detected.\n" }
    foreach usr [User :: list] {
	if {[$usr ison] && ![$usr limbo] && [lsearch $lpar $usr] < 0} {
	    $usr off
	    lappend signoffs [$usr name]
	}
    }
    if ![string match {} $signoffs] {set msg "${msg}Signoff by $signoffs detected.\n"}
    if ![string match {} $msg] {
	set cmd "mkInfoBox ISON .@ison Notify {[getDate] :\n$msg} {$ztrans(dismiss) {}}"
	if ![string match {} $signons] { append cmd " {$ztrans(whois) {who303 $net $signons}}" }
	if ![string match {} $signoffs] { append cmd " {$ztrans(whowas) {was303 $net $signoffs}}" }
	eval $cmd
    }
    foreach x $signInfo {$net send USERHOST [$x name]}
}
#
proc who303 {net args} { foreach x $args { $net send WHOIS $x } }
#
proc was303 {net args} { foreach x $args { $net send WHOWAS $x } }
#
proc irc305 {net prefix param pargs} { $net irc305 }
#
proc irc306 {net prefix param pargs} { $net irc306 }
#
proc irc321 {net prefix param pargs} { $net irc321 }
#
proc irc322 {net prefix param pargs} { $net irc322 $prefix $param $pargs }
#
proc irc323 {net prefix param pargs} { $net irc323 $prefix $param $pargs }
#
proc irc324 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    [Channel :: find [lindex $pargs 1]] mode [lrange $pargs 2 end]
}
#
proc irc353 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    set chan [string tolower [lindex $pargs 2]]
    if ![[set chid [Channel :: make $chan]] active] {
	global namesTxt namesChan
	if {$namesChan != $chid} {
	    set namesChan $chid
	    set namesTxt $param
	} {
	    append namesTxt "\n$param"
	}
    } { 
	$chid doNames $param
    }
}
#
proc updateMon {net chid names} {
    set w .@mon${chid}
    if ![winfo exists $w] {makeMon $net $chid $names ; return}
    set win $w.users.userList
    set xist {}
    foreach n [winfo children $win] { lappend xist [lindex [split $n .] end] }
    foreach n $names {
	if [string match {} $n] continue
	set op 0
	set sp 0
	while {[string match {[@+]*} $n]} {
	    if {[string index $n 0] == {@}} { set op 1 } { set sp 1}
	    set n [string range $n 1 end] ;
	}
	set usr [User :: make $n]
	if ![winfo exists $win.$usr] {
	    menubutton $win.$usr -text $n -menu $win.$usr.menu -width 12
	    bind $win.$usr <Destroy> "$usr deref"
	    makeUserMenu nil $win.$usr.menu $usr
	    $win window create end -window $win.$usr
	    $usr ref
	} \
	elseif {[set x [lsearch $xist $usr]] >= 0} {listdel xist $x}
	if $op {
	    markButton $win.$usr operator
	} {
	    markButton $win.$usr [expr {$sp ? "speaker" : {} }]
	}
    }
    foreach n $xist { destroy $win.$n }
}
#
proc makeMon {net chid names} {
    global ztrans
    set w .@mon${chid}
    toplevel $w -class Zircon
    set chan [$chid name]
    wm title $w "$chan $ztrans(monitor)"
    wm resizable $w 0 1
    wm protocol $w WM_DELETE_PROTOCOL "deMonitor $net $w $chan"
 
    pack [frame $w.btns -relief raised] -side bottom -fill x
    pack [set wu [frame $w.users -relief raised]] -fill y
    scrollbar $wu.vscroller -command "$wu.userList yview" 
    set win [text $wu.userList -yscrollcommand "bsSet $wu.vscroller" \
      -relief flat -borderwidth 0 -width 14]
    pack $wu.userList $wu.vscroller -side left -fill y -expand 1
    button $w.btns.cancel -text Cancel -command "deMonitor $net $w ${chan}" \
      -width 5
    button $w.btns.join -text Join -command " $chid sendJoin {} " -width 5
    bind $wu <Destroy> "deMonitor $net {} {$chan}"
    pack $w.btns.cancel $w.btns.join -side left -fill x -expand 1
    foreach n $names {
	if {$n == {}} continue
	set op 0
	set sp 0
	while {[string match {[@+]*} $n]} {
	    if {[string index $n 0] == {@}} { set op 1 } { set sp 1}
	    set n [string range $n 1 end]
	}
	set usr [User :: make $n]
	set winu $win.$usr
 	menubutton $winu -text $n -menu $winu.menu -width 12
	makeUserMenu nil $winu.menu $usr
	if $op { markButton $winu operator } \
	elseif $sp { markButton $winu speaker }
	$usr ref
	$win window create end -window $winu
    }
}
#
proc irc366 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    set chan [string tolower [lindex $pargs 1]]
    set chid [Channel :: make $chan]
    global namesChan namesTxt ztrans
    if ![string compare $namesChan $chid] {
	global monitor
	if {[lsearch $monitor [$chid lname]] >= 0 } {
	    updateMon $net $chid [split $namesTxt]
	} {
	    mkInfoBox NAMES .@names$chid "$ztrans(names) $chan" $namesTxt "$ztrans(dismiss) {}"
	}
    }
    set namesChan {}
    set namesTxt {}
}
#
proc irc376 {net prefix param pargs} {}
#
proc irc394 {net prefix param pargs} {}
#
proc irc251 {net prefix param pargs} {
    $net display {} "[string range $prefix 1 end]: $param"
}
#
proc irc252 {net prefix param pargs} {
    set nm [lindex "$pargs" 1]
    $net display {} \
      "[string range $prefix 1 end]: There [expr {$nm == 1 ? {is 1 operator} : "are $nm operators"}] online."
}
#
proc irc253 {net prefix param pargs} {
    set nm [lindex "$pargs" 1]
    $net display {} "[string range $prefix 1 end]: There [expr {$nm == 1 ? {is 1 unknown connection} : "are $nm connections"}]."
}
#
proc irc254 {net prefix param pargs} {
    set nm [lindex "$pargs" 1]
    $net display {} \
      "[string range $prefix 1 end]: There [expr {$nm == 1 ? {is 1 channel} : "are $nm channels"}] formed."
}
#
proc irc255 {net prefix param pargs} {
    $net display {} "[string range $prefix 1 end]: $param"
}
#
proc zUnknown {args} {
    global startup
    set cmd [lindex $args 0]
    if [string match {irc*} $cmd] {
	set net [lindex $args 1]
	if $startup { $net fast }
	if ![auto_load $cmd] { ircNUM $net $cmd $args } { return [uplevel $args] }
    } {
	return [uplevel sys_unknown $args]
    }
}
#
proc ircNUM {net number pargs} {
    global ztrans
    set txt {}
    regsub -all {\\} $pargs {\\\\} pargs
    foreach arg [lrange [lindex $pargs 4] 1 end] {
	if ![string match {} $arg] { append txt " $arg" }
    }
    append txt " [lindex $pargs 3]"
    switch -glob $number {
    irc[45]* { mkInfoBox ERROR .@e$net$number "$ztrans(error) $number" \
      $txt "$ztrans(dismiss) {}" }
    default { [lindex $pargs 1] display {} $txt }
    }
}
#
set inData {}
#
proc envCheck {arg evar gvar dflt} {
    global env $gvar
    set lst [set $gvar]
    if {$arg != {} || [info exists env($evar)]} {
	set v [expr {[string match {} $arg] ? $env($evar) : $arg}]
	if {[set x [lsearch $lst $v]] > 0} { listdel $gvar $x }
	if {$x != 0} { set $gvar [linsert $lst 0 $v] }
    } \
    elseif {$lst == {}} { set $gvar $dflt }
}
#
proc deMonitor {net w chan} {
    global monitor
    if ![string match {} $w] { catch {destroy $w} }
    if {[set x [lsearch $monitor ${chan} ]] >= 0} { listdel monitor $x }
    [Channel :: find $chan] configure -monitor 0
    if [string match {} $monitor] { after cancel "$net monitorTest" }	
}
#
proc Message_list {} { return [info globals {message*[0-9]}] }
#
proc Chat_list {} { return [info globals {chat*[0-9]}] }
#
proc Notice_list {} { return [info globals {notice*[0-9]}] }
#
proc Channel_list {} { return [info globals {channel*[0-9]}] }
#
proc find {name} {
    foreach class {Channel Message Notice} {
	if [string compare nil [set handle [$class :: find $name]]] { return $handle }
    }
    return nil
}
#
proc trans {text} {
    global ztrans
    catch {set text $ztrans([string tolower $text])}
    return $text
}
#
rename unknown sys_unknown
rename zUnknown unknown
