#
# $Source: /home/nlfm/Working/Zircon/Development/lib/interp/RCS/tclx.tcl,v $
# $Date: 1996/04/04 13:05:21 $
# $Revision: 1.16.1.9 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
set tclx_errorHandler tkerror
proc getDate {} { return [fmtclock [getclock]] }
#
proc ipAddress {} {
    global host hostIPaddress
    if [info exists hostIPaddress] { return $hostIPaddress }
    return [set hostIPaddress [lindex [server_info addresses $host] 0]]
}
#
proc thisHost {} {
    global env
    return [expr {[info exists env(HOSTNAME)] ? $env(HOSTNAME) : [exec hostname]}]
}
#
proc ChatServer {usr nk} {
    global AChat
    set sock [server_create]
    set port [lindex [fstat $fd localhost] 2]
    set AChat($usr) $sock
    fileevent $sock readable "acceptChat $usr $sock"
    [$usr net] CTCP DCC $nk "CHAT chat [ipPack [ipAddress]] $port"
}
#
proc acceptChat {usr conn} {
    global monitorIn
    if ![catch  {server_accept $conn} cls] {
	global AChat Chat
	[set cht [Chat [$usr name]]] show
	$cht addUser $usr 0 0
	set newc [set Chat($cht) [lindex $cls 0]]
	upvar #0 $newc chdata
	set chdata(who) $usr
	set chdata(obj) $cht
	handler $newc re dccChat
	catch {unset AChat($usr)}
	if $monitorIn { zIn "Chat Accept : [$usr name]" }
    } {
	net0 display {} "*** Error on DCC Chat (accept). $cls"
	if $monitorIn { zIn "Error on Accept : $conn" }
    }
    catch {fileevent $conn readable {}}
    catch {close $conn}
}
#
proc connect {host port} { return [server_connect -buf $host $port] }
#	
proc handler {sock what prc} { fileevent $sock readable "$prc r $sock" }
#
proc clearHandler {sock} { fileevent $sock readable {} }
#
proc atclose {args} { }
#
proc socketOption {args} { }
#
proc ircsend {sock what} { server_send $sock "$what\r\n" }
#
proc lowsend {sock what} { server_send $sock $what }
#
proc dp_receive {sock} { return [gets $sock] }
#
proc shutdown {args} { }
#
proc ircInput {mode conn} {
    global STN monitorIn inData zircon
    if {[catch {gets $conn} line] || $line == {}} {
	close $conn
	$STN($conn) close
    } {
	regsub -all "\r" $line {} line
	if $monitorIn { zIn $line }
	if ![regexp {^([^ ]*) ([^ ]*)(( ([^:][^ ]*))*)( :(.*))?$} \
	   $line match prefix cmd b c d e param] {
	    if ![regexp {^([^ ]*) ([^ ]*)(.*)$} $line match \
	      prefix cmd b] {
	        $STN($conn) display {} \
		  "*** Error on server connection - $line"
		return
	    }
	    set param {}
	}
	switch -glob $prefix {
	:* { }
	PING {
	        $STN($conn) qSend PONG :[string range $cmd 1 end]
	        return
	    }
	default { set prefix :[$zircon(host) host] }
	}
	if [catch {irc$cmd $STN($conn) $prefix $param \
	  [string range $b 1 end]} msg] {
	    zError $msg $cmd $prefix $param [string range $b 1 end]
	}
    }
}
#
proc version {} { return "tclX V[infox version] patch [infox patchlevel]" }
#
proc zping {args} {
    if {$args == {} } { return [getclock] }
    set res [lindex $args 0]
    if ![regexp {([0-9]+)} $res] {
	return $res
    }
    return [expr [getclock] - $res]
}
#
# $Source: /home/nlfm/Working/Zircon/Development/lib/interp/RCS/tclx.tcl,v $
# $Date: 1996/04/04 13:05:21 $
# $Revision: 1.16.1.9 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
set tclx_errorHandler tkerror
proc getDate {} { return [fmtclock [getclock]] }
#
proc ipAddress {} {
    global host hostIPaddress
    if [info exists hostIPaddress] { return $hostIPaddress }
    return [set hostIPaddress [lindex [server_info addresses $host] 0]]
}
#
proc thisHost {} {
    global env
    return [expr {[info exists env(HOSTNAME)] ? $env(HOSTNAME) : [exec hostname]}]
}
#
proc ChatServer {usr nk} {
    global AChat
    set sock [server_create]
    set port [lindex [fstat $sock localhost 2]]
    set AChat($usr) $sock
    fileevent $sock readable "acceptChat $usr $sock"
    [$usr net] CTCP DCC $nk "CHAT chat [ipPack [ipAddress]] $port"
}
#
proc acceptChat {usr conn} {
    global monitorIn
    if ![catch  {server_accept $conn} cls] {
	global AChat Chat
	[set cht [Chat [$usr name]]] show
	$cht addUser $usr 0 0
	set newc [set Chat($cht) [lindex $cls 0]]
	upvar #0 $newc chdata
	set chdata(who) $usr
	set chdata(obj) $cht
	handler $newc re dccChat
	catch {unset AChat($usr)}
	if $monitorIn { zIn "Chat Accept : [$usr name]" }
    } {
	net0 display {} "*** Error on DCC Chat (accept). $cls"
	if $monitorIn { zIn "Error on Accept : $conn" }
    }
    catch {fileevent $conn readable {}}
    catch {close $conn}
}
#
proc connect {host port} { return [server_connect -buf $host $port] }
#	
proc handler {sock what prc} { fileevent $sock readable "$prc r $sock" }
#
proc clearHandler {sock} { fileevent $sock readable {} }
#
proc atclose {args} { }
#
proc socketOption {args} { }
#
proc ircsend {sock what} { server_send $sock "$what\r\n" }
#
proc lowsend {sock what} { server_send $sock $what }
#
proc dp_receive {sock} { return [gets $sock] }
#
proc shutdown {args} { }
#
proc ircInput {mode conn} {
    global STN monitorIn inData zircon
    if {[catch {gets $conn} line] || $line == {}} {
	close $conn
	$STN($conn) close
    } {
	regsub -all "\r" $line {} line
	if $monitorIn { zIn $line }
	if ![regexp {^([^ ]*) ([^ ]*)(( ([^:][^ ]*))*)( :(.*))?$} \
	   $line match prefix cmd b c d e param] {
	    if ![regexp {^([^ ]*) ([^ ]*)(.*)$} $line match \
	      prefix cmd b] {
	        $STN($conn) display {} \
		  "*** Error on server connection - $line"
		return
	    }
	    set param {}
	}
	switch -glob $prefix {
	:* { }
	PING {
	        $STN($conn) qSend PONG :[string range $cmd 1 end]
	        return
	    }
	default { set prefix :[$zircon(host) host] }
	}
	if [catch {irc$cmd $STN($conn) $prefix $param \
	  [string range $b 1 end]} msg] {
	    zError $msg $cmd $prefix $param [string range $b 1 end]
	}
    }
}
#
proc version {} { return "tclX V[infox version] patch [infox patchlevel]" }
#
proc zping {args} {
    if {$args == {} } { return [getclock] }
    set res [lindex $args 0]
    if ![regexp {([0-9]+)} $res] {
	return $res
    }
    return [expr [getclock] - $res]
}
