#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/Net.tcl,v $
# $Date: 1996/04/04 13:48:27 $
# $Revision: 1.16.1.34 $
#
#
set netCount 0
#
proc Netspace {name args} {
    global netCount
    if ![string match {} $args] {
	set body [lindex $args 0]
    } {
	set name theNet
	set body $Name
    }
    Net net$netCount -name $name
    incr netCount
}
class Net {
    sock	{}
    ping	0
    host	{}
    away	0
    ircop	0
    info	{}
    control	{}
    nick	{}
    wallops	0
    srvmsg	0
    invisible	0
    showPublic	0
    showLocal	0
    showPrivate	0
    topicOnly	0
    minMembers	0
    sorted	0
    listPattern .*
    topicPattern	.*
}
#
proc Net {name args} {
    if [string match {::} $name] {
	return [eval Net_[lindex $args 0] [lrange $args 1 end] ]
    }
    global nickname zircon minMembers showLocal showPublic showPrivate \
      topicOnly
    initObj $name Net
    proc $name {args} " eval net_call $name \$args "
    set OType($name) Net
    upvar #0 $name ndata
    set ndata(ircop) $zircon(ircop)
    set ndata(minMembers) $minMembers
    set ndata(showLocal) $showLocal
    set ndata(showPublic) $showPublic
    set ndata(showPrivate) $showPrivate
    set ndata(topicOnly) $topicOnly
    set ndata(info) [Info info$name -net $name]
    set ndata(control) [Control ctl$name -net $name]
    $name configure -nick $nickname
    $name flagControl disabled
    if ![string match {} $args] { eval $name configure $args }
    $name setupUsers
    return $name
}
#
proc net_configure {this args} {
    upvar #0 $this ndata
    while {![string match {} $args]} {
	set opt [lindex $args 0]
	set val [lindex $args 1]
	switch -exact -- $opt {
	-nick { $this setNickname $val }
	-ircop {
		set ndata(ircop) $val
		[$this control] ircItems [expr {$val ? {normal} : {disabled}}]
		if $val {
		    set ndata(wallops) 1
		    set ndata(srvmsg) 1
		}
	    }
	default { set ndata([string range $opt 1 end]) $val }
	}
	set args [lrange $args 2 end]
    }
}
#
proc net_setFlag {this flag} {
    global myid
    $this MODE [$myid name] \
      [expr {[$this $flag] ? {+} : {-}}][string index $flag 0]
}
#
proc net_flagControl {this state} {
    set ctl [[$this control] window]
    foreach w {helpFrm.help cr.invis cr.wallop cr.srvmsg 
      bf2.servers bf2.users bf2.channels bf2.services
      bf1.away bf1.brb bf1.friends cmdLine.channel } {
	$ctl.$w configure -state $state
    }
}
proc net_setupUsers {this} {
    global friendsOn
    set frnd [$this friends]
    foreach usr [User :: friends] {
	if $friendsOn { $usr notify 1 }
	if {!$friendsOn || [$usr ison]} { $frnd add $usr }
    }
}
#
proc net_friends {this} { return [[$this control] friends] }
#
proc net_fast {this} {
    set txt [[$this info] text]
    $txt configure -cursor arrow
    catch "grab release $txt"
}
#
proc net_slow {this} {
    set txt [[$this info] text]
    catch "grab set $txt"
    $txt configure -cursor watch
}
proc net_display {this args} {
    global verboseCTCP
    if {[set tag [lindex $args 0]] != {@CTCP} || $verboseCTCP} {
	[$this info] addText $tag [lindex $args 1]
    }
}
#
proc net_call {this op args} {
    upvar #0 $this ndata
    switch $op {
    active { return [expr {![string match {} $ndata(sock)]}]}
    host { return [$ndata(host) host] }
    }
    if [info exists ndata($op)] { return $ndata($op) }
    return [eval net_$op $this $args]
}
#
proc net_closeSock {this msg} {
    upvar #0 $this ndata
    catch {foreach x [after info] { after cancel $x } }
    if ![string match {} [set sock $ndata(sock)]] {
	catch {atclose $sock clear}
	if ![string match {} $msg] { catch {ircsend $sock "QUIT :$msg" }}
	catch {shutdown $sock all}
	catch {close $sock}
	set ndata(sock) {}
	set ndata(ping) 0
	set ndata(host) {}
    }
}
#
proc net_doQuit {this msg} {
    global confChange
    $this closeSock $msg
    if $confChange {
	set w .@[newName Save]
	mkDialog SAVECONF $w {Save Configuration} \
	  {You have made changes to your configuration. Do you wish to \
save them?} {} {No exit} {Yes {saverc}}
	tkwait window $w
    }
    exit
}
#
proc net_quit {this} {
    global signoffs ztrans
    mkDialog QUIT .@q$this "Quit IRC" {Really quit?} \
      "{$ztrans(message) {[lindex $signoffs 0]}}" \
      "$ztrans(ok) {$this doQuit}" "$ztrans(cancel) {}"
}
#
proc net_startIRC {this srv} {
    if [string match {} $srv] { return 0 }
    global myid ircname host user noRefresh Icon STN
    set ctl [[$this control] window]
    $ctl.nSFrm.server.entry delete 0 end
    $ctl.nSFrm.server.entry insert end [$srv name]
    set port [$srv port]
    set server [$srv host]
    set passwd [$srv passwd]
    $this configure -ircop 0 -wallops 0 -srvmsg 0
    $this display {} "*** Connecting to port $port of server $server"
    $this slow
    upvar #0 $this ndata
    set ndata(sock) {}
    set ndata(host) $srv
    if [string match {} $port] {
	if [catch {dp_connect $server} sock] {
	    $this display {} \
	"*** Cannot connect to UNIX domain server $server ($sock)"
	    $this fast
	    return 0
	}
    } \
    elseif {[catch {connect $server $port} sock]} {
	$this display {} "*** Cannot connect to server $server ($sock)"
	$this fast
	return 0
    }
    set STN($sock) $this
    set ndata(sock) $sock
    foreach ln [$srv script] { lowsend $sock "$ln\n" }
    handler $sock re ircInput
    socketOption $sock recvBuffer 8192
    atclose $sock append "$this close"
    if ![string match {} $passwd] { $this qSend PASS :$passwd }
    $this qSend USER $user $host $server :$ircname
    $this qSend NICK :[$myid name]
    if !$noRefresh { $this channelList { } }
    set ircport $port
    set w [[$this info] window]
    wm title $w "Zircon Information Window - $server" 
    wm iconname $w [set Icon($w) "Info $server"]
    return 1
}
#
proc net_changeServerPort {this srv prt} {
    $this changeServer [Server $srv -port $prt]
}
#
proc net_changeServer {this srv args} {
    global startup zircon
    set ctl [[$this control] window]
    if [$this active] {
	$this display {} "*** Closing connection to [$this host]"
	$this closeSock {Changing Servers}
	$this flagControl disabled
	foreach ch [Channel :: list] { $ch flag disabled }
	$this irc305
	set zircon(j) 0
	after 5000
    }
    set startup 1
    if [$this startIRC $srv] {
	set zircon(host) $srv
	$this configure -ircop 0
	entrySet $ctl.nSFrm.server.entry [$srv name]
    }
}
#
proc net_channelList {this doit} {
    global allChannels showList ztrans
    upvar #0 $this ndata
    set allChannels {}
    set w .@l$this
    if ![winfo exists $w] {
	toplevel $w -class Zircon
	wm title $w {IRC Channel List}
	wm iconname $w {IRC Channel List}
	frame $w.filter -relief raised
	checkbutton $w.filter.public -variable ${this}(showPublic) -text Public
	checkbutton $w.filter.local -variable ${this}(showLocal) -text Local
	checkbutton $w.filter.private -variable ${this}(showPrivate) \
	  -text Private
	checkbutton $w.filter.topic -variable ${this}(topicOnly) \
	  -text {With Topic}
	checkbutton $w.filter.sorted -variable ${this}(sorted) -text Sorted

	scale $w.filter.members \
	  -from 1 -to 25 -label {Minimum Number of Members} \
	  -showvalue 1 -orient horizontal \
	  -command "set ${this}(minMembers)"

	$w.filter.members set $ndata(minMembers)

	pack $w.filter.members -fill x
	pack $w.filter.public $w.filter.local $w.filter.private \
	  $w.filter.topic $w.filter.sorted -side left -fill x
	global listPattern topicPattern
	labelEntry 0 $w.filter2 {-text Channel} $listPattern {}
	labelEntry 0 $w.filter3 {-text Topic} $topicPattern {}

	makeLB $w.chn -width 20 -height 8 -setgrid 1
	frame $w.btn
	button $w.btn.ok -text $ztrans(dismiss) -command "destroy $w" -relief raised
	wm protocol $w WM_DELETE_PROTOCOL "destroy $w"
	button $w.btn.clear -text $ztrans(clear) -relief raised \
	  -command "$w.chn.l delete 0 end ; set allChannels {}"
	button $w.btn.list -text $ztrans(list) -relief raised -command "
	    $w.chn.l delete 0 end
	    catch {grab set $w}
	    $w configure -cursor watch
	    $this q1Send LIST
	    $w.btn.list configure -state disabled
	    set allChannels {}
	  "
	pack $w.btn.list $w.btn.clear $w.btn.ok -side left -expand 1 -fill x
	pack $w.btn -fill x -side bottom
	pack $w.filter $w.filter2 $w.filter3 -fill x
	pack $w.chn -expand 1 -fill both
	bind $w.chn.l <Double-Button-1> "
	    channelJoin $this \[lindex \$allChannels \[%W nearest %y\]\] {}
	    break
	"
	bind $w.chn.l <Double-Button-2> {
	    whoAction [lindex $allChannels [%W nearest %y]]
	    break
	}
	bind $w.chn.l <Button-1> "
	    entrySet [[$this control] window].cmdLine.channel \
	      \[lindex \$allChannels \[%W nearest %y\]\]
	    break
	"
    } {
	popup $w
	if ![string match {} $doit] {$w.chn.l delete 0 end}
    }
    set showList 0
    if ![string match {} $doit] { $this qSend LIST :$doit ; set showList 1 }
}
#
proc net_irc321 {this args} {
    global listFile zircon
    if ![winfo exists .@l$this] return
    if [catch {set listFile($this) [open "$zircon(tmp)/list[pid]" w+]} msg] {
	set listFile {}
    }
}
#
proc net_irc322 {this prefix param pargs} {
    global listFile
    if ![winfo exists .@l$this] return
    if ![string match {} $listFile($this)] {
	puts $listFile($this) $pargs
	puts $listFile($this) $param
    } {
	$this listline $param $pargs
    }
}
#
proc net_listline {this param pargs} {
    global listPattern topicPattern
    set w .@l$this
    if [string match {} [set listPattern [$w.filter2.entry get]]] {
	set listPattern {.*}
    } \
    elseif {[catch {regexp $listPattern test} msg]} {
	set listPattern {.*}
	$w.filter2.entry delete 0 end
	$w.filter2.entry insert insert $listPattern
	mkInfoBox {} .@lpt$this Error "Bad regexp for list pattern:\n$msg"
    }
    if [string match {} [set topicPattern [$w.filter3.entry get]]] {
	set topicPattern {.*}
    } \
    elseif {[catch {regexp $topicPattern test} msg]} {
	set topicPattern {.*}
	$w.filter3.entry delete 0 end
	$w.filter3.entry insert insert $topicPattern
	mkInfoBox {} .@tpt$this Error "Bad regexp for topic pattern:\n$msg"
    }
    net_listline2 $this $param $pargs
}
#
proc net_listline2 {this param pargs} {
    global showList allChannels listPattern topicPattern
    upvar #0 $this ndata
    regsub -all {\\} $pargs {\\\\} pargs
    regsub -all "\t" $pargs "\\\t" pargs
    set chan [lindex $pargs 1]
    set w .@l$this
    if !$showList {
	switch -glob $chan {
	{\*}  { if !$ndata(showPrivate) { return } {set chan Prv } }
	&*  { if !$ndata(showLocal)   { return } }
	#*  { if !$ndata(showPublic)  { return } }
	}
    }
    set memb [lindex $pargs 2]
    if {$showList  || (($param != {} || !$ndata(topicOnly)) && \
      $memb >= $ndata(minMembers) && [regexp -nocase $listPattern $chan] && \
      [regexp $topicPattern $param])} {
	lappend allChannels $chan
	$w.chn.l insert end \
	  "[format {%-9s %3d %s} [string range $chan 0 8] $memb $param]"
    }
}
#
proc net_irc323 {this prefix param pargs} {
    global listFile showList zircon $this
    set showList 0
    set w .@l$this
    catch "grab release $w"
    catch "$w configure -cursor arrow"
    if ![string match {} $listFile($this)] {
	update
	if [winfo exists $w] {
	    seek $listFile($this) 0 start
	    set lcount 0
	    if [string match {} [set listPattern [$w.filter2.entry get]]] {
		set listPattern {.*}
	    } \
	    elseif {[catch {regexp $listPattern test} msg]} {
		set listPattern {.*}
		$w.filter2.entry delete 0 end
		$w.filter2.entry insert insert $listPattern
		mkInfoBox {} .@lpt$this Error "Bad regexp for list pattern:\n$msg"
	    }
	    if [string match {} [set topicPattern [$w.filter3.entry get]]] {
		set topicPattern {.*}
	    } \
	    elseif {[catch {regexp $topicPattern test} msg]} {
		set topicPattern {.*}
		$w.filter3.entry delete 0 end
		$w.filter3.entry insert insert $topicPattern
		mkInfoBox {} .@tpt$this Error "Bad regexp for topic pattern:\n$msg"
	    }
	    while {![eof $listFile($this)]} {
		gets $listFile($this) pg
		gets $listFile($this) top
		$this listline2 $top $pg
		if {[incr lcount] > 100} {
		    update
		    set lcount 0
		    if ![winfo exists $w] break
		}
	    }
	    if [set ${this}(sorted)] {
		set lb $w.chn.l		
		set lst [lsort [$lb get 0 end]]
		$lb delete 0 end
		eval $lb insert end $lst
	    }
	}
	catch {exec rm $zircon(tmp)/list[pid] }
    }
    catch {$w.btn.list configure -state normal}
}
#
proc net_deIRCOp {this} {
    global myid
    $this configure -ircop 0
    $this MODE [$myid name] -O
}
#
proc net_keepAway {this value} {
    $this AWAY $value
    [[$this control] window].bf1.away.menu add command \
      -label "[prune $value 15]" -command "$this AWAY {$value}"
    global aways confChange
    lappend aways $value
    set confChange 1
}
#
proc net_getAway {this} {
    global ztrans
    mkEntryBox .@away$this {Away Message} {Enter your away message:} \
      "{$ztrans(away) {}}" \
      "$ztrans(ok) {$this AWAY}" "$ztrans(keep) {$this keepAway}" \
      "$ztrans(back) {$this AWAY}" "$ztrans(cancel) {}"
}
#
proc net_doBRB {this args} {
    upvar #0 $this ndata
    set ctl [[$this control] window]
    if $ndata(away) {
	$ctl.bf1.brb conf -text BRB
	foreach id [Channel :: list] {if [$id active] { $id send back -nopop }}
	$this AWAY
    } {
	$ctl.bf1.brb conf -text Back
	foreach id [Channel :: list] {if [$id active] { $id send brb -nopop }}
	$this AWAY {Back soon.}
    }
}
#
proc net_setNickname {this nk} {
    global myid
    set nk [string range $nk 0 8]
    if {[$myid name] != $nk} {
	entrySet [[$this control] window].nSFrm.nickname.entry $nk
	foreach id [Channel :: list] { $id nickChange $myid $nk }
	$myid rename $nk
    }
}
#
proc net_changeNickname {this nk} { $this NICK $nk }
#
proc net_changeIRCName {this name} {
    global ircname
    if [$this active] {
	mkDialog {} .@warn Warning \
	  "Change will not take effect until next server change." {}
    }
    set ircname $name
}
#
proc net_irc305 {this} {
    upvar #0 $this ndata
    if $ndata(away) {invert [[$this control] window].bf1.away}
    set ndata(away) 0
}
#
proc net_irc306 {this} {
    upvar #0 $this ndata
    if !$ndata(away) {invert [[$this control] window].bf1.away}
    set ndata(away) 1
}
#
proc net_close {this args} {
    global zircon ztrans
    if ![$this active] return
    set host [$this host]
    $this closeSock {}
    $this flagControl disabled
    foreach id [Channel :: list] { $id flag disabled }
    $this irc305
    set zircon(j) 0
    if [string match {} $args] {
	set msg "Server $host has closed the connection."
    } {
	set msg [lindex $args 0]
    }
    bell
    handleOn CLOSE [list [$zircon(host) host] [$zircon(host) port]]
    if $zircon(reconnect) {
	mkDialog {} .@close$this $ztrans(shutdown) \
	  "$msg - $ztrans(reconnecting)." {}
	$this reconnect $host
    } {
	mkDialog {} .@close$this $ztrans(shutdown) $msg {} \
	  "$ztrans(dismiss) {}" "$ztrans(connect) {$this reconnect $host}"
    }
}
#
proc net_reconnect {this host} {
   set srv [Server :: find $host]
   $this startIRC $srv
}
#
proc net_monitorTest {this} {
    global monitor monitorTime
    if ![string match {} $monitor] {
	$this NAMES [join [split $monitor] ,]
	after $monitorTime "$this monitorTest"
    }
}
#
proc net_send {this op args} {
    upvar #0 $this ndata
    if ![string match {} $ndata(sock)] {
	set msg $op
 	if ![string match {:} [set last :[lindex $args end]]] {
	    if ![catch {set foo [lreplace $args end end]}] {
		append msg " $foo $last"
	    }
	}
	if [catch {ircsend $ndata(sock) $msg}] { $this close }
    }
}
#
proc net_qSend {this op args} {
    upvar #0 $this ndata
    if [catch {ircsend $ndata(sock) "$op [join $args]"}] { $this close }
}
#
proc net_q1Send {this op} {
    upvar #0 $this ndata ; if [catch {ircsend $ndata(sock) $op}] {$this close}
}
#
proc net_setupTests {this} {
    global closeTime testTime notifyInterval zircon
    set testTime $notifyInterval
    if {$closeTime > 0 && $closeTime < $notifyInterval} { 
	set testTime $closeTime
    }
    $this ISON
    if $zircon(ping) {
	upvar #0 $this ndata
	set ndata(ping) 0
	after $zircon(ping) "$this pingTest"
    }
    $this monitorTest
    after $notifyInterval "$this isonTest"
    after $testTime "$this ircTests"
}
#
proc net_ircTests {this} {
    global testTime closeTime zircon MkOp
    if {$closeTime > 0} {
	foreach id [Channel :: list] { $id inactive }
	foreach id [Chat :: list] { $id inactive }
	foreach id [Message :: list] { $id inactive }
	foreach id [Notice :: list] { $id inactive }
	foreach id [Net :: list] { [$id info] inactive }
    }
    incr zircon(idle) [expr {$testTime / 1000}]
    foreach id [array names MkOp] {
	if {![string match {} [info procs $id]] && [$id operator]} {
	    set flag +
	    set who {}
	    foreach n $MkOp($id) {
		if ![$id isOp $n] {
		    append flag o
		    lappend who [$n name]
		}
	    }
	    if ![string match {} $who] { $this MODE [$id name] $flag $who }
	}
	unset MkOp($id)
    }
    after $testTime "$this ircTests"
}
#
proc net_isonTest {this} {
    global notifyInterval
    $this ISON
    after $notifyInterval "$this isonTest"
}
#
proc net_pong {this} {upvar #0 $this ndata ; set ndata(ping) 0 }
#
proc net_pingTest {this} {
    global zircon
    upvar #0 $this ndata
    set nm [$this host]
    if $ndata(ping) {
	$this close "Server $nm is not responding - closing the connection"
    } {
	$this PING $nm
	set ndata(ping) 1
	after $zircon(ping) "$this pingTest"
    }
}
#
proc Net_list {} { return [array names Ninfo] }
#
#
proc net_cleanSplit {this h} {
    global Split Heal TSplit
    if [info exists Split($h)] {
	set frnd [$this friends]
	foreach user $Split($h) {
	    if [string compare nil [set msg [Message :: find $user]]] {
		$msg flag normal
		$msg addText {} \
		  "*** netsplit : [$user name] may have left IRC."
	    }
	    foreach id [Channel :: list] {
		if {[$id isJoined $user] &&
		  ![normal [$id window].cFrm.uFrm.userBtn.$user]} {
		    $id killUser $user
		}
	    }
	    $frnd remove $user
	    $user deref
	}
	unset Split($h)
    }
    catch { after cancel $TSplit($h) ; unset TSplit($h) }
    catch { after cancel $Heal($h) ; unset Heal($h) }
}
#
proc net_setMode {this chan mode args} {
    $this MODE $chan $mode [lindex $args 0]
}
#
# IRC Command procs
#
#
proc net_WHOIS {this nk args} {
    if ![string match {} $nk] {
	if [string match {} $args] {
	    $this qSend WHOIS :$nk
	} {
	    $this qSend WHOIS [lindex $args 0] :$nk
	}
    }
}
#
proc net_WHOWAS {this nk args} {
    if ![string match {} $nk] {
	if [string match {} $args] {
	    $this qSend WHOWAS :$nk
	} {
	    $this qSend WHOWAS $nk :[lindex $args 0]
	}
    }
}
#
proc net_INFO {this args} {
    if [string match {} $args] {$this q1Send INFO} {$this qSend INFO :[lindex $args 0]}
}
#
proc net_ISON {this} {
    global notify ; if ![string match {} $notify] { $this qSend ISON :[join $notify] }
}
#
proc net_SQUIT {this srv} { $this qSend SQUIT :$srv }
#
proc net_TIME {this nk} { $this qSend TIME :$nk }
#
proc net_PRIVMSG {this where what} { $this qSend PRIVMSG $where :$what }
#
proc net_NOTICE {this where what} {
    if {$where != {} && $what != {}} { $this qSend NOTICE $where :$what }
}
#
proc net_INVITE {this who where} {
    if {$who != {} && $where != {}} { $this qSend INVITE $who :$where }
}
#
proc net_KILL {this who why} { $this qSend KILL $who :$why }
#
proc net_KICK {this where who msg} { $this qSend KICK $where $who :$msg}
#
proc net_STATS {this p1 p2} { $this qSend STATS $p1 :$p2 }
#
proc net_USERHOST {this nk} { $this qSend USERHOST :$nk }
#
proc net_NICK {this name} {
    global startup
    if $startup {
	$this setNickname $name
    } {
	entrySet [[$this control] window].nSFrm.nickname.entry $name
    }
    $this qSend NICK :$name
}
proc net_MODE {this who mode args} {
    switch [llength $args] {
    0 {	$this qSend MODE $who :$mode }
    1 {	$this qSend MODE $who $mode :[lindex $args 0] }
    * { error "MODE Called with too many parameters" }
    }
}
#
proc net_AWAY {this args} {
    if {$args == {}} {$this q1Send AWAY} {$this qSend AWAY :[join $args]}
}
#
proc net_TOPIC {this chan args} {
    if [string match {} $args] {
	$this qSend TOPIC :$chan
    } {
	$this qSend TOPIC $chan :[lindex $args 0]
    }
}
#
proc net_CTCP {this cmd nk str} {$this qSend PRIVMSG $nk ":\001$cmd $str\001"}
#
proc net_PART {this chan args} {
    if [string match {} $args] {
	$this qSend PART :$chan
    } {
	$this qSend PART $chan :[lindex $args 0]
    }
}
#
proc net_OPER {this nk str} {
    if ![string match {} $str] { $this qSend OPER  $nk :$str }
}
#
proc net_NAMES {this chan} { $this qSend NAMES :$chan }
#
proc net_PING {this srv} { $this qSend PING :$srv}
#
proc net_error {this prefix param pargs} {
    global startup
    set hst [$this hostname]
    if $startup {
	set msg "Cannot connect to $hst :$param"
    } {
	set msg "Closing connection to $hst, ERROR : $param"
    }
    $this close $msg
}
