/* d_mos1.cc
 *$Header: /al/acs/src/RCS/d_mos1.cc,v 9.21 95/10/21 18:09:16 al Exp $
 * mos model equations: spice level 1 equivalent
 */
#include "d_mos.h"
#include "error.h"
#include "io.h"
#include "u_opt.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_MOS::eval_mos1(CARD*);
/*--------------------------------------------------------------------------*/
/*static*/ void DEV_MOS::eval_mos1(CARD *brh)
{
  DEV_MOS* This = (DEV_MOS*)brh;
  assert(This);
  const MOS_COMMON* c = (const MOS_COMMON*)This->common;
  assert(c);
  const MODEL_MOS* m = (const MODEL_MOS*)c->model;
  assert(m);

  double sarg;
  double dsarg_dvbs;

  if (This->vbs <= 0.){
    sarg = sqrt(m->phi - This->vbs);
    dsarg_dvbs = -.5 / sarg;
    This->sbfwd = FALSE;
  }else{
    double sphi3 = pow(m->phi, 1.5);
    sarg = sqrt(m->phi) / (1. + .5 * This->vbs / m->phi);
    dsarg_dvbs = -.5 * sarg * sarg / sphi3;	/* is wrong!! */
    This->sbfwd = TRUE;
    if (!IO::suppresserrors){
      error((sarg <= 0.) ? bPICKY : bTRACE,
	    "%s: source fwd biased.  vbs=%g\n", brh->printlabel(), This->vbs);
    }
  }

  This->von = m->vto + m->gamma * (sarg - sqrt(m->phi));
  This->vgst = This->vdsat = This->vgs - This->von;
  if (This->vdsat < 0.)
    This->vdsat = 0.;
  This->cutoff = (This->vgst < 0.);
  This->saturated = (This->vds > This->vdsat);
  
  double lambda = (m->lambda != NOT_INPUT) ? m->lambda : 0.;

  if (This->cutoff){
    This->gds = This->gm = This->ids = This->gmb = 0.;
  }else if (This->saturated){
    This->gm  = c->beta * This->vgst * (1. + lambda * This->vds);
    This->ids = This->gm * (.5 * This->vgst);
    This->gds = .5 * c->beta * lambda * This->vgst * This->vgst;
    This->gmb = - This->gm * m->gamma * dsarg_dvbs;
  }else{ /* linear */
    This->gm  = c->beta * This->vds * (1. + lambda * This->vds);
    This->ids = This->gm * (This->vgst - .5*This->vds);
    This->gds = c->beta * ((This->vgst - This->vds) 
    		     + lambda * This->vds * (2.*This->vgst - 1.5*This->vds));
    This->gmb = - This->gm * m->gamma * dsarg_dvbs;
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
