/* c__cmd.cc
 $Header: /al/acs/src/RCS/c__cmd.cc,v 9.21 95/10/21 18:08:48 al Exp $
 * command interpreter and dispatcher
 */
#include "ap.h"
#include "error.h"
#include "io.h"
#include "u_opt.h"
#include "u_timer.h"
#include "c_comand.h"
#include "declare.h"	/* plclose */
/*--------------------------------------------------------------------------*/
//	void	CMD::cmdproc(const char*);
/*--------------------------------------------------------------------------*/
/* cmdproc: process a command
 * parse, and act on, a command string
 */
void CMD::cmdproc(const char *cmd)
{
  CS cs(cmd);
  static TIMER timecheck;
  int didsomething = TRUE;
  
  error(bTRACE, "%s\n", cmd);
  
  timecheck.check();
  timecheck.zstart();
  if (cs.argparse(ONEPASS,
	"Ac",	    aFFUNCTION,	 ac,
	"ALArm",    aFFUNCTION,	 alarm,
	"ALTer",    aFFUNCTION,	 alter,
	"Build",    aFFUNCTION,  build,
	"CHDir",    aFFUNCTION,  chdir,
	"CDir",	    aFFUNCTION,  chdir,
	"CLEAR",    aFFUNCTION,  clear,
	"CRTSET",   aFFUNCTION,  crtset,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	"DC",	    aFFUNCTION,	 dc,
	"DELete",   aFFUNCTION,  del,
	"DIsto",    aFFUNCTION,	 disto,
	"Edit",	    aFFUNCTION,  edit,
	"END",	    aFFUNCTION,	 end,
	"ENDS",	    aFFUNCTION,	 ends,
	"EXIt",	    aFFUNCTION,  quit,
	"FANout",   aFFUNCTION,  fanout,
	"FAult",    aFFUNCTION,	 fault,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	"FOurier",  aFFUNCTION,	 fourier,
	"Generator",aFFUNCTION,  generator,
	"GET",	    aFFUNCTION,  get,
	"Help",	    aFFUNCTION,  help,
	"IC",	    aFFUNCTION,	 ic,
	"INsert",   aFFUNCTION,  insert,
	"List",	    aFFUNCTION,  list,
	"LOg",	    aFFUNCTION,	 logger,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	"MArk",	    aFFUNCTION,	 mark,
	"MErge",    aFFUNCTION,  merge,
	"MODEl",    aFFUNCTION,	 model,
	"Modify",   aFFUNCTION,  modify,
	"NODeset",  aFFUNCTION,	 nodeset,
	"NOIse",    aFFUNCTION,	 noise,
	"OP",	    aFFUNCTION,	 op,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	"OPTions",  aFFUNCTION,  options,
	"PAuse",    aFFUNCTION,	 pause,
	"PLot",	    aFFUNCTION,  plot,
	"PRint",    aFFUNCTION,  print,
	"PRobe",    aFFUNCTION,  print,
	"Quit",	    aFFUNCTION,  quit,
	"Restore",  aFFUNCTION,  restore,
	"SAve",	    aFFUNCTION,  save,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	"SENs",	    aFFUNCTION,	 sens,
	"SEt",	    aFFUNCTION,  options,
	"SPectrum", aFFUNCTION,	 fourier,
	"STatus",   aFFUNCTION,  status,
	"SUbckt",   aFFUNCTION,	 subckt,
	"SWeep",    aFFUNCTION,  sweep,
	"TEmp",	    aFFUNCTION,	 temp,
	"TF",	    aFFUNCTION,	 tf,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	"TItle",    aFFUNCTION,  title,
	"TRansient",aFFUNCTION,	 tr,
	"UNFault",  aFFUNCTION,	 unfault,
	"UNMark",   aFFUNCTION,	 unmark,
	"Width",    aFFUNCTION,	 options,
	"!",	    aFFUNCTION,  system,
	"<",	    aFFUNCTION,	 run,
	""))
    ;	/* split to hide sun lint bug. */
  else if (cs.argparse(ONEPASS,
	">",	    aFFUNCTION,	 file,
	""))
    ;
  else{    /* comment or error */
    comment(cs);
    didsomething = FALSE;
  }
  if (OPT::acct  &&  didsomething){
    timecheck.check();
    mprintf(IO::mstdout,"time=%8.2f\n", timecheck.elapsed());
  }
  plclose();
  IO::suppresserrors = FALSE;
  outreset();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
